<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_LabelImageType StructType
 * @subpackage Structs
 */
class DocTypeRef_LabelImageType extends AbstractStructBase
{
    /**
     * The LabelImageFormat
     * Meta information extracted from the WSDL
     * - documentation: Mapped from Request Document. Currently always “PDF”
     * - base: xsd:token
     * - maxLength: 3
     * - whiteSpace: collapse
     * @var string
     */
    public $LabelImageFormat;
    /**
     * The GraphicImage
     * Meta information extracted from the WSDL
     * - documentation: This field contains the actual label as Base64 Binary. There will be one document containing all the labels for each package/piece on separate pages.
     * @var string
     */
    public $GraphicImage;
    /**
     * The HTMLImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HTMLImage;
    /**
     * Constructor method for docTypeRef_LabelImageType
     * @uses DocTypeRef_LabelImageType::setLabelImageFormat()
     * @uses DocTypeRef_LabelImageType::setGraphicImage()
     * @uses DocTypeRef_LabelImageType::setHTMLImage()
     * @param string $labelImageFormat
     * @param string $graphicImage
     * @param string $hTMLImage
     */
    public function __construct($labelImageFormat = null, $graphicImage = null, $hTMLImage = null)
    {
        $this
            ->setLabelImageFormat($labelImageFormat)
            ->setGraphicImage($graphicImage)
            ->setHTMLImage($hTMLImage);
    }
    /**
     * Get LabelImageFormat value
     * @return string|null
     */
    public function getLabelImageFormat()
    {
        return $this->LabelImageFormat;
    }
    /**
     * Set LabelImageFormat value
     * @param string $labelImageFormat
     * @return \StructType\DocTypeRef_LabelImageType
     */
    public function setLabelImageFormat($labelImageFormat = null)
    {
        // validation for constraint: string
        if (!is_null($labelImageFormat) && !is_string($labelImageFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelImageFormat, true), gettype($labelImageFormat)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($labelImageFormat) && mb_strlen($labelImageFormat) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($labelImageFormat)), __LINE__);
        }
        $this->LabelImageFormat = $labelImageFormat;
        return $this;
    }
    /**
     * Get GraphicImage value
     * @return string|null
     */
    public function getGraphicImage()
    {
        return $this->GraphicImage;
    }
    /**
     * Set GraphicImage value
     * @param string $graphicImage
     * @return \StructType\DocTypeRef_LabelImageType
     */
    public function setGraphicImage($graphicImage = null)
    {
        // validation for constraint: string
        if (!is_null($graphicImage) && !is_string($graphicImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($graphicImage, true), gettype($graphicImage)), __LINE__);
        }
        $this->GraphicImage = $graphicImage;
        return $this;
    }
    /**
     * Get HTMLImage value
     * @return string|null
     */
    public function getHTMLImage()
    {
        return $this->HTMLImage;
    }
    /**
     * Set HTMLImage value
     * @param string $hTMLImage
     * @return \StructType\DocTypeRef_LabelImageType
     */
    public function setHTMLImage($hTMLImage = null)
    {
        // validation for constraint: string
        if (!is_null($hTMLImage) && !is_string($hTMLImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hTMLImage, true), gettype($hTMLImage)), __LINE__);
        }
        $this->HTMLImage = $hTMLImage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocTypeRef_LabelImageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
