<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_CommoditiesType StructType
 * @subpackage Structs
 */
class DocTypeRef_CommoditiesType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: The description of the content of the shipment
     * - base: xsd:token
     * - maxLength: 70
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $Description;
    /**
     * The CustomsValue
     * Meta information extracted from the WSDL
     * - documentation: The value which needs to be declared for customs
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - minOccurs: 0
     * - totalDigits: 18
     * - whiteSpace: collapse
     * @var float
     */
    public $CustomsValue;
    /**
     * The USFilingTypeValue
     * Meta information extracted from the WSDL
     * - documentation: USFilingTypeValue is a field meant for US export/import EEI Filing (ITN Number, FTR Number and AES4 Number
     * - base: xsd:string
     * - maxLength: 20
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $USFilingTypeValue;
    /**
     * Constructor method for docTypeRef_CommoditiesType
     * @uses DocTypeRef_CommoditiesType::setDescription()
     * @uses DocTypeRef_CommoditiesType::setCustomsValue()
     * @uses DocTypeRef_CommoditiesType::setUSFilingTypeValue()
     * @param string $description
     * @param float $customsValue
     * @param string $uSFilingTypeValue
     */
    public function __construct($description = null, $customsValue = null, $uSFilingTypeValue = null)
    {
        $this
            ->setDescription($description)
            ->setCustomsValue($customsValue)
            ->setUSFilingTypeValue($uSFilingTypeValue);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\DocTypeRef_CommoditiesType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($description) && mb_strlen($description) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($description) && mb_strlen($description) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CustomsValue value
     * @return float|null
     */
    public function getCustomsValue()
    {
        return $this->CustomsValue;
    }
    /**
     * Set CustomsValue value
     * @param float $customsValue
     * @return \StructType\DocTypeRef_CommoditiesType
     */
    public function setCustomsValue($customsValue = null)
    {
        // validation for constraint: float
        if (!is_null($customsValue) && !(is_float($customsValue) || is_numeric($customsValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($customsValue, true), gettype($customsValue)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($customsValue) && mb_strlen(mb_substr($customsValue, mb_strpos($customsValue, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($customsValue, true), mb_strlen(mb_substr($customsValue, mb_strpos($customsValue, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($customsValue) && mb_strlen(preg_replace('/(\D)/', '', $customsValue)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($customsValue, true), mb_strlen(preg_replace('/(\D)/', '', $customsValue))), __LINE__);
        }
        $this->CustomsValue = $customsValue;
        return $this;
    }
    /**
     * Get USFilingTypeValue value
     * @return string|null
     */
    public function getUSFilingTypeValue()
    {
        return $this->USFilingTypeValue;
    }
    /**
     * Set USFilingTypeValue value
     * @param string $uSFilingTypeValue
     * @return \StructType\DocTypeRef_CommoditiesType
     */
    public function setUSFilingTypeValue($uSFilingTypeValue = null)
    {
        // validation for constraint: string
        if (!is_null($uSFilingTypeValue) && !is_string($uSFilingTypeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uSFilingTypeValue, true), gettype($uSFilingTypeValue)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($uSFilingTypeValue) && mb_strlen($uSFilingTypeValue) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($uSFilingTypeValue)), __LINE__);
        }
        $this->USFilingTypeValue = $uSFilingTypeValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocTypeRef_CommoditiesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
