<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_BankDetail StructType
 * @subpackage Structs
 */
class DocTypeRef_BankDetail extends AbstractStructBase
{
    /**
     * The BankName
     * Meta information extracted from the WSDL
     * - documentation: To be mapped in Customs Invoice - Russia Bank Name field
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The BankSettlementAccountNumberInLocalCurrency
     * Meta information extracted from the WSDL
     * - documentation: To be mapped in Customs Invoice - Russia Bank Settlement Account Number in RUR field
     * - minOccurs: 0
     * @var string
     */
    public $BankSettlementAccountNumberInLocalCurrency;
    /**
     * The BankSettlementAccountNumberInForeignCurrency
     * Meta information extracted from the WSDL
     * - documentation: To be mapped in Customs Invoice - Russia Bank Settlement Account Number in RUR field
     * - minOccurs: 0
     * @var string
     */
    public $BankSettlementAccountNumberInForeignCurrency;
    /**
     * Constructor method for docTypeRef_BankDetail
     * @uses DocTypeRef_BankDetail::setBankName()
     * @uses DocTypeRef_BankDetail::setBankSettlementAccountNumberInLocalCurrency()
     * @uses DocTypeRef_BankDetail::setBankSettlementAccountNumberInForeignCurrency()
     * @param string $bankName
     * @param string $bankSettlementAccountNumberInLocalCurrency
     * @param string $bankSettlementAccountNumberInForeignCurrency
     */
    public function __construct($bankName = null, $bankSettlementAccountNumberInLocalCurrency = null, $bankSettlementAccountNumberInForeignCurrency = null)
    {
        $this
            ->setBankName($bankName)
            ->setBankSettlementAccountNumberInLocalCurrency($bankSettlementAccountNumberInLocalCurrency)
            ->setBankSettlementAccountNumberInForeignCurrency($bankSettlementAccountNumberInForeignCurrency);
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \StructType\DocTypeRef_BankDetail
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get BankSettlementAccountNumberInLocalCurrency value
     * @return string|null
     */
    public function getBankSettlementAccountNumberInLocalCurrency()
    {
        return $this->BankSettlementAccountNumberInLocalCurrency;
    }
    /**
     * Set BankSettlementAccountNumberInLocalCurrency value
     * @param string $bankSettlementAccountNumberInLocalCurrency
     * @return \StructType\DocTypeRef_BankDetail
     */
    public function setBankSettlementAccountNumberInLocalCurrency($bankSettlementAccountNumberInLocalCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($bankSettlementAccountNumberInLocalCurrency) && !is_string($bankSettlementAccountNumberInLocalCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankSettlementAccountNumberInLocalCurrency, true), gettype($bankSettlementAccountNumberInLocalCurrency)), __LINE__);
        }
        $this->BankSettlementAccountNumberInLocalCurrency = $bankSettlementAccountNumberInLocalCurrency;
        return $this;
    }
    /**
     * Get BankSettlementAccountNumberInForeignCurrency value
     * @return string|null
     */
    public function getBankSettlementAccountNumberInForeignCurrency()
    {
        return $this->BankSettlementAccountNumberInForeignCurrency;
    }
    /**
     * Set BankSettlementAccountNumberInForeignCurrency value
     * @param string $bankSettlementAccountNumberInForeignCurrency
     * @return \StructType\DocTypeRef_BankDetail
     */
    public function setBankSettlementAccountNumberInForeignCurrency($bankSettlementAccountNumberInForeignCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($bankSettlementAccountNumberInForeignCurrency) && !is_string($bankSettlementAccountNumberInForeignCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankSettlementAccountNumberInForeignCurrency, true), gettype($bankSettlementAccountNumberInForeignCurrency)), __LINE__);
        }
        $this->BankSettlementAccountNumberInForeignCurrency = $bankSettlementAccountNumberInForeignCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocTypeRef_BankDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
