<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargesType StructType
 * @subpackage Structs
 */
class ChargesType extends AbstractStructBase
{
    /**
     * The ChargeType
     * @var string
     */
    public $ChargeType;
    /**
     * The ChargeAmount
     * Meta information extracted from the WSDL
     * - documentation: The total charge amount of the specific charge
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - totalDigits: 12
     * @var float
     */
    public $ChargeAmount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: The currency code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 3
     * - whiteSpace: collapse
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for ChargesType
     * @uses ChargesType::setChargeType()
     * @uses ChargesType::setChargeAmount()
     * @uses ChargesType::setCurrencyCode()
     * @param string $chargeType
     * @param float $chargeAmount
     * @param string $currencyCode
     */
    public function __construct($chargeType = null, $chargeAmount = null, $currencyCode = null)
    {
        $this
            ->setChargeType($chargeType)
            ->setChargeAmount($chargeAmount)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get ChargeType value
     * @return string|null
     */
    public function getChargeType()
    {
        return $this->ChargeType;
    }
    /**
     * Set ChargeType value
     * @uses \EnumType\ChargeType::valueIsValid()
     * @uses \EnumType\ChargeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $chargeType
     * @return \StructType\ChargesType
     */
    public function setChargeType($chargeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ChargeType::valueIsValid($chargeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ChargeType', is_array($chargeType) ? implode(', ', $chargeType) : var_export($chargeType, true), implode(', ', \EnumType\ChargeType::getValidValues())), __LINE__);
        }
        $this->ChargeType = $chargeType;
        return $this;
    }
    /**
     * Get ChargeAmount value
     * @return float|null
     */
    public function getChargeAmount()
    {
        return $this->ChargeAmount;
    }
    /**
     * Set ChargeAmount value
     * @param float $chargeAmount
     * @return \StructType\ChargesType
     */
    public function setChargeAmount($chargeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($chargeAmount) && !(is_float($chargeAmount) || is_numeric($chargeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($chargeAmount, true), gettype($chargeAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($chargeAmount) && mb_strlen(mb_substr($chargeAmount, mb_strpos($chargeAmount, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($chargeAmount, true), mb_strlen(mb_substr($chargeAmount, mb_strpos($chargeAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($chargeAmount) && mb_strlen(preg_replace('/(\D)/', '', $chargeAmount)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($chargeAmount, true), mb_strlen(preg_replace('/(\D)/', '', $chargeAmount))), __LINE__);
        }
        $this->ChargeAmount = $chargeAmount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\ChargesType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($currencyCode) && mb_strlen($currencyCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($currencyCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($currencyCode) && mb_strlen($currencyCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChargesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
