<?php

namespace EnumType;

/**
 * This class stands for DeliveryOption EnumType
 * @subpackage Enumerations
 */
class DeliveryOption
{
    /**
     * Constant for value 'TV'
     * @return string 'TV'
     */
    const VALUE_TV = 'TV';
    /**
     * Constant for value 'SW'
     * @return string 'SW'
     */
    const VALUE_SW = 'SW';
    /**
     * Constant for value 'SX'
     * @return string 'SX'
     */
    const VALUE_SX = 'SX';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TV
     * @uses self::VALUE_SW
     * @uses self::VALUE_SX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TV,
            self::VALUE_SW,
            self::VALUE_SX,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
