<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebsiteType StructType
 * @subpackage Structs
 */
class WebsiteType extends AbstractStructBase
{
    /**
     * The WEBSITE_ID
     * @var int
     */
    public $WEBSITE_ID;
    /**
     * The NAME
     * @var string
     */
    public $NAME;
    /**
     * The DOMAIN
     * @var string
     */
    public $DOMAIN;
    /**
     * The LOCALE
     * @var string
     */
    public $LOCALE;
    /**
     * Constructor method for WebsiteType
     * @uses WebsiteType::setWEBSITE_ID()
     * @uses WebsiteType::setNAME()
     * @uses WebsiteType::setDOMAIN()
     * @uses WebsiteType::setLOCALE()
     * @param int $wEBSITE_ID
     * @param string $nAME
     * @param string $dOMAIN
     * @param string $lOCALE
     */
    public function __construct($wEBSITE_ID = null, $nAME = null, $dOMAIN = null, $lOCALE = null)
    {
        $this
            ->setWEBSITE_ID($wEBSITE_ID)
            ->setNAME($nAME)
            ->setDOMAIN($dOMAIN)
            ->setLOCALE($lOCALE);
    }
    /**
     * Get WEBSITE_ID value
     * @return int|null
     */
    public function getWEBSITE_ID()
    {
        return $this->WEBSITE_ID;
    }
    /**
     * Set WEBSITE_ID value
     * @param int $wEBSITE_ID
     * @return \StructType\WebsiteType
     */
    public function setWEBSITE_ID($wEBSITE_ID = null)
    {
        // validation for constraint: int
        if (!is_null($wEBSITE_ID) && !(is_int($wEBSITE_ID) || ctype_digit($wEBSITE_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wEBSITE_ID, true), gettype($wEBSITE_ID)), __LINE__);
        }
        $this->WEBSITE_ID = $wEBSITE_ID;
        return $this;
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \StructType\WebsiteType
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nAME, true), gettype($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get DOMAIN value
     * @return string|null
     */
    public function getDOMAIN()
    {
        return $this->DOMAIN;
    }
    /**
     * Set DOMAIN value
     * @param string $dOMAIN
     * @return \StructType\WebsiteType
     */
    public function setDOMAIN($dOMAIN = null)
    {
        // validation for constraint: string
        if (!is_null($dOMAIN) && !is_string($dOMAIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dOMAIN, true), gettype($dOMAIN)), __LINE__);
        }
        $this->DOMAIN = $dOMAIN;
        return $this;
    }
    /**
     * Get LOCALE value
     * @return string|null
     */
    public function getLOCALE()
    {
        return $this->LOCALE;
    }
    /**
     * Set LOCALE value
     * @param string $lOCALE
     * @return \StructType\WebsiteType
     */
    public function setLOCALE($lOCALE = null)
    {
        // validation for constraint: string
        if (!is_null($lOCALE) && !is_string($lOCALE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lOCALE, true), gettype($lOCALE)), __LINE__);
        }
        $this->LOCALE = $lOCALE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebsiteType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
