<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebOrderType StructType
 * @subpackage Structs
 */
class WebOrderType extends AbstractStructBase
{
    /**
     * The ORDER
     * @var \StructType\OrderDetailsType
     */
    public $ORDER;
    /**
     * The CUSTOMER
     * @var \StructType\CustomerType
     */
    public $CUSTOMER;
    /**
     * The PRODUCTS
     * @var \StructType\OrderProductsContainerType
     */
    public $PRODUCTS;
    /**
     * The PAYMENT
     * @var \StructType\PaymentType
     */
    public $PAYMENT;
    /**
     * The TRANSACTION_BREAKDOWN
     * @var \StructType\TransactionBreakdownType
     */
    public $TRANSACTION_BREAKDOWN;
    /**
     * The DISCOUNTS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DiscountsContainerType
     */
    public $DISCOUNTS;
    /**
     * Constructor method for WebOrderType
     * @uses WebOrderType::setORDER()
     * @uses WebOrderType::setCUSTOMER()
     * @uses WebOrderType::setPRODUCTS()
     * @uses WebOrderType::setPAYMENT()
     * @uses WebOrderType::setTRANSACTION_BREAKDOWN()
     * @uses WebOrderType::setDISCOUNTS()
     * @param \StructType\OrderDetailsType $oRDER
     * @param \StructType\CustomerType $cUSTOMER
     * @param \StructType\OrderProductsContainerType $pRODUCTS
     * @param \StructType\PaymentType $pAYMENT
     * @param \StructType\TransactionBreakdownType $tRANSACTION_BREAKDOWN
     * @param \StructType\DiscountsContainerType $dISCOUNTS
     */
    public function __construct(\StructType\OrderDetailsType $oRDER = null, \StructType\CustomerType $cUSTOMER = null, \StructType\OrderProductsContainerType $pRODUCTS = null, \StructType\PaymentType $pAYMENT = null, \StructType\TransactionBreakdownType $tRANSACTION_BREAKDOWN = null, \StructType\DiscountsContainerType $dISCOUNTS = null)
    {
        $this
            ->setORDER($oRDER)
            ->setCUSTOMER($cUSTOMER)
            ->setPRODUCTS($pRODUCTS)
            ->setPAYMENT($pAYMENT)
            ->setTRANSACTION_BREAKDOWN($tRANSACTION_BREAKDOWN)
            ->setDISCOUNTS($dISCOUNTS);
    }
    /**
     * Get ORDER value
     * @return \StructType\OrderDetailsType|null
     */
    public function getORDER()
    {
        return $this->ORDER;
    }
    /**
     * Set ORDER value
     * @param \StructType\OrderDetailsType $oRDER
     * @return \StructType\WebOrderType
     */
    public function setORDER(\StructType\OrderDetailsType $oRDER = null)
    {
        $this->ORDER = $oRDER;
        return $this;
    }
    /**
     * Get CUSTOMER value
     * @return \StructType\CustomerType|null
     */
    public function getCUSTOMER()
    {
        return $this->CUSTOMER;
    }
    /**
     * Set CUSTOMER value
     * @param \StructType\CustomerType $cUSTOMER
     * @return \StructType\WebOrderType
     */
    public function setCUSTOMER(\StructType\CustomerType $cUSTOMER = null)
    {
        $this->CUSTOMER = $cUSTOMER;
        return $this;
    }
    /**
     * Get PRODUCTS value
     * @return \StructType\OrderProductsContainerType|null
     */
    public function getPRODUCTS()
    {
        return $this->PRODUCTS;
    }
    /**
     * Set PRODUCTS value
     * @param \StructType\OrderProductsContainerType $pRODUCTS
     * @return \StructType\WebOrderType
     */
    public function setPRODUCTS(\StructType\OrderProductsContainerType $pRODUCTS = null)
    {
        $this->PRODUCTS = $pRODUCTS;
        return $this;
    }
    /**
     * Get PAYMENT value
     * @return \StructType\PaymentType|null
     */
    public function getPAYMENT()
    {
        return $this->PAYMENT;
    }
    /**
     * Set PAYMENT value
     * @param \StructType\PaymentType $pAYMENT
     * @return \StructType\WebOrderType
     */
    public function setPAYMENT(\StructType\PaymentType $pAYMENT = null)
    {
        $this->PAYMENT = $pAYMENT;
        return $this;
    }
    /**
     * Get TRANSACTION_BREAKDOWN value
     * @return \StructType\TransactionBreakdownType|null
     */
    public function getTRANSACTION_BREAKDOWN()
    {
        return $this->TRANSACTION_BREAKDOWN;
    }
    /**
     * Set TRANSACTION_BREAKDOWN value
     * @param \StructType\TransactionBreakdownType $tRANSACTION_BREAKDOWN
     * @return \StructType\WebOrderType
     */
    public function setTRANSACTION_BREAKDOWN(\StructType\TransactionBreakdownType $tRANSACTION_BREAKDOWN = null)
    {
        $this->TRANSACTION_BREAKDOWN = $tRANSACTION_BREAKDOWN;
        return $this;
    }
    /**
     * Get DISCOUNTS value
     * @return \StructType\DiscountsContainerType|null
     */
    public function getDISCOUNTS()
    {
        return $this->DISCOUNTS;
    }
    /**
     * Set DISCOUNTS value
     * @param \StructType\DiscountsContainerType $dISCOUNTS
     * @return \StructType\WebOrderType
     */
    public function setDISCOUNTS(\StructType\DiscountsContainerType $dISCOUNTS = null)
    {
        $this->DISCOUNTS = $dISCOUNTS;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebOrderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
