<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UPSELLING_GROUP StructType
 * @subpackage Structs
 */
class UPSELLING_GROUP extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The UPSELL
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: unbounded
     * - minLength: 1
     * @var string[]
     */
    public $UPSELL;
    /**
     * Constructor method for UPSELLING_GROUP
     * @uses UPSELLING_GROUP::setName()
     * @uses UPSELLING_GROUP::setUPSELL()
     * @param string $name
     * @param string[] $uPSELL
     */
    public function __construct($name = null, array $uPSELL = array())
    {
        $this
            ->setName($name)
            ->setUPSELL($uPSELL);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\UPSELLING_GROUP
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name) && mb_strlen($name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get UPSELL value
     * @return string[]|null
     */
    public function getUPSELL()
    {
        return $this->UPSELL;
    }
    /**
     * This method is responsible for validating the values passed to the setUPSELL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUPSELL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUPSELLForArrayConstraintsFromSetUPSELL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uPSELLING_GROUPUPSELLItem) {
            // validation for constraint: itemType
            if (!is_string($uPSELLING_GROUPUPSELLItem)) {
                $invalidValues[] = is_object($uPSELLING_GROUPUPSELLItem) ? get_class($uPSELLING_GROUPUPSELLItem) : sprintf('%s(%s)', gettype($uPSELLING_GROUPUPSELLItem), var_export($uPSELLING_GROUPUPSELLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UPSELL property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setUPSELL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUPSELL method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUPSELLForMinLengthConstraintFromSetUPSELL($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uPSELLING_GROUPUPSELLItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($uPSELLING_GROUPUPSELLItem) < 1) {
                $invalidValues[] = var_export($uPSELLING_GROUPUPSELLItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UPSELL value
     * @throws \InvalidArgumentException
     * @param string[] $uPSELL
     * @return \StructType\UPSELLING_GROUP
     */
    public function setUPSELL(array $uPSELL = array())
    {
        // validation for constraint: array
        if ('' !== ($uPSELLArrayErrorMessage = self::validateUPSELLForArrayConstraintsFromSetUPSELL($uPSELL))) {
            throw new \InvalidArgumentException($uPSELLArrayErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($uPSELLMinLengthErrorMessage = self::validateUPSELLForMinLengthConstraintFromSetUPSELL($uPSELL))) {
            throw new \InvalidArgumentException($uPSELLMinLengthErrorMessage, __LINE__);
        }
        $this->UPSELL = $uPSELL;
        return $this;
    }
    /**
     * Add item to UPSELL value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\UPSELLING_GROUP
     */
    public function addToUPSELL($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The UPSELL property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->UPSELL[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UPSELLING_GROUP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
