<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubProductType StructType
 * @subpackage Structs
 */
class SubProductType extends AbstractStructBase
{
    /**
     * The REFERENCE
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minLength: 1
     * @var string
     */
    public $REFERENCE;
    /**
     * The ATTRIBUTES
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AttributesType
     */
    public $ATTRIBUTES;
    /**
     * The TITLE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TITLE;
    /**
     * The ACTIVE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ACTIVE;
    /**
     * The DELETE
     * Meta information extracted from the WSDL
     * - default: false
     * - minOccurs: 0
     * @var bool
     */
    public $DELETE;
    /**
     * The STOCK
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $STOCK;
    /**
     * The STOCK_LOCATIONS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StockLocationsType
     */
    public $STOCK_LOCATIONS;
    /**
     * The WEIGHT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $WEIGHT;
    /**
     * The MODEL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MODEL;
    /**
     * The EAN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EAN;
    /**
     * The MPN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MPN;
    /**
     * The ISBN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ISBN;
    /**
     * The UPC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UPC;
    /**
     * The PRICE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PRICE;
    /**
     * The SALE_PRICE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SALE_PRICE;
    /**
     * The RRP_PRICE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RRP_PRICE;
    /**
     * The COST_PRICE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $COST_PRICE;
    /**
     * The VAT_RATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VAT_RATE;
    /**
     * The DISPLAY_ON_SALE_PAGE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DISPLAY_ON_SALE_PAGE;
    /**
     * The IMAGES
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ImagesType
     */
    public $IMAGES;
    /**
     * The PICK_LOCATION
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PICK_LOCATION;
    /**
     * The STOCK_MESSAGE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $STOCK_MESSAGE;
    /**
     * Constructor method for SubProductType
     * @uses SubProductType::setREFERENCE()
     * @uses SubProductType::setATTRIBUTES()
     * @uses SubProductType::setTITLE()
     * @uses SubProductType::setACTIVE()
     * @uses SubProductType::setDELETE()
     * @uses SubProductType::setSTOCK()
     * @uses SubProductType::setSTOCK_LOCATIONS()
     * @uses SubProductType::setWEIGHT()
     * @uses SubProductType::setMODEL()
     * @uses SubProductType::setEAN()
     * @uses SubProductType::setMPN()
     * @uses SubProductType::setISBN()
     * @uses SubProductType::setUPC()
     * @uses SubProductType::setPRICE()
     * @uses SubProductType::setSALE_PRICE()
     * @uses SubProductType::setRRP_PRICE()
     * @uses SubProductType::setCOST_PRICE()
     * @uses SubProductType::setVAT_RATE()
     * @uses SubProductType::setDISPLAY_ON_SALE_PAGE()
     * @uses SubProductType::setIMAGES()
     * @uses SubProductType::setPICK_LOCATION()
     * @uses SubProductType::setSTOCK_MESSAGE()
     * @param string $rEFERENCE
     * @param \StructType\AttributesType $aTTRIBUTES
     * @param string $tITLE
     * @param bool $aCTIVE
     * @param bool $dELETE
     * @param int $sTOCK
     * @param \StructType\StockLocationsType $sTOCK_LOCATIONS
     * @param string $wEIGHT
     * @param string $mODEL
     * @param string $eAN
     * @param string $mPN
     * @param string $iSBN
     * @param string $uPC
     * @param string $pRICE
     * @param string $sALE_PRICE
     * @param string $rRP_PRICE
     * @param string $cOST_PRICE
     * @param float $vAT_RATE
     * @param bool $dISPLAY_ON_SALE_PAGE
     * @param \StructType\ImagesType $iMAGES
     * @param string $pICK_LOCATION
     * @param string $sTOCK_MESSAGE
     */
    public function __construct($rEFERENCE = null, \StructType\AttributesType $aTTRIBUTES = null, $tITLE = null, $aCTIVE = null, $dELETE = false, $sTOCK = null, \StructType\StockLocationsType $sTOCK_LOCATIONS = null, $wEIGHT = null, $mODEL = null, $eAN = null, $mPN = null, $iSBN = null, $uPC = null, $pRICE = null, $sALE_PRICE = null, $rRP_PRICE = null, $cOST_PRICE = null, $vAT_RATE = null, $dISPLAY_ON_SALE_PAGE = null, \StructType\ImagesType $iMAGES = null, $pICK_LOCATION = null, $sTOCK_MESSAGE = null)
    {
        $this
            ->setREFERENCE($rEFERENCE)
            ->setATTRIBUTES($aTTRIBUTES)
            ->setTITLE($tITLE)
            ->setACTIVE($aCTIVE)
            ->setDELETE($dELETE)
            ->setSTOCK($sTOCK)
            ->setSTOCK_LOCATIONS($sTOCK_LOCATIONS)
            ->setWEIGHT($wEIGHT)
            ->setMODEL($mODEL)
            ->setEAN($eAN)
            ->setMPN($mPN)
            ->setISBN($iSBN)
            ->setUPC($uPC)
            ->setPRICE($pRICE)
            ->setSALE_PRICE($sALE_PRICE)
            ->setRRP_PRICE($rRP_PRICE)
            ->setCOST_PRICE($cOST_PRICE)
            ->setVAT_RATE($vAT_RATE)
            ->setDISPLAY_ON_SALE_PAGE($dISPLAY_ON_SALE_PAGE)
            ->setIMAGES($iMAGES)
            ->setPICK_LOCATION($pICK_LOCATION)
            ->setSTOCK_MESSAGE($sTOCK_MESSAGE);
    }
    /**
     * Get REFERENCE value
     * @return string|null
     */
    public function getREFERENCE()
    {
        return $this->REFERENCE;
    }
    /**
     * Set REFERENCE value
     * @param string $rEFERENCE
     * @return \StructType\SubProductType
     */
    public function setREFERENCE($rEFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($rEFERENCE) && !is_string($rEFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rEFERENCE, true), gettype($rEFERENCE)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($rEFERENCE) && mb_strlen($rEFERENCE) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($rEFERENCE)), __LINE__);
        }
        $this->REFERENCE = $rEFERENCE;
        return $this;
    }
    /**
     * Get ATTRIBUTES value
     * @return \StructType\AttributesType|null
     */
    public function getATTRIBUTES()
    {
        return $this->ATTRIBUTES;
    }
    /**
     * Set ATTRIBUTES value
     * @param \StructType\AttributesType $aTTRIBUTES
     * @return \StructType\SubProductType
     */
    public function setATTRIBUTES(\StructType\AttributesType $aTTRIBUTES = null)
    {
        $this->ATTRIBUTES = $aTTRIBUTES;
        return $this;
    }
    /**
     * Get TITLE value
     * @return string|null
     */
    public function getTITLE()
    {
        return $this->TITLE;
    }
    /**
     * Set TITLE value
     * @param string $tITLE
     * @return \StructType\SubProductType
     */
    public function setTITLE($tITLE = null)
    {
        // validation for constraint: string
        if (!is_null($tITLE) && !is_string($tITLE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tITLE, true), gettype($tITLE)), __LINE__);
        }
        $this->TITLE = $tITLE;
        return $this;
    }
    /**
     * Get ACTIVE value
     * @return bool|null
     */
    public function getACTIVE()
    {
        return $this->ACTIVE;
    }
    /**
     * Set ACTIVE value
     * @param bool $aCTIVE
     * @return \StructType\SubProductType
     */
    public function setACTIVE($aCTIVE = null)
    {
        // validation for constraint: boolean
        if (!is_null($aCTIVE) && !is_bool($aCTIVE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aCTIVE, true), gettype($aCTIVE)), __LINE__);
        }
        $this->ACTIVE = $aCTIVE;
        return $this;
    }
    /**
     * Get DELETE value
     * @return bool|null
     */
    public function getDELETE()
    {
        return $this->DELETE;
    }
    /**
     * Set DELETE value
     * @param bool $dELETE
     * @return \StructType\SubProductType
     */
    public function setDELETE($dELETE = false)
    {
        // validation for constraint: boolean
        if (!is_null($dELETE) && !is_bool($dELETE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dELETE, true), gettype($dELETE)), __LINE__);
        }
        $this->DELETE = $dELETE;
        return $this;
    }
    /**
     * Get STOCK value
     * @return int|null
     */
    public function getSTOCK()
    {
        return $this->STOCK;
    }
    /**
     * Set STOCK value
     * @param int $sTOCK
     * @return \StructType\SubProductType
     */
    public function setSTOCK($sTOCK = null)
    {
        // validation for constraint: int
        if (!is_null($sTOCK) && !(is_int($sTOCK) || ctype_digit($sTOCK))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sTOCK, true), gettype($sTOCK)), __LINE__);
        }
        $this->STOCK = $sTOCK;
        return $this;
    }
    /**
     * Get STOCK_LOCATIONS value
     * @return \StructType\StockLocationsType|null
     */
    public function getSTOCK_LOCATIONS()
    {
        return $this->STOCK_LOCATIONS;
    }
    /**
     * Set STOCK_LOCATIONS value
     * @param \StructType\StockLocationsType $sTOCK_LOCATIONS
     * @return \StructType\SubProductType
     */
    public function setSTOCK_LOCATIONS(\StructType\StockLocationsType $sTOCK_LOCATIONS = null)
    {
        $this->STOCK_LOCATIONS = $sTOCK_LOCATIONS;
        return $this;
    }
    /**
     * Get WEIGHT value
     * @return string|null
     */
    public function getWEIGHT()
    {
        return $this->WEIGHT;
    }
    /**
     * Set WEIGHT value
     * @param string $wEIGHT
     * @return \StructType\SubProductType
     */
    public function setWEIGHT($wEIGHT = null)
    {
        // validation for constraint: string
        if (!is_null($wEIGHT) && !is_string($wEIGHT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wEIGHT, true), gettype($wEIGHT)), __LINE__);
        }
        $this->WEIGHT = $wEIGHT;
        return $this;
    }
    /**
     * Get MODEL value
     * @return string|null
     */
    public function getMODEL()
    {
        return $this->MODEL;
    }
    /**
     * Set MODEL value
     * @param string $mODEL
     * @return \StructType\SubProductType
     */
    public function setMODEL($mODEL = null)
    {
        // validation for constraint: string
        if (!is_null($mODEL) && !is_string($mODEL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mODEL, true), gettype($mODEL)), __LINE__);
        }
        $this->MODEL = $mODEL;
        return $this;
    }
    /**
     * Get EAN value
     * @return string|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param string $eAN
     * @return \StructType\SubProductType
     */
    public function setEAN($eAN = null)
    {
        // validation for constraint: string
        if (!is_null($eAN) && !is_string($eAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eAN, true), gettype($eAN)), __LINE__);
        }
        $this->EAN = $eAN;
        return $this;
    }
    /**
     * Get MPN value
     * @return string|null
     */
    public function getMPN()
    {
        return $this->MPN;
    }
    /**
     * Set MPN value
     * @param string $mPN
     * @return \StructType\SubProductType
     */
    public function setMPN($mPN = null)
    {
        // validation for constraint: string
        if (!is_null($mPN) && !is_string($mPN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mPN, true), gettype($mPN)), __LINE__);
        }
        $this->MPN = $mPN;
        return $this;
    }
    /**
     * Get ISBN value
     * @return string|null
     */
    public function getISBN()
    {
        return $this->ISBN;
    }
    /**
     * Set ISBN value
     * @param string $iSBN
     * @return \StructType\SubProductType
     */
    public function setISBN($iSBN = null)
    {
        // validation for constraint: string
        if (!is_null($iSBN) && !is_string($iSBN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iSBN, true), gettype($iSBN)), __LINE__);
        }
        $this->ISBN = $iSBN;
        return $this;
    }
    /**
     * Get UPC value
     * @return string|null
     */
    public function getUPC()
    {
        return $this->UPC;
    }
    /**
     * Set UPC value
     * @param string $uPC
     * @return \StructType\SubProductType
     */
    public function setUPC($uPC = null)
    {
        // validation for constraint: string
        if (!is_null($uPC) && !is_string($uPC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uPC, true), gettype($uPC)), __LINE__);
        }
        $this->UPC = $uPC;
        return $this;
    }
    /**
     * Get PRICE value
     * @return string|null
     */
    public function getPRICE()
    {
        return $this->PRICE;
    }
    /**
     * Set PRICE value
     * @param string $pRICE
     * @return \StructType\SubProductType
     */
    public function setPRICE($pRICE = null)
    {
        // validation for constraint: string
        if (!is_null($pRICE) && !is_string($pRICE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pRICE, true), gettype($pRICE)), __LINE__);
        }
        $this->PRICE = $pRICE;
        return $this;
    }
    /**
     * Get SALE_PRICE value
     * @return string|null
     */
    public function getSALE_PRICE()
    {
        return $this->SALE_PRICE;
    }
    /**
     * Set SALE_PRICE value
     * @param string $sALE_PRICE
     * @return \StructType\SubProductType
     */
    public function setSALE_PRICE($sALE_PRICE = null)
    {
        // validation for constraint: string
        if (!is_null($sALE_PRICE) && !is_string($sALE_PRICE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sALE_PRICE, true), gettype($sALE_PRICE)), __LINE__);
        }
        $this->SALE_PRICE = $sALE_PRICE;
        return $this;
    }
    /**
     * Get RRP_PRICE value
     * @return string|null
     */
    public function getRRP_PRICE()
    {
        return $this->RRP_PRICE;
    }
    /**
     * Set RRP_PRICE value
     * @param string $rRP_PRICE
     * @return \StructType\SubProductType
     */
    public function setRRP_PRICE($rRP_PRICE = null)
    {
        // validation for constraint: string
        if (!is_null($rRP_PRICE) && !is_string($rRP_PRICE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rRP_PRICE, true), gettype($rRP_PRICE)), __LINE__);
        }
        $this->RRP_PRICE = $rRP_PRICE;
        return $this;
    }
    /**
     * Get COST_PRICE value
     * @return string|null
     */
    public function getCOST_PRICE()
    {
        return $this->COST_PRICE;
    }
    /**
     * Set COST_PRICE value
     * @param string $cOST_PRICE
     * @return \StructType\SubProductType
     */
    public function setCOST_PRICE($cOST_PRICE = null)
    {
        // validation for constraint: string
        if (!is_null($cOST_PRICE) && !is_string($cOST_PRICE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cOST_PRICE, true), gettype($cOST_PRICE)), __LINE__);
        }
        $this->COST_PRICE = $cOST_PRICE;
        return $this;
    }
    /**
     * Get VAT_RATE value
     * @return float|null
     */
    public function getVAT_RATE()
    {
        return $this->VAT_RATE;
    }
    /**
     * Set VAT_RATE value
     * @param float $vAT_RATE
     * @return \StructType\SubProductType
     */
    public function setVAT_RATE($vAT_RATE = null)
    {
        // validation for constraint: float
        if (!is_null($vAT_RATE) && !(is_float($vAT_RATE) || is_numeric($vAT_RATE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vAT_RATE, true), gettype($vAT_RATE)), __LINE__);
        }
        $this->VAT_RATE = $vAT_RATE;
        return $this;
    }
    /**
     * Get DISPLAY_ON_SALE_PAGE value
     * @return bool|null
     */
    public function getDISPLAY_ON_SALE_PAGE()
    {
        return $this->DISPLAY_ON_SALE_PAGE;
    }
    /**
     * Set DISPLAY_ON_SALE_PAGE value
     * @param bool $dISPLAY_ON_SALE_PAGE
     * @return \StructType\SubProductType
     */
    public function setDISPLAY_ON_SALE_PAGE($dISPLAY_ON_SALE_PAGE = null)
    {
        // validation for constraint: boolean
        if (!is_null($dISPLAY_ON_SALE_PAGE) && !is_bool($dISPLAY_ON_SALE_PAGE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dISPLAY_ON_SALE_PAGE, true), gettype($dISPLAY_ON_SALE_PAGE)), __LINE__);
        }
        $this->DISPLAY_ON_SALE_PAGE = $dISPLAY_ON_SALE_PAGE;
        return $this;
    }
    /**
     * Get IMAGES value
     * @return \StructType\ImagesType|null
     */
    public function getIMAGES()
    {
        return $this->IMAGES;
    }
    /**
     * Set IMAGES value
     * @param \StructType\ImagesType $iMAGES
     * @return \StructType\SubProductType
     */
    public function setIMAGES(\StructType\ImagesType $iMAGES = null)
    {
        $this->IMAGES = $iMAGES;
        return $this;
    }
    /**
     * Get PICK_LOCATION value
     * @return string|null
     */
    public function getPICK_LOCATION()
    {
        return $this->PICK_LOCATION;
    }
    /**
     * Set PICK_LOCATION value
     * @param string $pICK_LOCATION
     * @return \StructType\SubProductType
     */
    public function setPICK_LOCATION($pICK_LOCATION = null)
    {
        // validation for constraint: string
        if (!is_null($pICK_LOCATION) && !is_string($pICK_LOCATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pICK_LOCATION, true), gettype($pICK_LOCATION)), __LINE__);
        }
        $this->PICK_LOCATION = $pICK_LOCATION;
        return $this;
    }
    /**
     * Get STOCK_MESSAGE value
     * @return string|null
     */
    public function getSTOCK_MESSAGE()
    {
        return $this->STOCK_MESSAGE;
    }
    /**
     * Set STOCK_MESSAGE value
     * @param string $sTOCK_MESSAGE
     * @return \StructType\SubProductType
     */
    public function setSTOCK_MESSAGE($sTOCK_MESSAGE = null)
    {
        // validation for constraint: string
        if (!is_null($sTOCK_MESSAGE) && !is_string($sTOCK_MESSAGE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sTOCK_MESSAGE, true), gettype($sTOCK_MESSAGE)), __LINE__);
        }
        $this->STOCK_MESSAGE = $sTOCK_MESSAGE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubProductType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
