<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for stock_location StructType
 * @subpackage Structs
 */
class Stock_location_1 extends AbstractStructBase
{
    /**
     * The stock_location_name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minLength: 1
     * @var string
     */
    public $stock_location_name;
    /**
     * The stock_level
     * @var float
     */
    public $stock_level;
    /**
     * Constructor method for stock_location
     * @uses Stock_location_1::setStock_location_name()
     * @uses Stock_location_1::setStock_level()
     * @param string $stock_location_name
     * @param float $stock_level
     */
    public function __construct($stock_location_name = null, $stock_level = null)
    {
        $this
            ->setStock_location_name($stock_location_name)
            ->setStock_level($stock_level);
    }
    /**
     * Get stock_location_name value
     * @return string|null
     */
    public function getStock_location_name()
    {
        return $this->stock_location_name;
    }
    /**
     * Set stock_location_name value
     * @param string $stock_location_name
     * @return \StructType\Stock_location_1
     */
    public function setStock_location_name($stock_location_name = null)
    {
        // validation for constraint: string
        if (!is_null($stock_location_name) && !is_string($stock_location_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stock_location_name, true), gettype($stock_location_name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($stock_location_name) && mb_strlen($stock_location_name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($stock_location_name)), __LINE__);
        }
        $this->stock_location_name = $stock_location_name;
        return $this;
    }
    /**
     * Get stock_level value
     * @return float|null
     */
    public function getStock_level()
    {
        return $this->stock_level;
    }
    /**
     * Set stock_level value
     * @param float $stock_level
     * @return \StructType\Stock_location_1
     */
    public function setStock_level($stock_level = null)
    {
        // validation for constraint: float
        if (!is_null($stock_level) && !(is_float($stock_level) || is_numeric($stock_level))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($stock_level, true), gettype($stock_level)), __LINE__);
        }
        $this->stock_level = $stock_level;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Stock_location_1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
