<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for stock_level StructType
 * @subpackage Structs
 */
class Stock_level extends AbstractStructBase
{
    /**
     * The product_reference
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $product_reference;
    /**
     * The stock_level
     * Meta information extracted from the WSDL
     * - choice: stock_level | stock_locations
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var float
     */
    public $stock_level;
    /**
     * The stock_locations
     * Meta information extracted from the WSDL
     * - choice: stock_level | stock_locations
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Stock_locations
     */
    public $stock_locations;
    /**
     * Constructor method for stock_level
     * @uses Stock_level::setProduct_reference()
     * @uses Stock_level::setStock_level()
     * @uses Stock_level::setStock_locations()
     * @param string $product_reference
     * @param float $stock_level
     * @param \StructType\Stock_locations $stock_locations
     */
    public function __construct($product_reference = null, $stock_level = null, \StructType\Stock_locations $stock_locations = null)
    {
        $this
            ->setProduct_reference($product_reference)
            ->setStock_level($stock_level)
            ->setStock_locations($stock_locations);
    }
    /**
     * Get product_reference value
     * @return string
     */
    public function getProduct_reference()
    {
        return $this->product_reference;
    }
    /**
     * Set product_reference value
     * @param string $product_reference
     * @return \StructType\Stock_level
     */
    public function setProduct_reference($product_reference = null)
    {
        // validation for constraint: string
        if (!is_null($product_reference) && !is_string($product_reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product_reference, true), gettype($product_reference)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($product_reference) && mb_strlen($product_reference) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($product_reference)), __LINE__);
        }
        $this->product_reference = $product_reference;
        return $this;
    }
    /**
     * Get stock_level value
     * @return float|null
     */
    public function getStock_level()
    {
        return isset($this->stock_level) ? $this->stock_level : null;
    }
    /**
     * This method is responsible for validating the value passed to the setStock_level method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStock_level method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateStock_levelForChoiceConstraintsFromSetStock_level($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'stock_locations',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property stock_level can\'t be set as the property %s is already set. Only one property must be set among these properties: stock_level, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set stock_level value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $stock_level
     * @return \StructType\Stock_level
     */
    public function setStock_level($stock_level = null)
    {
        // validation for constraint: float
        if (!is_null($stock_level) && !(is_float($stock_level) || is_numeric($stock_level))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($stock_level, true), gettype($stock_level)), __LINE__);
        }
        // validation for constraint: choice(stock_level, stock_locations)
        if ('' !== ($stock_levelChoiceErrorMessage = self::validateStock_levelForChoiceConstraintsFromSetStock_level($stock_level))) {
            throw new \InvalidArgumentException($stock_levelChoiceErrorMessage, __LINE__);
        }
        if (is_null($stock_level) || (is_array($stock_level) && empty($stock_level))) {
            unset($this->stock_level);
        } else {
            $this->stock_level = $stock_level;
        }
        return $this;
    }
    /**
     * Get stock_locations value
     * @return \StructType\Stock_locations|null
     */
    public function getStock_locations()
    {
        return isset($this->stock_locations) ? $this->stock_locations : null;
    }
    /**
     * This method is responsible for validating the value passed to the setStock_locations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStock_locations method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateStock_locationsForChoiceConstraintsFromSetStock_locations($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'stock_level',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property stock_locations can\'t be set as the property %s is already set. Only one property must be set among these properties: stock_locations, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set stock_locations value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Stock_locations $stock_locations
     * @return \StructType\Stock_level
     */
    public function setStock_locations(\StructType\Stock_locations $stock_locations = null)
    {
        // validation for constraint: choice(stock_level, stock_locations)
        if ('' !== ($stock_locationsChoiceErrorMessage = self::validateStock_locationsForChoiceConstraintsFromSetStock_locations($stock_locations))) {
            throw new \InvalidArgumentException($stock_locationsChoiceErrorMessage, __LINE__);
        }
        if (is_null($stock_locations) || (is_array($stock_locations) && empty($stock_locations))) {
            unset($this->stock_locations);
        } else {
            $this->stock_locations = $stock_locations;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Stock_level
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
