<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimpleCustomerType StructType
 * @subpackage Structs
 */
class SimpleCustomerType extends AbstractStructBase
{
    /**
     * The CUSTOMER_ID
     * @var int
     */
    public $CUSTOMER_ID;
    /**
     * The REFERENCE
     * @var string
     */
    public $REFERENCE;
    /**
     * The EMAIL_ADDRESS
     * @var string
     */
    public $EMAIL_ADDRESS;
    /**
     * The NAME
     * @var string
     */
    public $NAME;
    /**
     * Constructor method for SimpleCustomerType
     * @uses SimpleCustomerType::setCUSTOMER_ID()
     * @uses SimpleCustomerType::setREFERENCE()
     * @uses SimpleCustomerType::setEMAIL_ADDRESS()
     * @uses SimpleCustomerType::setNAME()
     * @param int $cUSTOMER_ID
     * @param string $rEFERENCE
     * @param string $eMAIL_ADDRESS
     * @param string $nAME
     */
    public function __construct($cUSTOMER_ID = null, $rEFERENCE = null, $eMAIL_ADDRESS = null, $nAME = null)
    {
        $this
            ->setCUSTOMER_ID($cUSTOMER_ID)
            ->setREFERENCE($rEFERENCE)
            ->setEMAIL_ADDRESS($eMAIL_ADDRESS)
            ->setNAME($nAME);
    }
    /**
     * Get CUSTOMER_ID value
     * @return int|null
     */
    public function getCUSTOMER_ID()
    {
        return $this->CUSTOMER_ID;
    }
    /**
     * Set CUSTOMER_ID value
     * @param int $cUSTOMER_ID
     * @return \StructType\SimpleCustomerType
     */
    public function setCUSTOMER_ID($cUSTOMER_ID = null)
    {
        // validation for constraint: int
        if (!is_null($cUSTOMER_ID) && !(is_int($cUSTOMER_ID) || ctype_digit($cUSTOMER_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cUSTOMER_ID, true), gettype($cUSTOMER_ID)), __LINE__);
        }
        $this->CUSTOMER_ID = $cUSTOMER_ID;
        return $this;
    }
    /**
     * Get REFERENCE value
     * @return string|null
     */
    public function getREFERENCE()
    {
        return $this->REFERENCE;
    }
    /**
     * Set REFERENCE value
     * @param string $rEFERENCE
     * @return \StructType\SimpleCustomerType
     */
    public function setREFERENCE($rEFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($rEFERENCE) && !is_string($rEFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rEFERENCE, true), gettype($rEFERENCE)), __LINE__);
        }
        $this->REFERENCE = $rEFERENCE;
        return $this;
    }
    /**
     * Get EMAIL_ADDRESS value
     * @return string|null
     */
    public function getEMAIL_ADDRESS()
    {
        return $this->EMAIL_ADDRESS;
    }
    /**
     * Set EMAIL_ADDRESS value
     * @param string $eMAIL_ADDRESS
     * @return \StructType\SimpleCustomerType
     */
    public function setEMAIL_ADDRESS($eMAIL_ADDRESS = null)
    {
        // validation for constraint: string
        if (!is_null($eMAIL_ADDRESS) && !is_string($eMAIL_ADDRESS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMAIL_ADDRESS, true), gettype($eMAIL_ADDRESS)), __LINE__);
        }
        $this->EMAIL_ADDRESS = $eMAIL_ADDRESS;
        return $this;
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \StructType\SimpleCustomerType
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nAME, true), gettype($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SimpleCustomerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
