<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultType StructType
 * @subpackage Structs
 */
class ResultType extends AbstractStructBase
{
    /**
     * The ServiceVersion
     * @var int
     */
    public $ServiceVersion;
    /**
     * The RequestID
     * @var int
     */
    public $RequestID;
    /**
     * The DateTime
     * @var string
     */
    public $DateTime;
    /**
     * The Errors
     * @var \StructType\ResultErrorsType
     */
    public $Errors;
    /**
     * The Warnings
     * @var \StructType\ResultWarningsType
     */
    public $Warnings;
    /**
     * The Result
     * @var \StructType\Result
     */
    public $Result;
    /**
     * Constructor method for ResultType
     * @uses ResultType::setServiceVersion()
     * @uses ResultType::setRequestID()
     * @uses ResultType::setDateTime()
     * @uses ResultType::setErrors()
     * @uses ResultType::setWarnings()
     * @uses ResultType::setResult()
     * @param int $serviceVersion
     * @param int $requestID
     * @param string $dateTime
     * @param \StructType\ResultErrorsType $errors
     * @param \StructType\ResultWarningsType $warnings
     * @param \StructType\Result $result
     */
    public function __construct($serviceVersion = null, $requestID = null, $dateTime = null, \StructType\ResultErrorsType $errors = null, \StructType\ResultWarningsType $warnings = null, \StructType\Result $result = null)
    {
        $this
            ->setServiceVersion($serviceVersion)
            ->setRequestID($requestID)
            ->setDateTime($dateTime)
            ->setErrors($errors)
            ->setWarnings($warnings)
            ->setResult($result);
    }
    /**
     * Get ServiceVersion value
     * @return int|null
     */
    public function getServiceVersion()
    {
        return $this->ServiceVersion;
    }
    /**
     * Set ServiceVersion value
     * @param int $serviceVersion
     * @return \StructType\ResultType
     */
    public function setServiceVersion($serviceVersion = null)
    {
        // validation for constraint: int
        if (!is_null($serviceVersion) && !(is_int($serviceVersion) || ctype_digit($serviceVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceVersion, true), gettype($serviceVersion)), __LINE__);
        }
        $this->ServiceVersion = $serviceVersion;
        return $this;
    }
    /**
     * Get RequestID value
     * @return int|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param int $requestID
     * @return \StructType\ResultType
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: int
        if (!is_null($requestID) && !(is_int($requestID) || ctype_digit($requestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestID, true), gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\ResultType
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\ResultErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\ResultErrorsType $errors
     * @return \StructType\ResultType
     */
    public function setErrors(\StructType\ResultErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\ResultWarningsType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \StructType\ResultWarningsType $warnings
     * @return \StructType\ResultType
     */
    public function setWarnings(\StructType\ResultWarningsType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get Result value
     * @return \StructType\Result|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\ResultType
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResultType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
