<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductType StructType
 * @subpackage Structs
 */
class ProductType extends AbstractStructBase
{
    /**
     * The REFERENCE
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minLength: 1
     * @var string
     */
    public $REFERENCE;
    /**
     * The TITLE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TITLE;
    /**
     * The BRAND
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BRAND;
    /**
     * The SUBTITLE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SUBTITLE;
    /**
     * The SUMMARY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SUMMARY;
    /**
     * The DESCRIPTION
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DESCRIPTION;
    /**
     * The SEO_TITLE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SEO_TITLE;
    /**
     * The SEO_DESCRIPTION
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SEO_DESCRIPTION;
    /**
     * The SEO_KEYWORDS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SEO_KEYWORDS;
    /**
     * The ACTIVE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ACTIVE;
    /**
     * The IMAGES
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ImagesType
     */
    public $IMAGES;
    /**
     * The DEPARTMENTS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CategoriesType
     */
    public $DEPARTMENTS;
    /**
     * The TAGS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TagsType
     */
    public $TAGS;
    /**
     * The UPSELLING
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UpsellingType
     */
    public $UPSELLING;
    /**
     * The SUBPRODUCTS
     * @var \StructType\SubProductsContainerType
     */
    public $SUBPRODUCTS;
    /**
     * Constructor method for ProductType
     * @uses ProductType::setREFERENCE()
     * @uses ProductType::setTITLE()
     * @uses ProductType::setBRAND()
     * @uses ProductType::setSUBTITLE()
     * @uses ProductType::setSUMMARY()
     * @uses ProductType::setDESCRIPTION()
     * @uses ProductType::setSEO_TITLE()
     * @uses ProductType::setSEO_DESCRIPTION()
     * @uses ProductType::setSEO_KEYWORDS()
     * @uses ProductType::setACTIVE()
     * @uses ProductType::setIMAGES()
     * @uses ProductType::setDEPARTMENTS()
     * @uses ProductType::setTAGS()
     * @uses ProductType::setUPSELLING()
     * @uses ProductType::setSUBPRODUCTS()
     * @param string $rEFERENCE
     * @param string $tITLE
     * @param string $bRAND
     * @param string $sUBTITLE
     * @param string $sUMMARY
     * @param string $dESCRIPTION
     * @param string $sEO_TITLE
     * @param string $sEO_DESCRIPTION
     * @param string $sEO_KEYWORDS
     * @param bool $aCTIVE
     * @param \StructType\ImagesType $iMAGES
     * @param \StructType\CategoriesType $dEPARTMENTS
     * @param \StructType\TagsType $tAGS
     * @param \StructType\UpsellingType $uPSELLING
     * @param \StructType\SubProductsContainerType $sUBPRODUCTS
     */
    public function __construct($rEFERENCE = null, $tITLE = null, $bRAND = null, $sUBTITLE = null, $sUMMARY = null, $dESCRIPTION = null, $sEO_TITLE = null, $sEO_DESCRIPTION = null, $sEO_KEYWORDS = null, $aCTIVE = null, \StructType\ImagesType $iMAGES = null, \StructType\CategoriesType $dEPARTMENTS = null, \StructType\TagsType $tAGS = null, \StructType\UpsellingType $uPSELLING = null, \StructType\SubProductsContainerType $sUBPRODUCTS = null)
    {
        $this
            ->setREFERENCE($rEFERENCE)
            ->setTITLE($tITLE)
            ->setBRAND($bRAND)
            ->setSUBTITLE($sUBTITLE)
            ->setSUMMARY($sUMMARY)
            ->setDESCRIPTION($dESCRIPTION)
            ->setSEO_TITLE($sEO_TITLE)
            ->setSEO_DESCRIPTION($sEO_DESCRIPTION)
            ->setSEO_KEYWORDS($sEO_KEYWORDS)
            ->setACTIVE($aCTIVE)
            ->setIMAGES($iMAGES)
            ->setDEPARTMENTS($dEPARTMENTS)
            ->setTAGS($tAGS)
            ->setUPSELLING($uPSELLING)
            ->setSUBPRODUCTS($sUBPRODUCTS);
    }
    /**
     * Get REFERENCE value
     * @return string|null
     */
    public function getREFERENCE()
    {
        return $this->REFERENCE;
    }
    /**
     * Set REFERENCE value
     * @param string $rEFERENCE
     * @return \StructType\ProductType
     */
    public function setREFERENCE($rEFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($rEFERENCE) && !is_string($rEFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rEFERENCE, true), gettype($rEFERENCE)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($rEFERENCE) && mb_strlen($rEFERENCE) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($rEFERENCE)), __LINE__);
        }
        $this->REFERENCE = $rEFERENCE;
        return $this;
    }
    /**
     * Get TITLE value
     * @return string|null
     */
    public function getTITLE()
    {
        return $this->TITLE;
    }
    /**
     * Set TITLE value
     * @param string $tITLE
     * @return \StructType\ProductType
     */
    public function setTITLE($tITLE = null)
    {
        // validation for constraint: string
        if (!is_null($tITLE) && !is_string($tITLE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tITLE, true), gettype($tITLE)), __LINE__);
        }
        $this->TITLE = $tITLE;
        return $this;
    }
    /**
     * Get BRAND value
     * @return string|null
     */
    public function getBRAND()
    {
        return $this->BRAND;
    }
    /**
     * Set BRAND value
     * @param string $bRAND
     * @return \StructType\ProductType
     */
    public function setBRAND($bRAND = null)
    {
        // validation for constraint: string
        if (!is_null($bRAND) && !is_string($bRAND)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bRAND, true), gettype($bRAND)), __LINE__);
        }
        $this->BRAND = $bRAND;
        return $this;
    }
    /**
     * Get SUBTITLE value
     * @return string|null
     */
    public function getSUBTITLE()
    {
        return $this->SUBTITLE;
    }
    /**
     * Set SUBTITLE value
     * @param string $sUBTITLE
     * @return \StructType\ProductType
     */
    public function setSUBTITLE($sUBTITLE = null)
    {
        // validation for constraint: string
        if (!is_null($sUBTITLE) && !is_string($sUBTITLE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUBTITLE, true), gettype($sUBTITLE)), __LINE__);
        }
        $this->SUBTITLE = $sUBTITLE;
        return $this;
    }
    /**
     * Get SUMMARY value
     * @return string|null
     */
    public function getSUMMARY()
    {
        return $this->SUMMARY;
    }
    /**
     * Set SUMMARY value
     * @param string $sUMMARY
     * @return \StructType\ProductType
     */
    public function setSUMMARY($sUMMARY = null)
    {
        // validation for constraint: string
        if (!is_null($sUMMARY) && !is_string($sUMMARY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUMMARY, true), gettype($sUMMARY)), __LINE__);
        }
        $this->SUMMARY = $sUMMARY;
        return $this;
    }
    /**
     * Get DESCRIPTION value
     * @return string|null
     */
    public function getDESCRIPTION()
    {
        return $this->DESCRIPTION;
    }
    /**
     * Set DESCRIPTION value
     * @param string $dESCRIPTION
     * @return \StructType\ProductType
     */
    public function setDESCRIPTION($dESCRIPTION = null)
    {
        // validation for constraint: string
        if (!is_null($dESCRIPTION) && !is_string($dESCRIPTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dESCRIPTION, true), gettype($dESCRIPTION)), __LINE__);
        }
        $this->DESCRIPTION = $dESCRIPTION;
        return $this;
    }
    /**
     * Get SEO_TITLE value
     * @return string|null
     */
    public function getSEO_TITLE()
    {
        return $this->SEO_TITLE;
    }
    /**
     * Set SEO_TITLE value
     * @param string $sEO_TITLE
     * @return \StructType\ProductType
     */
    public function setSEO_TITLE($sEO_TITLE = null)
    {
        // validation for constraint: string
        if (!is_null($sEO_TITLE) && !is_string($sEO_TITLE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sEO_TITLE, true), gettype($sEO_TITLE)), __LINE__);
        }
        $this->SEO_TITLE = $sEO_TITLE;
        return $this;
    }
    /**
     * Get SEO_DESCRIPTION value
     * @return string|null
     */
    public function getSEO_DESCRIPTION()
    {
        return $this->SEO_DESCRIPTION;
    }
    /**
     * Set SEO_DESCRIPTION value
     * @param string $sEO_DESCRIPTION
     * @return \StructType\ProductType
     */
    public function setSEO_DESCRIPTION($sEO_DESCRIPTION = null)
    {
        // validation for constraint: string
        if (!is_null($sEO_DESCRIPTION) && !is_string($sEO_DESCRIPTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sEO_DESCRIPTION, true), gettype($sEO_DESCRIPTION)), __LINE__);
        }
        $this->SEO_DESCRIPTION = $sEO_DESCRIPTION;
        return $this;
    }
    /**
     * Get SEO_KEYWORDS value
     * @return string|null
     */
    public function getSEO_KEYWORDS()
    {
        return $this->SEO_KEYWORDS;
    }
    /**
     * Set SEO_KEYWORDS value
     * @param string $sEO_KEYWORDS
     * @return \StructType\ProductType
     */
    public function setSEO_KEYWORDS($sEO_KEYWORDS = null)
    {
        // validation for constraint: string
        if (!is_null($sEO_KEYWORDS) && !is_string($sEO_KEYWORDS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sEO_KEYWORDS, true), gettype($sEO_KEYWORDS)), __LINE__);
        }
        $this->SEO_KEYWORDS = $sEO_KEYWORDS;
        return $this;
    }
    /**
     * Get ACTIVE value
     * @return bool|null
     */
    public function getACTIVE()
    {
        return $this->ACTIVE;
    }
    /**
     * Set ACTIVE value
     * @param bool $aCTIVE
     * @return \StructType\ProductType
     */
    public function setACTIVE($aCTIVE = null)
    {
        // validation for constraint: boolean
        if (!is_null($aCTIVE) && !is_bool($aCTIVE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aCTIVE, true), gettype($aCTIVE)), __LINE__);
        }
        $this->ACTIVE = $aCTIVE;
        return $this;
    }
    /**
     * Get IMAGES value
     * @return \StructType\ImagesType|null
     */
    public function getIMAGES()
    {
        return $this->IMAGES;
    }
    /**
     * Set IMAGES value
     * @param \StructType\ImagesType $iMAGES
     * @return \StructType\ProductType
     */
    public function setIMAGES(\StructType\ImagesType $iMAGES = null)
    {
        $this->IMAGES = $iMAGES;
        return $this;
    }
    /**
     * Get DEPARTMENTS value
     * @return \StructType\CategoriesType|null
     */
    public function getDEPARTMENTS()
    {
        return $this->DEPARTMENTS;
    }
    /**
     * Set DEPARTMENTS value
     * @param \StructType\CategoriesType $dEPARTMENTS
     * @return \StructType\ProductType
     */
    public function setDEPARTMENTS(\StructType\CategoriesType $dEPARTMENTS = null)
    {
        $this->DEPARTMENTS = $dEPARTMENTS;
        return $this;
    }
    /**
     * Get TAGS value
     * @return \StructType\TagsType|null
     */
    public function getTAGS()
    {
        return $this->TAGS;
    }
    /**
     * Set TAGS value
     * @param \StructType\TagsType $tAGS
     * @return \StructType\ProductType
     */
    public function setTAGS(\StructType\TagsType $tAGS = null)
    {
        $this->TAGS = $tAGS;
        return $this;
    }
    /**
     * Get UPSELLING value
     * @return \StructType\UpsellingType|null
     */
    public function getUPSELLING()
    {
        return $this->UPSELLING;
    }
    /**
     * Set UPSELLING value
     * @param \StructType\UpsellingType $uPSELLING
     * @return \StructType\ProductType
     */
    public function setUPSELLING(\StructType\UpsellingType $uPSELLING = null)
    {
        $this->UPSELLING = $uPSELLING;
        return $this;
    }
    /**
     * Get SUBPRODUCTS value
     * @return \StructType\SubProductsContainerType|null
     */
    public function getSUBPRODUCTS()
    {
        return $this->SUBPRODUCTS;
    }
    /**
     * Set SUBPRODUCTS value
     * @param \StructType\SubProductsContainerType $sUBPRODUCTS
     * @return \StructType\ProductType
     */
    public function setSUBPRODUCTS(\StructType\SubProductsContainerType $sUBPRODUCTS = null)
    {
        $this->SUBPRODUCTS = $sUBPRODUCTS;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
