<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductReferences StructType
 * @subpackage Structs
 */
class ProductReferences extends AbstractStructBase
{
    /**
     * The product_reference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $product_reference;
    /**
     * Constructor method for ProductReferences
     * @uses ProductReferences::setProduct_reference()
     * @param string[] $product_reference
     */
    public function __construct(array $product_reference = array())
    {
        $this
            ->setProduct_reference($product_reference);
    }
    /**
     * Get product_reference value
     * @return string[]|null
     */
    public function getProduct_reference()
    {
        return $this->product_reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProduct_reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProduct_reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProduct_referenceForArrayConstraintsFromSetProduct_reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productReferencesProduct_referenceItem) {
            // validation for constraint: itemType
            if (!is_string($productReferencesProduct_referenceItem)) {
                $invalidValues[] = is_object($productReferencesProduct_referenceItem) ? get_class($productReferencesProduct_referenceItem) : sprintf('%s(%s)', gettype($productReferencesProduct_referenceItem), var_export($productReferencesProduct_referenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The product_reference property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set product_reference value
     * @throws \InvalidArgumentException
     * @param string[] $product_reference
     * @return \StructType\ProductReferences
     */
    public function setProduct_reference(array $product_reference = array())
    {
        // validation for constraint: array
        if ('' !== ($product_referenceArrayErrorMessage = self::validateProduct_referenceForArrayConstraintsFromSetProduct_reference($product_reference))) {
            throw new \InvalidArgumentException($product_referenceArrayErrorMessage, __LINE__);
        }
        $this->product_reference = $product_reference;
        return $this;
    }
    /**
     * Add item to product_reference value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ProductReferences
     */
    public function addToProduct_reference($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The product_reference property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->product_reference[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductReferences
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
