<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderProductType StructType
 * @subpackage Structs
 */
class OrderProductType extends AbstractStructBase
{
    /**
     * The ORDER_PRODUCT_ID
     * @var int
     */
    public $ORDER_PRODUCT_ID;
    /**
     * The PRODUCT_ID
     * @var int
     */
    public $PRODUCT_ID;
    /**
     * The PARENT_PRODUCT_REFERENCE
     * @var string
     */
    public $PARENT_PRODUCT_REFERENCE;
    /**
     * The CHILD_PRODUCT_REFERENCE
     * @var string
     */
    public $CHILD_PRODUCT_REFERENCE;
    /**
     * The PRODUCT_REFERENCE
     * @var string
     */
    public $PRODUCT_REFERENCE;
    /**
     * The MODEL
     * @var string
     */
    public $MODEL;
    /**
     * The CHILD_PRODUCT_MODEL
     * @var string
     */
    public $CHILD_PRODUCT_MODEL;
    /**
     * The EAN
     * @var string
     */
    public $EAN;
    /**
     * The MANUFACTURER_NAME
     * @var string
     */
    public $MANUFACTURER_NAME;
    /**
     * The TITLE
     * @var string
     */
    public $TITLE;
    /**
     * The SUMMARY
     * @var string
     */
    public $SUMMARY;
    /**
     * The CATEGORIES
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CATEGORIES
     */
    public $CATEGORIES;
    /**
     * The QUANTITY
     * @var int
     */
    public $QUANTITY;
    /**
     * The PRICE_INC
     * @var float
     */
    public $PRICE_INC;
    /**
     * The PRICE_EX
     * @var float
     */
    public $PRICE_EX;
    /**
     * The PRICE_VAT
     * @var float
     */
    public $PRICE_VAT;
    /**
     * The DISCOUNT_PRICE_INC
     * @var float
     */
    public $DISCOUNT_PRICE_INC;
    /**
     * The DISCOUNT_PRICE_EX
     * @var float
     */
    public $DISCOUNT_PRICE_EX;
    /**
     * The DISCOUNT_PRICE_VAT
     * @var float
     */
    public $DISCOUNT_PRICE_VAT;
    /**
     * The TAX_RATE
     * @var float
     */
    public $TAX_RATE;
    /**
     * The PERSONALISATIONS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PERSONALISATIONS
     */
    public $PERSONALISATIONS;
    /**
     * The GIFT_WRAP_METHOD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GIFT_WRAP_METHOD;
    /**
     * The GIFT_WRAP_COST_INC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GIFT_WRAP_COST_INC;
    /**
     * The GIFT_WRAP_COST_NET
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GIFT_WRAP_COST_NET;
    /**
     * The GIFT_WRAP_TAX
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GIFT_WRAP_TAX;
    /**
     * The GIFT_WRAP_MESSAGE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GIFT_WRAP_MESSAGE;
    /**
     * The ACTIVE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ACTIVE;
    /**
     * The RETURN_REASON
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RETURN_REASON;
    /**
     * The WEIGHT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $WEIGHT;
    /**
     * The STOCK_MESSAGE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\STOCK_MESSAGE
     */
    public $STOCK_MESSAGE;
    /**
     * The PICK_LOCATION
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PICK_LOCATION;
    /**
     * The STOCK_LOCATION
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\STOCK_LOCATION
     */
    public $STOCK_LOCATION;
    /**
     * The BRANCH_FULFILMENT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BRANCH_FULFILMENT
     */
    public $BRANCH_FULFILMENT;
    /**
     * Constructor method for OrderProductType
     * @uses OrderProductType::setORDER_PRODUCT_ID()
     * @uses OrderProductType::setPRODUCT_ID()
     * @uses OrderProductType::setPARENT_PRODUCT_REFERENCE()
     * @uses OrderProductType::setCHILD_PRODUCT_REFERENCE()
     * @uses OrderProductType::setPRODUCT_REFERENCE()
     * @uses OrderProductType::setMODEL()
     * @uses OrderProductType::setCHILD_PRODUCT_MODEL()
     * @uses OrderProductType::setEAN()
     * @uses OrderProductType::setMANUFACTURER_NAME()
     * @uses OrderProductType::setTITLE()
     * @uses OrderProductType::setSUMMARY()
     * @uses OrderProductType::setCATEGORIES()
     * @uses OrderProductType::setQUANTITY()
     * @uses OrderProductType::setPRICE_INC()
     * @uses OrderProductType::setPRICE_EX()
     * @uses OrderProductType::setPRICE_VAT()
     * @uses OrderProductType::setDISCOUNT_PRICE_INC()
     * @uses OrderProductType::setDISCOUNT_PRICE_EX()
     * @uses OrderProductType::setDISCOUNT_PRICE_VAT()
     * @uses OrderProductType::setTAX_RATE()
     * @uses OrderProductType::setPERSONALISATIONS()
     * @uses OrderProductType::setGIFT_WRAP_METHOD()
     * @uses OrderProductType::setGIFT_WRAP_COST_INC()
     * @uses OrderProductType::setGIFT_WRAP_COST_NET()
     * @uses OrderProductType::setGIFT_WRAP_TAX()
     * @uses OrderProductType::setGIFT_WRAP_MESSAGE()
     * @uses OrderProductType::setACTIVE()
     * @uses OrderProductType::setRETURN_REASON()
     * @uses OrderProductType::setWEIGHT()
     * @uses OrderProductType::setSTOCK_MESSAGE()
     * @uses OrderProductType::setPICK_LOCATION()
     * @uses OrderProductType::setSTOCK_LOCATION()
     * @uses OrderProductType::setBRANCH_FULFILMENT()
     * @param int $oRDER_PRODUCT_ID
     * @param int $pRODUCT_ID
     * @param string $pARENT_PRODUCT_REFERENCE
     * @param string $cHILD_PRODUCT_REFERENCE
     * @param string $pRODUCT_REFERENCE
     * @param string $mODEL
     * @param string $cHILD_PRODUCT_MODEL
     * @param string $eAN
     * @param string $mANUFACTURER_NAME
     * @param string $tITLE
     * @param string $sUMMARY
     * @param \StructType\CATEGORIES $cATEGORIES
     * @param int $qUANTITY
     * @param float $pRICE_INC
     * @param float $pRICE_EX
     * @param float $pRICE_VAT
     * @param float $dISCOUNT_PRICE_INC
     * @param float $dISCOUNT_PRICE_EX
     * @param float $dISCOUNT_PRICE_VAT
     * @param float $tAX_RATE
     * @param \StructType\PERSONALISATIONS $pERSONALISATIONS
     * @param string $gIFT_WRAP_METHOD
     * @param string $gIFT_WRAP_COST_INC
     * @param string $gIFT_WRAP_COST_NET
     * @param string $gIFT_WRAP_TAX
     * @param string $gIFT_WRAP_MESSAGE
     * @param string $aCTIVE
     * @param string $rETURN_REASON
     * @param float $wEIGHT
     * @param \StructType\STOCK_MESSAGE $sTOCK_MESSAGE
     * @param string $pICK_LOCATION
     * @param \StructType\STOCK_LOCATION $sTOCK_LOCATION
     * @param \StructType\BRANCH_FULFILMENT $bRANCH_FULFILMENT
     */
    public function __construct($oRDER_PRODUCT_ID = null, $pRODUCT_ID = null, $pARENT_PRODUCT_REFERENCE = null, $cHILD_PRODUCT_REFERENCE = null, $pRODUCT_REFERENCE = null, $mODEL = null, $cHILD_PRODUCT_MODEL = null, $eAN = null, $mANUFACTURER_NAME = null, $tITLE = null, $sUMMARY = null, \StructType\CATEGORIES $cATEGORIES = null, $qUANTITY = null, $pRICE_INC = null, $pRICE_EX = null, $pRICE_VAT = null, $dISCOUNT_PRICE_INC = null, $dISCOUNT_PRICE_EX = null, $dISCOUNT_PRICE_VAT = null, $tAX_RATE = null, \StructType\PERSONALISATIONS $pERSONALISATIONS = null, $gIFT_WRAP_METHOD = null, $gIFT_WRAP_COST_INC = null, $gIFT_WRAP_COST_NET = null, $gIFT_WRAP_TAX = null, $gIFT_WRAP_MESSAGE = null, $aCTIVE = null, $rETURN_REASON = null, $wEIGHT = null, \StructType\STOCK_MESSAGE $sTOCK_MESSAGE = null, $pICK_LOCATION = null, \StructType\STOCK_LOCATION $sTOCK_LOCATION = null, \StructType\BRANCH_FULFILMENT $bRANCH_FULFILMENT = null)
    {
        $this
            ->setORDER_PRODUCT_ID($oRDER_PRODUCT_ID)
            ->setPRODUCT_ID($pRODUCT_ID)
            ->setPARENT_PRODUCT_REFERENCE($pARENT_PRODUCT_REFERENCE)
            ->setCHILD_PRODUCT_REFERENCE($cHILD_PRODUCT_REFERENCE)
            ->setPRODUCT_REFERENCE($pRODUCT_REFERENCE)
            ->setMODEL($mODEL)
            ->setCHILD_PRODUCT_MODEL($cHILD_PRODUCT_MODEL)
            ->setEAN($eAN)
            ->setMANUFACTURER_NAME($mANUFACTURER_NAME)
            ->setTITLE($tITLE)
            ->setSUMMARY($sUMMARY)
            ->setCATEGORIES($cATEGORIES)
            ->setQUANTITY($qUANTITY)
            ->setPRICE_INC($pRICE_INC)
            ->setPRICE_EX($pRICE_EX)
            ->setPRICE_VAT($pRICE_VAT)
            ->setDISCOUNT_PRICE_INC($dISCOUNT_PRICE_INC)
            ->setDISCOUNT_PRICE_EX($dISCOUNT_PRICE_EX)
            ->setDISCOUNT_PRICE_VAT($dISCOUNT_PRICE_VAT)
            ->setTAX_RATE($tAX_RATE)
            ->setPERSONALISATIONS($pERSONALISATIONS)
            ->setGIFT_WRAP_METHOD($gIFT_WRAP_METHOD)
            ->setGIFT_WRAP_COST_INC($gIFT_WRAP_COST_INC)
            ->setGIFT_WRAP_COST_NET($gIFT_WRAP_COST_NET)
            ->setGIFT_WRAP_TAX($gIFT_WRAP_TAX)
            ->setGIFT_WRAP_MESSAGE($gIFT_WRAP_MESSAGE)
            ->setACTIVE($aCTIVE)
            ->setRETURN_REASON($rETURN_REASON)
            ->setWEIGHT($wEIGHT)
            ->setSTOCK_MESSAGE($sTOCK_MESSAGE)
            ->setPICK_LOCATION($pICK_LOCATION)
            ->setSTOCK_LOCATION($sTOCK_LOCATION)
            ->setBRANCH_FULFILMENT($bRANCH_FULFILMENT);
    }
    /**
     * Get ORDER_PRODUCT_ID value
     * @return int|null
     */
    public function getORDER_PRODUCT_ID()
    {
        return $this->ORDER_PRODUCT_ID;
    }
    /**
     * Set ORDER_PRODUCT_ID value
     * @param int $oRDER_PRODUCT_ID
     * @return \StructType\OrderProductType
     */
    public function setORDER_PRODUCT_ID($oRDER_PRODUCT_ID = null)
    {
        // validation for constraint: int
        if (!is_null($oRDER_PRODUCT_ID) && !(is_int($oRDER_PRODUCT_ID) || ctype_digit($oRDER_PRODUCT_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oRDER_PRODUCT_ID, true), gettype($oRDER_PRODUCT_ID)), __LINE__);
        }
        $this->ORDER_PRODUCT_ID = $oRDER_PRODUCT_ID;
        return $this;
    }
    /**
     * Get PRODUCT_ID value
     * @return int|null
     */
    public function getPRODUCT_ID()
    {
        return $this->PRODUCT_ID;
    }
    /**
     * Set PRODUCT_ID value
     * @param int $pRODUCT_ID
     * @return \StructType\OrderProductType
     */
    public function setPRODUCT_ID($pRODUCT_ID = null)
    {
        // validation for constraint: int
        if (!is_null($pRODUCT_ID) && !(is_int($pRODUCT_ID) || ctype_digit($pRODUCT_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pRODUCT_ID, true), gettype($pRODUCT_ID)), __LINE__);
        }
        $this->PRODUCT_ID = $pRODUCT_ID;
        return $this;
    }
    /**
     * Get PARENT_PRODUCT_REFERENCE value
     * @return string|null
     */
    public function getPARENT_PRODUCT_REFERENCE()
    {
        return $this->PARENT_PRODUCT_REFERENCE;
    }
    /**
     * Set PARENT_PRODUCT_REFERENCE value
     * @param string $pARENT_PRODUCT_REFERENCE
     * @return \StructType\OrderProductType
     */
    public function setPARENT_PRODUCT_REFERENCE($pARENT_PRODUCT_REFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($pARENT_PRODUCT_REFERENCE) && !is_string($pARENT_PRODUCT_REFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pARENT_PRODUCT_REFERENCE, true), gettype($pARENT_PRODUCT_REFERENCE)), __LINE__);
        }
        $this->PARENT_PRODUCT_REFERENCE = $pARENT_PRODUCT_REFERENCE;
        return $this;
    }
    /**
     * Get CHILD_PRODUCT_REFERENCE value
     * @return string|null
     */
    public function getCHILD_PRODUCT_REFERENCE()
    {
        return $this->CHILD_PRODUCT_REFERENCE;
    }
    /**
     * Set CHILD_PRODUCT_REFERENCE value
     * @param string $cHILD_PRODUCT_REFERENCE
     * @return \StructType\OrderProductType
     */
    public function setCHILD_PRODUCT_REFERENCE($cHILD_PRODUCT_REFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($cHILD_PRODUCT_REFERENCE) && !is_string($cHILD_PRODUCT_REFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cHILD_PRODUCT_REFERENCE, true), gettype($cHILD_PRODUCT_REFERENCE)), __LINE__);
        }
        $this->CHILD_PRODUCT_REFERENCE = $cHILD_PRODUCT_REFERENCE;
        return $this;
    }
    /**
     * Get PRODUCT_REFERENCE value
     * @return string|null
     */
    public function getPRODUCT_REFERENCE()
    {
        return $this->PRODUCT_REFERENCE;
    }
    /**
     * Set PRODUCT_REFERENCE value
     * @param string $pRODUCT_REFERENCE
     * @return \StructType\OrderProductType
     */
    public function setPRODUCT_REFERENCE($pRODUCT_REFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($pRODUCT_REFERENCE) && !is_string($pRODUCT_REFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pRODUCT_REFERENCE, true), gettype($pRODUCT_REFERENCE)), __LINE__);
        }
        $this->PRODUCT_REFERENCE = $pRODUCT_REFERENCE;
        return $this;
    }
    /**
     * Get MODEL value
     * @return string|null
     */
    public function getMODEL()
    {
        return $this->MODEL;
    }
    /**
     * Set MODEL value
     * @param string $mODEL
     * @return \StructType\OrderProductType
     */
    public function setMODEL($mODEL = null)
    {
        // validation for constraint: string
        if (!is_null($mODEL) && !is_string($mODEL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mODEL, true), gettype($mODEL)), __LINE__);
        }
        $this->MODEL = $mODEL;
        return $this;
    }
    /**
     * Get CHILD_PRODUCT_MODEL value
     * @return string|null
     */
    public function getCHILD_PRODUCT_MODEL()
    {
        return $this->CHILD_PRODUCT_MODEL;
    }
    /**
     * Set CHILD_PRODUCT_MODEL value
     * @param string $cHILD_PRODUCT_MODEL
     * @return \StructType\OrderProductType
     */
    public function setCHILD_PRODUCT_MODEL($cHILD_PRODUCT_MODEL = null)
    {
        // validation for constraint: string
        if (!is_null($cHILD_PRODUCT_MODEL) && !is_string($cHILD_PRODUCT_MODEL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cHILD_PRODUCT_MODEL, true), gettype($cHILD_PRODUCT_MODEL)), __LINE__);
        }
        $this->CHILD_PRODUCT_MODEL = $cHILD_PRODUCT_MODEL;
        return $this;
    }
    /**
     * Get EAN value
     * @return string|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param string $eAN
     * @return \StructType\OrderProductType
     */
    public function setEAN($eAN = null)
    {
        // validation for constraint: string
        if (!is_null($eAN) && !is_string($eAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eAN, true), gettype($eAN)), __LINE__);
        }
        $this->EAN = $eAN;
        return $this;
    }
    /**
     * Get MANUFACTURER_NAME value
     * @return string|null
     */
    public function getMANUFACTURER_NAME()
    {
        return $this->MANUFACTURER_NAME;
    }
    /**
     * Set MANUFACTURER_NAME value
     * @param string $mANUFACTURER_NAME
     * @return \StructType\OrderProductType
     */
    public function setMANUFACTURER_NAME($mANUFACTURER_NAME = null)
    {
        // validation for constraint: string
        if (!is_null($mANUFACTURER_NAME) && !is_string($mANUFACTURER_NAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mANUFACTURER_NAME, true), gettype($mANUFACTURER_NAME)), __LINE__);
        }
        $this->MANUFACTURER_NAME = $mANUFACTURER_NAME;
        return $this;
    }
    /**
     * Get TITLE value
     * @return string|null
     */
    public function getTITLE()
    {
        return $this->TITLE;
    }
    /**
     * Set TITLE value
     * @param string $tITLE
     * @return \StructType\OrderProductType
     */
    public function setTITLE($tITLE = null)
    {
        // validation for constraint: string
        if (!is_null($tITLE) && !is_string($tITLE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tITLE, true), gettype($tITLE)), __LINE__);
        }
        $this->TITLE = $tITLE;
        return $this;
    }
    /**
     * Get SUMMARY value
     * @return string|null
     */
    public function getSUMMARY()
    {
        return $this->SUMMARY;
    }
    /**
     * Set SUMMARY value
     * @param string $sUMMARY
     * @return \StructType\OrderProductType
     */
    public function setSUMMARY($sUMMARY = null)
    {
        // validation for constraint: string
        if (!is_null($sUMMARY) && !is_string($sUMMARY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUMMARY, true), gettype($sUMMARY)), __LINE__);
        }
        $this->SUMMARY = $sUMMARY;
        return $this;
    }
    /**
     * Get CATEGORIES value
     * @return \StructType\CATEGORIES|null
     */
    public function getCATEGORIES()
    {
        return $this->CATEGORIES;
    }
    /**
     * Set CATEGORIES value
     * @param \StructType\CATEGORIES $cATEGORIES
     * @return \StructType\OrderProductType
     */
    public function setCATEGORIES(\StructType\CATEGORIES $cATEGORIES = null)
    {
        $this->CATEGORIES = $cATEGORIES;
        return $this;
    }
    /**
     * Get QUANTITY value
     * @return int|null
     */
    public function getQUANTITY()
    {
        return $this->QUANTITY;
    }
    /**
     * Set QUANTITY value
     * @param int $qUANTITY
     * @return \StructType\OrderProductType
     */
    public function setQUANTITY($qUANTITY = null)
    {
        // validation for constraint: int
        if (!is_null($qUANTITY) && !(is_int($qUANTITY) || ctype_digit($qUANTITY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qUANTITY, true), gettype($qUANTITY)), __LINE__);
        }
        $this->QUANTITY = $qUANTITY;
        return $this;
    }
    /**
     * Get PRICE_INC value
     * @return float|null
     */
    public function getPRICE_INC()
    {
        return $this->PRICE_INC;
    }
    /**
     * Set PRICE_INC value
     * @param float $pRICE_INC
     * @return \StructType\OrderProductType
     */
    public function setPRICE_INC($pRICE_INC = null)
    {
        // validation for constraint: float
        if (!is_null($pRICE_INC) && !(is_float($pRICE_INC) || is_numeric($pRICE_INC))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pRICE_INC, true), gettype($pRICE_INC)), __LINE__);
        }
        $this->PRICE_INC = $pRICE_INC;
        return $this;
    }
    /**
     * Get PRICE_EX value
     * @return float|null
     */
    public function getPRICE_EX()
    {
        return $this->PRICE_EX;
    }
    /**
     * Set PRICE_EX value
     * @param float $pRICE_EX
     * @return \StructType\OrderProductType
     */
    public function setPRICE_EX($pRICE_EX = null)
    {
        // validation for constraint: float
        if (!is_null($pRICE_EX) && !(is_float($pRICE_EX) || is_numeric($pRICE_EX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pRICE_EX, true), gettype($pRICE_EX)), __LINE__);
        }
        $this->PRICE_EX = $pRICE_EX;
        return $this;
    }
    /**
     * Get PRICE_VAT value
     * @return float|null
     */
    public function getPRICE_VAT()
    {
        return $this->PRICE_VAT;
    }
    /**
     * Set PRICE_VAT value
     * @param float $pRICE_VAT
     * @return \StructType\OrderProductType
     */
    public function setPRICE_VAT($pRICE_VAT = null)
    {
        // validation for constraint: float
        if (!is_null($pRICE_VAT) && !(is_float($pRICE_VAT) || is_numeric($pRICE_VAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pRICE_VAT, true), gettype($pRICE_VAT)), __LINE__);
        }
        $this->PRICE_VAT = $pRICE_VAT;
        return $this;
    }
    /**
     * Get DISCOUNT_PRICE_INC value
     * @return float|null
     */
    public function getDISCOUNT_PRICE_INC()
    {
        return $this->DISCOUNT_PRICE_INC;
    }
    /**
     * Set DISCOUNT_PRICE_INC value
     * @param float $dISCOUNT_PRICE_INC
     * @return \StructType\OrderProductType
     */
    public function setDISCOUNT_PRICE_INC($dISCOUNT_PRICE_INC = null)
    {
        // validation for constraint: float
        if (!is_null($dISCOUNT_PRICE_INC) && !(is_float($dISCOUNT_PRICE_INC) || is_numeric($dISCOUNT_PRICE_INC))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dISCOUNT_PRICE_INC, true), gettype($dISCOUNT_PRICE_INC)), __LINE__);
        }
        $this->DISCOUNT_PRICE_INC = $dISCOUNT_PRICE_INC;
        return $this;
    }
    /**
     * Get DISCOUNT_PRICE_EX value
     * @return float|null
     */
    public function getDISCOUNT_PRICE_EX()
    {
        return $this->DISCOUNT_PRICE_EX;
    }
    /**
     * Set DISCOUNT_PRICE_EX value
     * @param float $dISCOUNT_PRICE_EX
     * @return \StructType\OrderProductType
     */
    public function setDISCOUNT_PRICE_EX($dISCOUNT_PRICE_EX = null)
    {
        // validation for constraint: float
        if (!is_null($dISCOUNT_PRICE_EX) && !(is_float($dISCOUNT_PRICE_EX) || is_numeric($dISCOUNT_PRICE_EX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dISCOUNT_PRICE_EX, true), gettype($dISCOUNT_PRICE_EX)), __LINE__);
        }
        $this->DISCOUNT_PRICE_EX = $dISCOUNT_PRICE_EX;
        return $this;
    }
    /**
     * Get DISCOUNT_PRICE_VAT value
     * @return float|null
     */
    public function getDISCOUNT_PRICE_VAT()
    {
        return $this->DISCOUNT_PRICE_VAT;
    }
    /**
     * Set DISCOUNT_PRICE_VAT value
     * @param float $dISCOUNT_PRICE_VAT
     * @return \StructType\OrderProductType
     */
    public function setDISCOUNT_PRICE_VAT($dISCOUNT_PRICE_VAT = null)
    {
        // validation for constraint: float
        if (!is_null($dISCOUNT_PRICE_VAT) && !(is_float($dISCOUNT_PRICE_VAT) || is_numeric($dISCOUNT_PRICE_VAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dISCOUNT_PRICE_VAT, true), gettype($dISCOUNT_PRICE_VAT)), __LINE__);
        }
        $this->DISCOUNT_PRICE_VAT = $dISCOUNT_PRICE_VAT;
        return $this;
    }
    /**
     * Get TAX_RATE value
     * @return float|null
     */
    public function getTAX_RATE()
    {
        return $this->TAX_RATE;
    }
    /**
     * Set TAX_RATE value
     * @param float $tAX_RATE
     * @return \StructType\OrderProductType
     */
    public function setTAX_RATE($tAX_RATE = null)
    {
        // validation for constraint: float
        if (!is_null($tAX_RATE) && !(is_float($tAX_RATE) || is_numeric($tAX_RATE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tAX_RATE, true), gettype($tAX_RATE)), __LINE__);
        }
        $this->TAX_RATE = $tAX_RATE;
        return $this;
    }
    /**
     * Get PERSONALISATIONS value
     * @return \StructType\PERSONALISATIONS|null
     */
    public function getPERSONALISATIONS()
    {
        return $this->PERSONALISATIONS;
    }
    /**
     * Set PERSONALISATIONS value
     * @param \StructType\PERSONALISATIONS $pERSONALISATIONS
     * @return \StructType\OrderProductType
     */
    public function setPERSONALISATIONS(\StructType\PERSONALISATIONS $pERSONALISATIONS = null)
    {
        $this->PERSONALISATIONS = $pERSONALISATIONS;
        return $this;
    }
    /**
     * Get GIFT_WRAP_METHOD value
     * @return string|null
     */
    public function getGIFT_WRAP_METHOD()
    {
        return $this->GIFT_WRAP_METHOD;
    }
    /**
     * Set GIFT_WRAP_METHOD value
     * @param string $gIFT_WRAP_METHOD
     * @return \StructType\OrderProductType
     */
    public function setGIFT_WRAP_METHOD($gIFT_WRAP_METHOD = null)
    {
        // validation for constraint: string
        if (!is_null($gIFT_WRAP_METHOD) && !is_string($gIFT_WRAP_METHOD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gIFT_WRAP_METHOD, true), gettype($gIFT_WRAP_METHOD)), __LINE__);
        }
        $this->GIFT_WRAP_METHOD = $gIFT_WRAP_METHOD;
        return $this;
    }
    /**
     * Get GIFT_WRAP_COST_INC value
     * @return string|null
     */
    public function getGIFT_WRAP_COST_INC()
    {
        return $this->GIFT_WRAP_COST_INC;
    }
    /**
     * Set GIFT_WRAP_COST_INC value
     * @param string $gIFT_WRAP_COST_INC
     * @return \StructType\OrderProductType
     */
    public function setGIFT_WRAP_COST_INC($gIFT_WRAP_COST_INC = null)
    {
        // validation for constraint: string
        if (!is_null($gIFT_WRAP_COST_INC) && !is_string($gIFT_WRAP_COST_INC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gIFT_WRAP_COST_INC, true), gettype($gIFT_WRAP_COST_INC)), __LINE__);
        }
        $this->GIFT_WRAP_COST_INC = $gIFT_WRAP_COST_INC;
        return $this;
    }
    /**
     * Get GIFT_WRAP_COST_NET value
     * @return string|null
     */
    public function getGIFT_WRAP_COST_NET()
    {
        return $this->GIFT_WRAP_COST_NET;
    }
    /**
     * Set GIFT_WRAP_COST_NET value
     * @param string $gIFT_WRAP_COST_NET
     * @return \StructType\OrderProductType
     */
    public function setGIFT_WRAP_COST_NET($gIFT_WRAP_COST_NET = null)
    {
        // validation for constraint: string
        if (!is_null($gIFT_WRAP_COST_NET) && !is_string($gIFT_WRAP_COST_NET)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gIFT_WRAP_COST_NET, true), gettype($gIFT_WRAP_COST_NET)), __LINE__);
        }
        $this->GIFT_WRAP_COST_NET = $gIFT_WRAP_COST_NET;
        return $this;
    }
    /**
     * Get GIFT_WRAP_TAX value
     * @return string|null
     */
    public function getGIFT_WRAP_TAX()
    {
        return $this->GIFT_WRAP_TAX;
    }
    /**
     * Set GIFT_WRAP_TAX value
     * @param string $gIFT_WRAP_TAX
     * @return \StructType\OrderProductType
     */
    public function setGIFT_WRAP_TAX($gIFT_WRAP_TAX = null)
    {
        // validation for constraint: string
        if (!is_null($gIFT_WRAP_TAX) && !is_string($gIFT_WRAP_TAX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gIFT_WRAP_TAX, true), gettype($gIFT_WRAP_TAX)), __LINE__);
        }
        $this->GIFT_WRAP_TAX = $gIFT_WRAP_TAX;
        return $this;
    }
    /**
     * Get GIFT_WRAP_MESSAGE value
     * @return string|null
     */
    public function getGIFT_WRAP_MESSAGE()
    {
        return $this->GIFT_WRAP_MESSAGE;
    }
    /**
     * Set GIFT_WRAP_MESSAGE value
     * @param string $gIFT_WRAP_MESSAGE
     * @return \StructType\OrderProductType
     */
    public function setGIFT_WRAP_MESSAGE($gIFT_WRAP_MESSAGE = null)
    {
        // validation for constraint: string
        if (!is_null($gIFT_WRAP_MESSAGE) && !is_string($gIFT_WRAP_MESSAGE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gIFT_WRAP_MESSAGE, true), gettype($gIFT_WRAP_MESSAGE)), __LINE__);
        }
        $this->GIFT_WRAP_MESSAGE = $gIFT_WRAP_MESSAGE;
        return $this;
    }
    /**
     * Get ACTIVE value
     * @return string|null
     */
    public function getACTIVE()
    {
        return $this->ACTIVE;
    }
    /**
     * Set ACTIVE value
     * @param string $aCTIVE
     * @return \StructType\OrderProductType
     */
    public function setACTIVE($aCTIVE = null)
    {
        // validation for constraint: string
        if (!is_null($aCTIVE) && !is_string($aCTIVE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aCTIVE, true), gettype($aCTIVE)), __LINE__);
        }
        $this->ACTIVE = $aCTIVE;
        return $this;
    }
    /**
     * Get RETURN_REASON value
     * @return string|null
     */
    public function getRETURN_REASON()
    {
        return $this->RETURN_REASON;
    }
    /**
     * Set RETURN_REASON value
     * @param string $rETURN_REASON
     * @return \StructType\OrderProductType
     */
    public function setRETURN_REASON($rETURN_REASON = null)
    {
        // validation for constraint: string
        if (!is_null($rETURN_REASON) && !is_string($rETURN_REASON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rETURN_REASON, true), gettype($rETURN_REASON)), __LINE__);
        }
        $this->RETURN_REASON = $rETURN_REASON;
        return $this;
    }
    /**
     * Get WEIGHT value
     * @return float|null
     */
    public function getWEIGHT()
    {
        return $this->WEIGHT;
    }
    /**
     * Set WEIGHT value
     * @param float $wEIGHT
     * @return \StructType\OrderProductType
     */
    public function setWEIGHT($wEIGHT = null)
    {
        // validation for constraint: float
        if (!is_null($wEIGHT) && !(is_float($wEIGHT) || is_numeric($wEIGHT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($wEIGHT, true), gettype($wEIGHT)), __LINE__);
        }
        $this->WEIGHT = $wEIGHT;
        return $this;
    }
    /**
     * Get STOCK_MESSAGE value
     * @return \StructType\STOCK_MESSAGE|null
     */
    public function getSTOCK_MESSAGE()
    {
        return $this->STOCK_MESSAGE;
    }
    /**
     * Set STOCK_MESSAGE value
     * @param \StructType\STOCK_MESSAGE $sTOCK_MESSAGE
     * @return \StructType\OrderProductType
     */
    public function setSTOCK_MESSAGE(\StructType\STOCK_MESSAGE $sTOCK_MESSAGE = null)
    {
        $this->STOCK_MESSAGE = $sTOCK_MESSAGE;
        return $this;
    }
    /**
     * Get PICK_LOCATION value
     * @return string|null
     */
    public function getPICK_LOCATION()
    {
        return $this->PICK_LOCATION;
    }
    /**
     * Set PICK_LOCATION value
     * @param string $pICK_LOCATION
     * @return \StructType\OrderProductType
     */
    public function setPICK_LOCATION($pICK_LOCATION = null)
    {
        // validation for constraint: string
        if (!is_null($pICK_LOCATION) && !is_string($pICK_LOCATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pICK_LOCATION, true), gettype($pICK_LOCATION)), __LINE__);
        }
        $this->PICK_LOCATION = $pICK_LOCATION;
        return $this;
    }
    /**
     * Get STOCK_LOCATION value
     * @return \StructType\STOCK_LOCATION|null
     */
    public function getSTOCK_LOCATION()
    {
        return $this->STOCK_LOCATION;
    }
    /**
     * Set STOCK_LOCATION value
     * @param \StructType\STOCK_LOCATION $sTOCK_LOCATION
     * @return \StructType\OrderProductType
     */
    public function setSTOCK_LOCATION(\StructType\STOCK_LOCATION $sTOCK_LOCATION = null)
    {
        $this->STOCK_LOCATION = $sTOCK_LOCATION;
        return $this;
    }
    /**
     * Get BRANCH_FULFILMENT value
     * @return \StructType\BRANCH_FULFILMENT|null
     */
    public function getBRANCH_FULFILMENT()
    {
        return $this->BRANCH_FULFILMENT;
    }
    /**
     * Set BRANCH_FULFILMENT value
     * @param \StructType\BRANCH_FULFILMENT $bRANCH_FULFILMENT
     * @return \StructType\OrderProductType
     */
    public function setBRANCH_FULFILMENT(\StructType\BRANCH_FULFILMENT $bRANCH_FULFILMENT = null)
    {
        $this->BRANCH_FULFILMENT = $bRANCH_FULFILMENT;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderProductType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
