<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewsletterSubscriberType StructType
 * @subpackage Structs
 */
class NewsletterSubscriberType extends AbstractStructBase
{
    /**
     * The email_address
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $email_address;
    /**
     * The subscriber_group_ids
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Subscriber_group_ids
     */
    public $subscriber_group_ids;
    /**
     * The firstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstname;
    /**
     * The lastname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastname;
    /**
     * The send_email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $send_email;
    /**
     * Constructor method for NewsletterSubscriberType
     * @uses NewsletterSubscriberType::setEmail_address()
     * @uses NewsletterSubscriberType::setSubscriber_group_ids()
     * @uses NewsletterSubscriberType::setFirstname()
     * @uses NewsletterSubscriberType::setLastname()
     * @uses NewsletterSubscriberType::setSend_email()
     * @param string $email_address
     * @param \StructType\Subscriber_group_ids $subscriber_group_ids
     * @param string $firstname
     * @param string $lastname
     * @param bool $send_email
     */
    public function __construct($email_address = null, \StructType\Subscriber_group_ids $subscriber_group_ids = null, $firstname = null, $lastname = null, $send_email = null)
    {
        $this
            ->setEmail_address($email_address)
            ->setSubscriber_group_ids($subscriber_group_ids)
            ->setFirstname($firstname)
            ->setLastname($lastname)
            ->setSend_email($send_email);
    }
    /**
     * Get email_address value
     * @return string
     */
    public function getEmail_address()
    {
        return $this->email_address;
    }
    /**
     * Set email_address value
     * @param string $email_address
     * @return \StructType\NewsletterSubscriberType
     */
    public function setEmail_address($email_address = null)
    {
        // validation for constraint: string
        if (!is_null($email_address) && !is_string($email_address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email_address, true), gettype($email_address)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($email_address) && mb_strlen($email_address) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($email_address)), __LINE__);
        }
        $this->email_address = $email_address;
        return $this;
    }
    /**
     * Get subscriber_group_ids value
     * @return \StructType\Subscriber_group_ids|null
     */
    public function getSubscriber_group_ids()
    {
        return $this->subscriber_group_ids;
    }
    /**
     * Set subscriber_group_ids value
     * @param \StructType\Subscriber_group_ids $subscriber_group_ids
     * @return \StructType\NewsletterSubscriberType
     */
    public function setSubscriber_group_ids(\StructType\Subscriber_group_ids $subscriber_group_ids = null)
    {
        $this->subscriber_group_ids = $subscriber_group_ids;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \StructType\NewsletterSubscriberType
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->lastname;
    }
    /**
     * Set lastname value
     * @param string $lastname
     * @return \StructType\NewsletterSubscriberType
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastname, true), gettype($lastname)), __LINE__);
        }
        $this->lastname = $lastname;
        return $this;
    }
    /**
     * Get send_email value
     * @return bool|null
     */
    public function getSend_email()
    {
        return $this->send_email;
    }
    /**
     * Set send_email value
     * @param bool $send_email
     * @return \StructType\NewsletterSubscriberType
     */
    public function setSend_email($send_email = null)
    {
        // validation for constraint: boolean
        if (!is_null($send_email) && !is_bool($send_email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($send_email, true), gettype($send_email)), __LINE__);
        }
        $this->send_email = $send_email;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NewsletterSubscriberType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
