<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifyNewsletterSubscriberType StructType
 * @subpackage Structs
 */
class ModifyNewsletterSubscriberType extends AbstractStructBase
{
    /**
     * The email_address
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: email_address | subscriber_id
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minLength: 1
     * @var string
     */
    public $email_address;
    /**
     * The subscriber_id
     * Meta information extracted from the WSDL
     * - choice: email_address | subscriber_id
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $subscriber_id;
    /**
     * The subscriber_group_ids
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Subscriber_group_ids
     */
    public $subscriber_group_ids;
    /**
     * The firstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstname;
    /**
     * The lastname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastname;
    /**
     * The dateofbirth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dateofbirth;
    /**
     * The gender
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gender;
    /**
     * The unsubscribe
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $unsubscribe;
    /**
     * The disengaged
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $disengaged;
    /**
     * The delete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $delete;
    /**
     * Constructor method for ModifyNewsletterSubscriberType
     * @uses ModifyNewsletterSubscriberType::setEmail_address()
     * @uses ModifyNewsletterSubscriberType::setSubscriber_id()
     * @uses ModifyNewsletterSubscriberType::setSubscriber_group_ids()
     * @uses ModifyNewsletterSubscriberType::setFirstname()
     * @uses ModifyNewsletterSubscriberType::setLastname()
     * @uses ModifyNewsletterSubscriberType::setDateofbirth()
     * @uses ModifyNewsletterSubscriberType::setGender()
     * @uses ModifyNewsletterSubscriberType::setUnsubscribe()
     * @uses ModifyNewsletterSubscriberType::setDisengaged()
     * @uses ModifyNewsletterSubscriberType::setDelete()
     * @param string $email_address
     * @param int $subscriber_id
     * @param \StructType\Subscriber_group_ids $subscriber_group_ids
     * @param string $firstname
     * @param string $lastname
     * @param string $dateofbirth
     * @param string $gender
     * @param bool $unsubscribe
     * @param bool $disengaged
     * @param bool $delete
     */
    public function __construct($email_address = null, $subscriber_id = null, \StructType\Subscriber_group_ids $subscriber_group_ids = null, $firstname = null, $lastname = null, $dateofbirth = null, $gender = null, $unsubscribe = null, $disengaged = null, $delete = null)
    {
        $this
            ->setEmail_address($email_address)
            ->setSubscriber_id($subscriber_id)
            ->setSubscriber_group_ids($subscriber_group_ids)
            ->setFirstname($firstname)
            ->setLastname($lastname)
            ->setDateofbirth($dateofbirth)
            ->setGender($gender)
            ->setUnsubscribe($unsubscribe)
            ->setDisengaged($disengaged)
            ->setDelete($delete);
    }
    /**
     * Get email_address value
     * @return string|null
     */
    public function getEmail_address()
    {
        return isset($this->email_address) ? $this->email_address : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEmail_address method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail_address method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEmail_addressForChoiceConstraintsFromSetEmail_address($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'subscriber_id',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property email_address can\'t be set as the property %s is already set. Only one property must be set among these properties: email_address, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set email_address value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $email_address
     * @return \StructType\ModifyNewsletterSubscriberType
     */
    public function setEmail_address($email_address = null)
    {
        // validation for constraint: string
        if (!is_null($email_address) && !is_string($email_address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email_address, true), gettype($email_address)), __LINE__);
        }
        // validation for constraint: choice(email_address, subscriber_id)
        if ('' !== ($email_addressChoiceErrorMessage = self::validateEmail_addressForChoiceConstraintsFromSetEmail_address($email_address))) {
            throw new \InvalidArgumentException($email_addressChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($email_address) && mb_strlen($email_address) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($email_address)), __LINE__);
        }
        if (is_null($email_address) || (is_array($email_address) && empty($email_address))) {
            unset($this->email_address);
        } else {
            $this->email_address = $email_address;
        }
        return $this;
    }
    /**
     * Get subscriber_id value
     * @return int|null
     */
    public function getSubscriber_id()
    {
        return isset($this->subscriber_id) ? $this->subscriber_id : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSubscriber_id method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubscriber_id method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSubscriber_idForChoiceConstraintsFromSetSubscriber_id($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'email_address',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property subscriber_id can\'t be set as the property %s is already set. Only one property must be set among these properties: subscriber_id, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set subscriber_id value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $subscriber_id
     * @return \StructType\ModifyNewsletterSubscriberType
     */
    public function setSubscriber_id($subscriber_id = null)
    {
        // validation for constraint: int
        if (!is_null($subscriber_id) && !(is_int($subscriber_id) || ctype_digit($subscriber_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subscriber_id, true), gettype($subscriber_id)), __LINE__);
        }
        // validation for constraint: choice(email_address, subscriber_id)
        if ('' !== ($subscriber_idChoiceErrorMessage = self::validateSubscriber_idForChoiceConstraintsFromSetSubscriber_id($subscriber_id))) {
            throw new \InvalidArgumentException($subscriber_idChoiceErrorMessage, __LINE__);
        }
        if (is_null($subscriber_id) || (is_array($subscriber_id) && empty($subscriber_id))) {
            unset($this->subscriber_id);
        } else {
            $this->subscriber_id = $subscriber_id;
        }
        return $this;
    }
    /**
     * Get subscriber_group_ids value
     * @return \StructType\Subscriber_group_ids|null
     */
    public function getSubscriber_group_ids()
    {
        return $this->subscriber_group_ids;
    }
    /**
     * Set subscriber_group_ids value
     * @param \StructType\Subscriber_group_ids $subscriber_group_ids
     * @return \StructType\ModifyNewsletterSubscriberType
     */
    public function setSubscriber_group_ids(\StructType\Subscriber_group_ids $subscriber_group_ids = null)
    {
        $this->subscriber_group_ids = $subscriber_group_ids;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \StructType\ModifyNewsletterSubscriberType
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->lastname;
    }
    /**
     * Set lastname value
     * @param string $lastname
     * @return \StructType\ModifyNewsletterSubscriberType
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastname, true), gettype($lastname)), __LINE__);
        }
        $this->lastname = $lastname;
        return $this;
    }
    /**
     * Get dateofbirth value
     * @return string|null
     */
    public function getDateofbirth()
    {
        return $this->dateofbirth;
    }
    /**
     * Set dateofbirth value
     * @param string $dateofbirth
     * @return \StructType\ModifyNewsletterSubscriberType
     */
    public function setDateofbirth($dateofbirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateofbirth) && !is_string($dateofbirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateofbirth, true), gettype($dateofbirth)), __LINE__);
        }
        $this->dateofbirth = $dateofbirth;
        return $this;
    }
    /**
     * Get gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->gender;
    }
    /**
     * Set gender value
     * @param string $gender
     * @return \StructType\ModifyNewsletterSubscriberType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        $this->gender = $gender;
        return $this;
    }
    /**
     * Get unsubscribe value
     * @return bool|null
     */
    public function getUnsubscribe()
    {
        return $this->unsubscribe;
    }
    /**
     * Set unsubscribe value
     * @param bool $unsubscribe
     * @return \StructType\ModifyNewsletterSubscriberType
     */
    public function setUnsubscribe($unsubscribe = null)
    {
        // validation for constraint: boolean
        if (!is_null($unsubscribe) && !is_bool($unsubscribe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unsubscribe, true), gettype($unsubscribe)), __LINE__);
        }
        $this->unsubscribe = $unsubscribe;
        return $this;
    }
    /**
     * Get disengaged value
     * @return bool|null
     */
    public function getDisengaged()
    {
        return $this->disengaged;
    }
    /**
     * Set disengaged value
     * @param bool $disengaged
     * @return \StructType\ModifyNewsletterSubscriberType
     */
    public function setDisengaged($disengaged = null)
    {
        // validation for constraint: boolean
        if (!is_null($disengaged) && !is_bool($disengaged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($disengaged, true), gettype($disengaged)), __LINE__);
        }
        $this->disengaged = $disengaged;
        return $this;
    }
    /**
     * Get delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->delete;
    }
    /**
     * Set delete value
     * @param bool $delete
     * @return \StructType\ModifyNewsletterSubscriberType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->delete = $delete;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ModifyNewsletterSubscriberType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
