<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportCustomerType StructType
 * @subpackage Structs
 */
class ImportCustomerType extends AbstractStructBase
{
    /**
     * The EMAIL_ADDRESS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EMAIL_ADDRESS;
    /**
     * The ADDRESSES
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AddressesType
     */
    public $ADDRESSES;
    /**
     * The CUSTOMER_ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CUSTOMER_ID;
    /**
     * The IDENTIFY_USING
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDENTIFY_USING;
    /**
     * The PREVIOUS_IDENTIFIER
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PREVIOUS_IDENTIFIER;
    /**
     * The WEBSITE_ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $WEBSITE_ID;
    /**
     * The SEND_PASSWORD_RECOVERY
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SEND_PASSWORD_RECOVERY;
    /**
     * The PASSWORD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PASSWORD;
    /**
     * The CUSTOMER_ACCOUNT_NUMBER
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CUSTOMER_ACCOUNT_NUMBER;
    /**
     * The DATE_OF_BIRTH
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DATE_OF_BIRTH;
    /**
     * The CUSTOMER_OCCUPATION
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CUSTOMER_OCCUPATION;
    /**
     * The HEARD_ABOUT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HEARD_ABOUT;
    /**
     * The CUSTOMER_NOTES
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CUSTOMER_NOTES;
    /**
     * The OPT_INS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OptInsType
     */
    public $OPT_INS;
    /**
     * The APPROVED
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APPROVED;
    /**
     * The CUSTOMER_NIF
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CUSTOMER_NIF;
    /**
     * The FREE_DELIVERY
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FREE_DELIVERY;
    /**
     * The CUSTOMER_GROUP_ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CUSTOMER_GROUP_ID;
    /**
     * The CUSTOMER_GROUP_NAME
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CUSTOMER_GROUP_NAME;
    /**
     * The LOCK_TO_TRADE_ONLY
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LOCK_TO_TRADE_ONLY;
    /**
     * The CURRENT_BALANCE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $CURRENT_BALANCE;
    /**
     * The CREDIT_LIMIT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $CREDIT_LIMIT;
    /**
     * The VAT_REGISTRATION_NUMBER
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VAT_REGISTRATION_NUMBER;
    /**
     * The VAT_EXEMPT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VAT_EXEMPT;
    /**
     * The CUSTOMER_TYPE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CUSTOMER_TYPE;
    /**
     * The EXTERNAL_LOYALTY_PROGRAM_NUMBER
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EXTERNAL_LOYALTY_PROGRAM_NUMBER;
    /**
     * The COMPANY_NUMBER
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $COMPANY_NUMBER;
    /**
     * The COMPANY_DOMAIN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $COMPANY_DOMAIN;
    /**
     * Constructor method for ImportCustomerType
     * @uses ImportCustomerType::setEMAIL_ADDRESS()
     * @uses ImportCustomerType::setADDRESSES()
     * @uses ImportCustomerType::setCUSTOMER_ID()
     * @uses ImportCustomerType::setIDENTIFY_USING()
     * @uses ImportCustomerType::setPREVIOUS_IDENTIFIER()
     * @uses ImportCustomerType::setWEBSITE_ID()
     * @uses ImportCustomerType::setSEND_PASSWORD_RECOVERY()
     * @uses ImportCustomerType::setPASSWORD()
     * @uses ImportCustomerType::setCUSTOMER_ACCOUNT_NUMBER()
     * @uses ImportCustomerType::setDATE_OF_BIRTH()
     * @uses ImportCustomerType::setCUSTOMER_OCCUPATION()
     * @uses ImportCustomerType::setHEARD_ABOUT()
     * @uses ImportCustomerType::setCUSTOMER_NOTES()
     * @uses ImportCustomerType::setOPT_INS()
     * @uses ImportCustomerType::setAPPROVED()
     * @uses ImportCustomerType::setCUSTOMER_NIF()
     * @uses ImportCustomerType::setFREE_DELIVERY()
     * @uses ImportCustomerType::setCUSTOMER_GROUP_ID()
     * @uses ImportCustomerType::setCUSTOMER_GROUP_NAME()
     * @uses ImportCustomerType::setLOCK_TO_TRADE_ONLY()
     * @uses ImportCustomerType::setCURRENT_BALANCE()
     * @uses ImportCustomerType::setCREDIT_LIMIT()
     * @uses ImportCustomerType::setVAT_REGISTRATION_NUMBER()
     * @uses ImportCustomerType::setVAT_EXEMPT()
     * @uses ImportCustomerType::setCUSTOMER_TYPE()
     * @uses ImportCustomerType::setEXTERNAL_LOYALTY_PROGRAM_NUMBER()
     * @uses ImportCustomerType::setCOMPANY_NUMBER()
     * @uses ImportCustomerType::setCOMPANY_DOMAIN()
     * @param string $eMAIL_ADDRESS
     * @param \StructType\AddressesType $aDDRESSES
     * @param int $cUSTOMER_ID
     * @param string $iDENTIFY_USING
     * @param string $pREVIOUS_IDENTIFIER
     * @param int $wEBSITE_ID
     * @param string $sEND_PASSWORD_RECOVERY
     * @param string $pASSWORD
     * @param string $cUSTOMER_ACCOUNT_NUMBER
     * @param string $dATE_OF_BIRTH
     * @param string $cUSTOMER_OCCUPATION
     * @param string $hEARD_ABOUT
     * @param string $cUSTOMER_NOTES
     * @param \StructType\OptInsType $oPT_INS
     * @param string $aPPROVED
     * @param string $cUSTOMER_NIF
     * @param string $fREE_DELIVERY
     * @param int $cUSTOMER_GROUP_ID
     * @param string $cUSTOMER_GROUP_NAME
     * @param string $lOCK_TO_TRADE_ONLY
     * @param float $cURRENT_BALANCE
     * @param float $cREDIT_LIMIT
     * @param string $vAT_REGISTRATION_NUMBER
     * @param string $vAT_EXEMPT
     * @param string $cUSTOMER_TYPE
     * @param string $eXTERNAL_LOYALTY_PROGRAM_NUMBER
     * @param string $cOMPANY_NUMBER
     * @param string $cOMPANY_DOMAIN
     */
    public function __construct($eMAIL_ADDRESS = null, \StructType\AddressesType $aDDRESSES = null, $cUSTOMER_ID = null, $iDENTIFY_USING = null, $pREVIOUS_IDENTIFIER = null, $wEBSITE_ID = null, $sEND_PASSWORD_RECOVERY = null, $pASSWORD = null, $cUSTOMER_ACCOUNT_NUMBER = null, $dATE_OF_BIRTH = null, $cUSTOMER_OCCUPATION = null, $hEARD_ABOUT = null, $cUSTOMER_NOTES = null, \StructType\OptInsType $oPT_INS = null, $aPPROVED = null, $cUSTOMER_NIF = null, $fREE_DELIVERY = null, $cUSTOMER_GROUP_ID = null, $cUSTOMER_GROUP_NAME = null, $lOCK_TO_TRADE_ONLY = null, $cURRENT_BALANCE = null, $cREDIT_LIMIT = null, $vAT_REGISTRATION_NUMBER = null, $vAT_EXEMPT = null, $cUSTOMER_TYPE = null, $eXTERNAL_LOYALTY_PROGRAM_NUMBER = null, $cOMPANY_NUMBER = null, $cOMPANY_DOMAIN = null)
    {
        $this
            ->setEMAIL_ADDRESS($eMAIL_ADDRESS)
            ->setADDRESSES($aDDRESSES)
            ->setCUSTOMER_ID($cUSTOMER_ID)
            ->setIDENTIFY_USING($iDENTIFY_USING)
            ->setPREVIOUS_IDENTIFIER($pREVIOUS_IDENTIFIER)
            ->setWEBSITE_ID($wEBSITE_ID)
            ->setSEND_PASSWORD_RECOVERY($sEND_PASSWORD_RECOVERY)
            ->setPASSWORD($pASSWORD)
            ->setCUSTOMER_ACCOUNT_NUMBER($cUSTOMER_ACCOUNT_NUMBER)
            ->setDATE_OF_BIRTH($dATE_OF_BIRTH)
            ->setCUSTOMER_OCCUPATION($cUSTOMER_OCCUPATION)
            ->setHEARD_ABOUT($hEARD_ABOUT)
            ->setCUSTOMER_NOTES($cUSTOMER_NOTES)
            ->setOPT_INS($oPT_INS)
            ->setAPPROVED($aPPROVED)
            ->setCUSTOMER_NIF($cUSTOMER_NIF)
            ->setFREE_DELIVERY($fREE_DELIVERY)
            ->setCUSTOMER_GROUP_ID($cUSTOMER_GROUP_ID)
            ->setCUSTOMER_GROUP_NAME($cUSTOMER_GROUP_NAME)
            ->setLOCK_TO_TRADE_ONLY($lOCK_TO_TRADE_ONLY)
            ->setCURRENT_BALANCE($cURRENT_BALANCE)
            ->setCREDIT_LIMIT($cREDIT_LIMIT)
            ->setVAT_REGISTRATION_NUMBER($vAT_REGISTRATION_NUMBER)
            ->setVAT_EXEMPT($vAT_EXEMPT)
            ->setCUSTOMER_TYPE($cUSTOMER_TYPE)
            ->setEXTERNAL_LOYALTY_PROGRAM_NUMBER($eXTERNAL_LOYALTY_PROGRAM_NUMBER)
            ->setCOMPANY_NUMBER($cOMPANY_NUMBER)
            ->setCOMPANY_DOMAIN($cOMPANY_DOMAIN);
    }
    /**
     * Get EMAIL_ADDRESS value
     * @return string
     */
    public function getEMAIL_ADDRESS()
    {
        return $this->EMAIL_ADDRESS;
    }
    /**
     * Set EMAIL_ADDRESS value
     * @param string $eMAIL_ADDRESS
     * @return \StructType\ImportCustomerType
     */
    public function setEMAIL_ADDRESS($eMAIL_ADDRESS = null)
    {
        // validation for constraint: string
        if (!is_null($eMAIL_ADDRESS) && !is_string($eMAIL_ADDRESS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMAIL_ADDRESS, true), gettype($eMAIL_ADDRESS)), __LINE__);
        }
        $this->EMAIL_ADDRESS = $eMAIL_ADDRESS;
        return $this;
    }
    /**
     * Get ADDRESSES value
     * @return \StructType\AddressesType
     */
    public function getADDRESSES()
    {
        return $this->ADDRESSES;
    }
    /**
     * Set ADDRESSES value
     * @param \StructType\AddressesType $aDDRESSES
     * @return \StructType\ImportCustomerType
     */
    public function setADDRESSES(\StructType\AddressesType $aDDRESSES = null)
    {
        $this->ADDRESSES = $aDDRESSES;
        return $this;
    }
    /**
     * Get CUSTOMER_ID value
     * @return int|null
     */
    public function getCUSTOMER_ID()
    {
        return $this->CUSTOMER_ID;
    }
    /**
     * Set CUSTOMER_ID value
     * @param int $cUSTOMER_ID
     * @return \StructType\ImportCustomerType
     */
    public function setCUSTOMER_ID($cUSTOMER_ID = null)
    {
        // validation for constraint: int
        if (!is_null($cUSTOMER_ID) && !(is_int($cUSTOMER_ID) || ctype_digit($cUSTOMER_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cUSTOMER_ID, true), gettype($cUSTOMER_ID)), __LINE__);
        }
        $this->CUSTOMER_ID = $cUSTOMER_ID;
        return $this;
    }
    /**
     * Get IDENTIFY_USING value
     * @return string|null
     */
    public function getIDENTIFY_USING()
    {
        return $this->IDENTIFY_USING;
    }
    /**
     * Set IDENTIFY_USING value
     * @param string $iDENTIFY_USING
     * @return \StructType\ImportCustomerType
     */
    public function setIDENTIFY_USING($iDENTIFY_USING = null)
    {
        // validation for constraint: string
        if (!is_null($iDENTIFY_USING) && !is_string($iDENTIFY_USING)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDENTIFY_USING, true), gettype($iDENTIFY_USING)), __LINE__);
        }
        $this->IDENTIFY_USING = $iDENTIFY_USING;
        return $this;
    }
    /**
     * Get PREVIOUS_IDENTIFIER value
     * @return string|null
     */
    public function getPREVIOUS_IDENTIFIER()
    {
        return $this->PREVIOUS_IDENTIFIER;
    }
    /**
     * Set PREVIOUS_IDENTIFIER value
     * @param string $pREVIOUS_IDENTIFIER
     * @return \StructType\ImportCustomerType
     */
    public function setPREVIOUS_IDENTIFIER($pREVIOUS_IDENTIFIER = null)
    {
        // validation for constraint: string
        if (!is_null($pREVIOUS_IDENTIFIER) && !is_string($pREVIOUS_IDENTIFIER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pREVIOUS_IDENTIFIER, true), gettype($pREVIOUS_IDENTIFIER)), __LINE__);
        }
        $this->PREVIOUS_IDENTIFIER = $pREVIOUS_IDENTIFIER;
        return $this;
    }
    /**
     * Get WEBSITE_ID value
     * @return int|null
     */
    public function getWEBSITE_ID()
    {
        return $this->WEBSITE_ID;
    }
    /**
     * Set WEBSITE_ID value
     * @param int $wEBSITE_ID
     * @return \StructType\ImportCustomerType
     */
    public function setWEBSITE_ID($wEBSITE_ID = null)
    {
        // validation for constraint: int
        if (!is_null($wEBSITE_ID) && !(is_int($wEBSITE_ID) || ctype_digit($wEBSITE_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wEBSITE_ID, true), gettype($wEBSITE_ID)), __LINE__);
        }
        $this->WEBSITE_ID = $wEBSITE_ID;
        return $this;
    }
    /**
     * Get SEND_PASSWORD_RECOVERY value
     * @return string|null
     */
    public function getSEND_PASSWORD_RECOVERY()
    {
        return $this->SEND_PASSWORD_RECOVERY;
    }
    /**
     * Set SEND_PASSWORD_RECOVERY value
     * @param string $sEND_PASSWORD_RECOVERY
     * @return \StructType\ImportCustomerType
     */
    public function setSEND_PASSWORD_RECOVERY($sEND_PASSWORD_RECOVERY = null)
    {
        // validation for constraint: string
        if (!is_null($sEND_PASSWORD_RECOVERY) && !is_string($sEND_PASSWORD_RECOVERY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sEND_PASSWORD_RECOVERY, true), gettype($sEND_PASSWORD_RECOVERY)), __LINE__);
        }
        $this->SEND_PASSWORD_RECOVERY = $sEND_PASSWORD_RECOVERY;
        return $this;
    }
    /**
     * Get PASSWORD value
     * @return string|null
     */
    public function getPASSWORD()
    {
        return $this->PASSWORD;
    }
    /**
     * Set PASSWORD value
     * @param string $pASSWORD
     * @return \StructType\ImportCustomerType
     */
    public function setPASSWORD($pASSWORD = null)
    {
        // validation for constraint: string
        if (!is_null($pASSWORD) && !is_string($pASSWORD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pASSWORD, true), gettype($pASSWORD)), __LINE__);
        }
        $this->PASSWORD = $pASSWORD;
        return $this;
    }
    /**
     * Get CUSTOMER_ACCOUNT_NUMBER value
     * @return string|null
     */
    public function getCUSTOMER_ACCOUNT_NUMBER()
    {
        return $this->CUSTOMER_ACCOUNT_NUMBER;
    }
    /**
     * Set CUSTOMER_ACCOUNT_NUMBER value
     * @param string $cUSTOMER_ACCOUNT_NUMBER
     * @return \StructType\ImportCustomerType
     */
    public function setCUSTOMER_ACCOUNT_NUMBER($cUSTOMER_ACCOUNT_NUMBER = null)
    {
        // validation for constraint: string
        if (!is_null($cUSTOMER_ACCOUNT_NUMBER) && !is_string($cUSTOMER_ACCOUNT_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cUSTOMER_ACCOUNT_NUMBER, true), gettype($cUSTOMER_ACCOUNT_NUMBER)), __LINE__);
        }
        $this->CUSTOMER_ACCOUNT_NUMBER = $cUSTOMER_ACCOUNT_NUMBER;
        return $this;
    }
    /**
     * Get DATE_OF_BIRTH value
     * @return string|null
     */
    public function getDATE_OF_BIRTH()
    {
        return $this->DATE_OF_BIRTH;
    }
    /**
     * Set DATE_OF_BIRTH value
     * @param string $dATE_OF_BIRTH
     * @return \StructType\ImportCustomerType
     */
    public function setDATE_OF_BIRTH($dATE_OF_BIRTH = null)
    {
        // validation for constraint: string
        if (!is_null($dATE_OF_BIRTH) && !is_string($dATE_OF_BIRTH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dATE_OF_BIRTH, true), gettype($dATE_OF_BIRTH)), __LINE__);
        }
        $this->DATE_OF_BIRTH = $dATE_OF_BIRTH;
        return $this;
    }
    /**
     * Get CUSTOMER_OCCUPATION value
     * @return string|null
     */
    public function getCUSTOMER_OCCUPATION()
    {
        return $this->CUSTOMER_OCCUPATION;
    }
    /**
     * Set CUSTOMER_OCCUPATION value
     * @param string $cUSTOMER_OCCUPATION
     * @return \StructType\ImportCustomerType
     */
    public function setCUSTOMER_OCCUPATION($cUSTOMER_OCCUPATION = null)
    {
        // validation for constraint: string
        if (!is_null($cUSTOMER_OCCUPATION) && !is_string($cUSTOMER_OCCUPATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cUSTOMER_OCCUPATION, true), gettype($cUSTOMER_OCCUPATION)), __LINE__);
        }
        $this->CUSTOMER_OCCUPATION = $cUSTOMER_OCCUPATION;
        return $this;
    }
    /**
     * Get HEARD_ABOUT value
     * @return string|null
     */
    public function getHEARD_ABOUT()
    {
        return $this->HEARD_ABOUT;
    }
    /**
     * Set HEARD_ABOUT value
     * @param string $hEARD_ABOUT
     * @return \StructType\ImportCustomerType
     */
    public function setHEARD_ABOUT($hEARD_ABOUT = null)
    {
        // validation for constraint: string
        if (!is_null($hEARD_ABOUT) && !is_string($hEARD_ABOUT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hEARD_ABOUT, true), gettype($hEARD_ABOUT)), __LINE__);
        }
        $this->HEARD_ABOUT = $hEARD_ABOUT;
        return $this;
    }
    /**
     * Get CUSTOMER_NOTES value
     * @return string|null
     */
    public function getCUSTOMER_NOTES()
    {
        return $this->CUSTOMER_NOTES;
    }
    /**
     * Set CUSTOMER_NOTES value
     * @param string $cUSTOMER_NOTES
     * @return \StructType\ImportCustomerType
     */
    public function setCUSTOMER_NOTES($cUSTOMER_NOTES = null)
    {
        // validation for constraint: string
        if (!is_null($cUSTOMER_NOTES) && !is_string($cUSTOMER_NOTES)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cUSTOMER_NOTES, true), gettype($cUSTOMER_NOTES)), __LINE__);
        }
        $this->CUSTOMER_NOTES = $cUSTOMER_NOTES;
        return $this;
    }
    /**
     * Get OPT_INS value
     * @return \StructType\OptInsType|null
     */
    public function getOPT_INS()
    {
        return $this->OPT_INS;
    }
    /**
     * Set OPT_INS value
     * @param \StructType\OptInsType $oPT_INS
     * @return \StructType\ImportCustomerType
     */
    public function setOPT_INS(\StructType\OptInsType $oPT_INS = null)
    {
        $this->OPT_INS = $oPT_INS;
        return $this;
    }
    /**
     * Get APPROVED value
     * @return string|null
     */
    public function getAPPROVED()
    {
        return $this->APPROVED;
    }
    /**
     * Set APPROVED value
     * @param string $aPPROVED
     * @return \StructType\ImportCustomerType
     */
    public function setAPPROVED($aPPROVED = null)
    {
        // validation for constraint: string
        if (!is_null($aPPROVED) && !is_string($aPPROVED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPPROVED, true), gettype($aPPROVED)), __LINE__);
        }
        $this->APPROVED = $aPPROVED;
        return $this;
    }
    /**
     * Get CUSTOMER_NIF value
     * @return string|null
     */
    public function getCUSTOMER_NIF()
    {
        return $this->CUSTOMER_NIF;
    }
    /**
     * Set CUSTOMER_NIF value
     * @param string $cUSTOMER_NIF
     * @return \StructType\ImportCustomerType
     */
    public function setCUSTOMER_NIF($cUSTOMER_NIF = null)
    {
        // validation for constraint: string
        if (!is_null($cUSTOMER_NIF) && !is_string($cUSTOMER_NIF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cUSTOMER_NIF, true), gettype($cUSTOMER_NIF)), __LINE__);
        }
        $this->CUSTOMER_NIF = $cUSTOMER_NIF;
        return $this;
    }
    /**
     * Get FREE_DELIVERY value
     * @return string|null
     */
    public function getFREE_DELIVERY()
    {
        return $this->FREE_DELIVERY;
    }
    /**
     * Set FREE_DELIVERY value
     * @param string $fREE_DELIVERY
     * @return \StructType\ImportCustomerType
     */
    public function setFREE_DELIVERY($fREE_DELIVERY = null)
    {
        // validation for constraint: string
        if (!is_null($fREE_DELIVERY) && !is_string($fREE_DELIVERY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fREE_DELIVERY, true), gettype($fREE_DELIVERY)), __LINE__);
        }
        $this->FREE_DELIVERY = $fREE_DELIVERY;
        return $this;
    }
    /**
     * Get CUSTOMER_GROUP_ID value
     * @return int|null
     */
    public function getCUSTOMER_GROUP_ID()
    {
        return $this->CUSTOMER_GROUP_ID;
    }
    /**
     * Set CUSTOMER_GROUP_ID value
     * @param int $cUSTOMER_GROUP_ID
     * @return \StructType\ImportCustomerType
     */
    public function setCUSTOMER_GROUP_ID($cUSTOMER_GROUP_ID = null)
    {
        // validation for constraint: int
        if (!is_null($cUSTOMER_GROUP_ID) && !(is_int($cUSTOMER_GROUP_ID) || ctype_digit($cUSTOMER_GROUP_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cUSTOMER_GROUP_ID, true), gettype($cUSTOMER_GROUP_ID)), __LINE__);
        }
        $this->CUSTOMER_GROUP_ID = $cUSTOMER_GROUP_ID;
        return $this;
    }
    /**
     * Get CUSTOMER_GROUP_NAME value
     * @return string|null
     */
    public function getCUSTOMER_GROUP_NAME()
    {
        return $this->CUSTOMER_GROUP_NAME;
    }
    /**
     * Set CUSTOMER_GROUP_NAME value
     * @param string $cUSTOMER_GROUP_NAME
     * @return \StructType\ImportCustomerType
     */
    public function setCUSTOMER_GROUP_NAME($cUSTOMER_GROUP_NAME = null)
    {
        // validation for constraint: string
        if (!is_null($cUSTOMER_GROUP_NAME) && !is_string($cUSTOMER_GROUP_NAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cUSTOMER_GROUP_NAME, true), gettype($cUSTOMER_GROUP_NAME)), __LINE__);
        }
        $this->CUSTOMER_GROUP_NAME = $cUSTOMER_GROUP_NAME;
        return $this;
    }
    /**
     * Get LOCK_TO_TRADE_ONLY value
     * @return string|null
     */
    public function getLOCK_TO_TRADE_ONLY()
    {
        return $this->LOCK_TO_TRADE_ONLY;
    }
    /**
     * Set LOCK_TO_TRADE_ONLY value
     * @param string $lOCK_TO_TRADE_ONLY
     * @return \StructType\ImportCustomerType
     */
    public function setLOCK_TO_TRADE_ONLY($lOCK_TO_TRADE_ONLY = null)
    {
        // validation for constraint: string
        if (!is_null($lOCK_TO_TRADE_ONLY) && !is_string($lOCK_TO_TRADE_ONLY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lOCK_TO_TRADE_ONLY, true), gettype($lOCK_TO_TRADE_ONLY)), __LINE__);
        }
        $this->LOCK_TO_TRADE_ONLY = $lOCK_TO_TRADE_ONLY;
        return $this;
    }
    /**
     * Get CURRENT_BALANCE value
     * @return float|null
     */
    public function getCURRENT_BALANCE()
    {
        return $this->CURRENT_BALANCE;
    }
    /**
     * Set CURRENT_BALANCE value
     * @param float $cURRENT_BALANCE
     * @return \StructType\ImportCustomerType
     */
    public function setCURRENT_BALANCE($cURRENT_BALANCE = null)
    {
        // validation for constraint: float
        if (!is_null($cURRENT_BALANCE) && !(is_float($cURRENT_BALANCE) || is_numeric($cURRENT_BALANCE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cURRENT_BALANCE, true), gettype($cURRENT_BALANCE)), __LINE__);
        }
        $this->CURRENT_BALANCE = $cURRENT_BALANCE;
        return $this;
    }
    /**
     * Get CREDIT_LIMIT value
     * @return float|null
     */
    public function getCREDIT_LIMIT()
    {
        return $this->CREDIT_LIMIT;
    }
    /**
     * Set CREDIT_LIMIT value
     * @param float $cREDIT_LIMIT
     * @return \StructType\ImportCustomerType
     */
    public function setCREDIT_LIMIT($cREDIT_LIMIT = null)
    {
        // validation for constraint: float
        if (!is_null($cREDIT_LIMIT) && !(is_float($cREDIT_LIMIT) || is_numeric($cREDIT_LIMIT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cREDIT_LIMIT, true), gettype($cREDIT_LIMIT)), __LINE__);
        }
        $this->CREDIT_LIMIT = $cREDIT_LIMIT;
        return $this;
    }
    /**
     * Get VAT_REGISTRATION_NUMBER value
     * @return string|null
     */
    public function getVAT_REGISTRATION_NUMBER()
    {
        return $this->VAT_REGISTRATION_NUMBER;
    }
    /**
     * Set VAT_REGISTRATION_NUMBER value
     * @param string $vAT_REGISTRATION_NUMBER
     * @return \StructType\ImportCustomerType
     */
    public function setVAT_REGISTRATION_NUMBER($vAT_REGISTRATION_NUMBER = null)
    {
        // validation for constraint: string
        if (!is_null($vAT_REGISTRATION_NUMBER) && !is_string($vAT_REGISTRATION_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vAT_REGISTRATION_NUMBER, true), gettype($vAT_REGISTRATION_NUMBER)), __LINE__);
        }
        $this->VAT_REGISTRATION_NUMBER = $vAT_REGISTRATION_NUMBER;
        return $this;
    }
    /**
     * Get VAT_EXEMPT value
     * @return string|null
     */
    public function getVAT_EXEMPT()
    {
        return $this->VAT_EXEMPT;
    }
    /**
     * Set VAT_EXEMPT value
     * @param string $vAT_EXEMPT
     * @return \StructType\ImportCustomerType
     */
    public function setVAT_EXEMPT($vAT_EXEMPT = null)
    {
        // validation for constraint: string
        if (!is_null($vAT_EXEMPT) && !is_string($vAT_EXEMPT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vAT_EXEMPT, true), gettype($vAT_EXEMPT)), __LINE__);
        }
        $this->VAT_EXEMPT = $vAT_EXEMPT;
        return $this;
    }
    /**
     * Get CUSTOMER_TYPE value
     * @return string|null
     */
    public function getCUSTOMER_TYPE()
    {
        return $this->CUSTOMER_TYPE;
    }
    /**
     * Set CUSTOMER_TYPE value
     * @param string $cUSTOMER_TYPE
     * @return \StructType\ImportCustomerType
     */
    public function setCUSTOMER_TYPE($cUSTOMER_TYPE = null)
    {
        // validation for constraint: string
        if (!is_null($cUSTOMER_TYPE) && !is_string($cUSTOMER_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cUSTOMER_TYPE, true), gettype($cUSTOMER_TYPE)), __LINE__);
        }
        $this->CUSTOMER_TYPE = $cUSTOMER_TYPE;
        return $this;
    }
    /**
     * Get EXTERNAL_LOYALTY_PROGRAM_NUMBER value
     * @return string|null
     */
    public function getEXTERNAL_LOYALTY_PROGRAM_NUMBER()
    {
        return $this->EXTERNAL_LOYALTY_PROGRAM_NUMBER;
    }
    /**
     * Set EXTERNAL_LOYALTY_PROGRAM_NUMBER value
     * @param string $eXTERNAL_LOYALTY_PROGRAM_NUMBER
     * @return \StructType\ImportCustomerType
     */
    public function setEXTERNAL_LOYALTY_PROGRAM_NUMBER($eXTERNAL_LOYALTY_PROGRAM_NUMBER = null)
    {
        // validation for constraint: string
        if (!is_null($eXTERNAL_LOYALTY_PROGRAM_NUMBER) && !is_string($eXTERNAL_LOYALTY_PROGRAM_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eXTERNAL_LOYALTY_PROGRAM_NUMBER, true), gettype($eXTERNAL_LOYALTY_PROGRAM_NUMBER)), __LINE__);
        }
        $this->EXTERNAL_LOYALTY_PROGRAM_NUMBER = $eXTERNAL_LOYALTY_PROGRAM_NUMBER;
        return $this;
    }
    /**
     * Get COMPANY_NUMBER value
     * @return string|null
     */
    public function getCOMPANY_NUMBER()
    {
        return $this->COMPANY_NUMBER;
    }
    /**
     * Set COMPANY_NUMBER value
     * @param string $cOMPANY_NUMBER
     * @return \StructType\ImportCustomerType
     */
    public function setCOMPANY_NUMBER($cOMPANY_NUMBER = null)
    {
        // validation for constraint: string
        if (!is_null($cOMPANY_NUMBER) && !is_string($cOMPANY_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cOMPANY_NUMBER, true), gettype($cOMPANY_NUMBER)), __LINE__);
        }
        $this->COMPANY_NUMBER = $cOMPANY_NUMBER;
        return $this;
    }
    /**
     * Get COMPANY_DOMAIN value
     * @return string|null
     */
    public function getCOMPANY_DOMAIN()
    {
        return $this->COMPANY_DOMAIN;
    }
    /**
     * Set COMPANY_DOMAIN value
     * @param string $cOMPANY_DOMAIN
     * @return \StructType\ImportCustomerType
     */
    public function setCOMPANY_DOMAIN($cOMPANY_DOMAIN = null)
    {
        // validation for constraint: string
        if (!is_null($cOMPANY_DOMAIN) && !is_string($cOMPANY_DOMAIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cOMPANY_DOMAIN, true), gettype($cOMPANY_DOMAIN)), __LINE__);
        }
        $this->COMPANY_DOMAIN = $cOMPANY_DOMAIN;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ImportCustomerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
