<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountType StructType
 * @subpackage Structs
 */
class DiscountType extends AbstractStructBase
{
    /**
     * The ID
     * @var int
     */
    public $ID;
    /**
     * The CODE
     * @var string
     */
    public $CODE;
    /**
     * The NAME
     * @var string
     */
    public $NAME;
    /**
     * The DISCOUNT_EX_VAT
     * @var float
     */
    public $DISCOUNT_EX_VAT;
    /**
     * The DISCOUNT_INC_VAT
     * @var float
     */
    public $DISCOUNT_INC_VAT;
    /**
     * The DISCOUNT_VAT
     * @var float
     */
    public $DISCOUNT_VAT;
    /**
     * Constructor method for DiscountType
     * @uses DiscountType::setID()
     * @uses DiscountType::setCODE()
     * @uses DiscountType::setNAME()
     * @uses DiscountType::setDISCOUNT_EX_VAT()
     * @uses DiscountType::setDISCOUNT_INC_VAT()
     * @uses DiscountType::setDISCOUNT_VAT()
     * @param int $iD
     * @param string $cODE
     * @param string $nAME
     * @param float $dISCOUNT_EX_VAT
     * @param float $dISCOUNT_INC_VAT
     * @param float $dISCOUNT_VAT
     */
    public function __construct($iD = null, $cODE = null, $nAME = null, $dISCOUNT_EX_VAT = null, $dISCOUNT_INC_VAT = null, $dISCOUNT_VAT = null)
    {
        $this
            ->setID($iD)
            ->setCODE($cODE)
            ->setNAME($nAME)
            ->setDISCOUNT_EX_VAT($dISCOUNT_EX_VAT)
            ->setDISCOUNT_INC_VAT($dISCOUNT_INC_VAT)
            ->setDISCOUNT_VAT($dISCOUNT_VAT);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\DiscountType
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get CODE value
     * @return string|null
     */
    public function getCODE()
    {
        return $this->CODE;
    }
    /**
     * Set CODE value
     * @param string $cODE
     * @return \StructType\DiscountType
     */
    public function setCODE($cODE = null)
    {
        // validation for constraint: string
        if (!is_null($cODE) && !is_string($cODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cODE, true), gettype($cODE)), __LINE__);
        }
        $this->CODE = $cODE;
        return $this;
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \StructType\DiscountType
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nAME, true), gettype($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get DISCOUNT_EX_VAT value
     * @return float|null
     */
    public function getDISCOUNT_EX_VAT()
    {
        return $this->DISCOUNT_EX_VAT;
    }
    /**
     * Set DISCOUNT_EX_VAT value
     * @param float $dISCOUNT_EX_VAT
     * @return \StructType\DiscountType
     */
    public function setDISCOUNT_EX_VAT($dISCOUNT_EX_VAT = null)
    {
        // validation for constraint: float
        if (!is_null($dISCOUNT_EX_VAT) && !(is_float($dISCOUNT_EX_VAT) || is_numeric($dISCOUNT_EX_VAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dISCOUNT_EX_VAT, true), gettype($dISCOUNT_EX_VAT)), __LINE__);
        }
        $this->DISCOUNT_EX_VAT = $dISCOUNT_EX_VAT;
        return $this;
    }
    /**
     * Get DISCOUNT_INC_VAT value
     * @return float|null
     */
    public function getDISCOUNT_INC_VAT()
    {
        return $this->DISCOUNT_INC_VAT;
    }
    /**
     * Set DISCOUNT_INC_VAT value
     * @param float $dISCOUNT_INC_VAT
     * @return \StructType\DiscountType
     */
    public function setDISCOUNT_INC_VAT($dISCOUNT_INC_VAT = null)
    {
        // validation for constraint: float
        if (!is_null($dISCOUNT_INC_VAT) && !(is_float($dISCOUNT_INC_VAT) || is_numeric($dISCOUNT_INC_VAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dISCOUNT_INC_VAT, true), gettype($dISCOUNT_INC_VAT)), __LINE__);
        }
        $this->DISCOUNT_INC_VAT = $dISCOUNT_INC_VAT;
        return $this;
    }
    /**
     * Get DISCOUNT_VAT value
     * @return float|null
     */
    public function getDISCOUNT_VAT()
    {
        return $this->DISCOUNT_VAT;
    }
    /**
     * Set DISCOUNT_VAT value
     * @param float $dISCOUNT_VAT
     * @return \StructType\DiscountType
     */
    public function setDISCOUNT_VAT($dISCOUNT_VAT = null)
    {
        // validation for constraint: float
        if (!is_null($dISCOUNT_VAT) && !(is_float($dISCOUNT_VAT) || is_numeric($dISCOUNT_VAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dISCOUNT_VAT, true), gettype($dISCOUNT_VAT)), __LINE__);
        }
        $this->DISCOUNT_VAT = $dISCOUNT_VAT;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DiscountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
