<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerGroupType StructType
 * @subpackage Structs
 */
class CustomerGroupType extends AbstractStructBase
{
    /**
     * The CUSTOMER_GROUP_ID
     * @var int
     */
    public $CUSTOMER_GROUP_ID;
    /**
     * The NAME
     * @var string
     */
    public $NAME;
    /**
     * The PARENT_CUSTOMER_GROUP_ID
     * @var int
     */
    public $PARENT_CUSTOMER_GROUP_ID;
    /**
     * The CURRENT_BALANCE
     * @var float
     */
    public $CURRENT_BALANCE;
    /**
     * The CREDIT_LIMIT
     * @var float
     */
    public $CREDIT_LIMIT;
    /**
     * The PO_NUMBER_OPTIONAL
     * @var string
     */
    public $PO_NUMBER_OPTIONAL;
    /**
     * The REFERENCE
     * @var string
     */
    public $REFERENCE;
    /**
     * The SHOW_EX_VAT_PRICES
     * @var string
     */
    public $SHOW_EX_VAT_PRICES;
    /**
     * The GROUP_SHARE_ORDERS
     * @var string
     */
    public $GROUP_SHARE_ORDERS;
    /**
     * The MINIMUM_ORDER_VALUE
     * @var float
     */
    public $MINIMUM_ORDER_VALUE;
    /**
     * The IS_VATABLE
     * @var string
     */
    public $IS_VATABLE;
    /**
     * The ALLOW_DISCOUNTS
     * @var string
     */
    public $ALLOW_DISCOUNTS;
    /**
     * The APPLICABLE_CATEGORY_ID
     * @var int
     */
    public $APPLICABLE_CATEGORY_ID;
    /**
     * The VIEW_SAME_LEVEL_DATA
     * @var string
     */
    public $VIEW_SAME_LEVEL_DATA;
    /**
     * The HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS
     * @var string
     */
    public $HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS;
    /**
     * The AVAILABLE_CREDIT
     * @var float
     */
    public $AVAILABLE_CREDIT;
    /**
     * The CUSTOMERS
     * @var \ArrayType\ArrayOfSimpleCustomers
     */
    public $CUSTOMERS;
    /**
     * The TRADE_DISCOUNTS
     * @var \StructType\TRADE_DISCOUNTS
     */
    public $TRADE_DISCOUNTS;
    /**
     * Constructor method for CustomerGroupType
     * @uses CustomerGroupType::setCUSTOMER_GROUP_ID()
     * @uses CustomerGroupType::setNAME()
     * @uses CustomerGroupType::setPARENT_CUSTOMER_GROUP_ID()
     * @uses CustomerGroupType::setCURRENT_BALANCE()
     * @uses CustomerGroupType::setCREDIT_LIMIT()
     * @uses CustomerGroupType::setPO_NUMBER_OPTIONAL()
     * @uses CustomerGroupType::setREFERENCE()
     * @uses CustomerGroupType::setSHOW_EX_VAT_PRICES()
     * @uses CustomerGroupType::setGROUP_SHARE_ORDERS()
     * @uses CustomerGroupType::setMINIMUM_ORDER_VALUE()
     * @uses CustomerGroupType::setIS_VATABLE()
     * @uses CustomerGroupType::setALLOW_DISCOUNTS()
     * @uses CustomerGroupType::setAPPLICABLE_CATEGORY_ID()
     * @uses CustomerGroupType::setVIEW_SAME_LEVEL_DATA()
     * @uses CustomerGroupType::setHIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS()
     * @uses CustomerGroupType::setAVAILABLE_CREDIT()
     * @uses CustomerGroupType::setCUSTOMERS()
     * @uses CustomerGroupType::setTRADE_DISCOUNTS()
     * @param int $cUSTOMER_GROUP_ID
     * @param string $nAME
     * @param int $pARENT_CUSTOMER_GROUP_ID
     * @param float $cURRENT_BALANCE
     * @param float $cREDIT_LIMIT
     * @param string $pO_NUMBER_OPTIONAL
     * @param string $rEFERENCE
     * @param string $sHOW_EX_VAT_PRICES
     * @param string $gROUP_SHARE_ORDERS
     * @param float $mINIMUM_ORDER_VALUE
     * @param string $iS_VATABLE
     * @param string $aLLOW_DISCOUNTS
     * @param int $aPPLICABLE_CATEGORY_ID
     * @param string $vIEW_SAME_LEVEL_DATA
     * @param string $hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS
     * @param float $aVAILABLE_CREDIT
     * @param \ArrayType\ArrayOfSimpleCustomers $cUSTOMERS
     * @param \StructType\TRADE_DISCOUNTS $tRADE_DISCOUNTS
     */
    public function __construct($cUSTOMER_GROUP_ID = null, $nAME = null, $pARENT_CUSTOMER_GROUP_ID = null, $cURRENT_BALANCE = null, $cREDIT_LIMIT = null, $pO_NUMBER_OPTIONAL = null, $rEFERENCE = null, $sHOW_EX_VAT_PRICES = null, $gROUP_SHARE_ORDERS = null, $mINIMUM_ORDER_VALUE = null, $iS_VATABLE = null, $aLLOW_DISCOUNTS = null, $aPPLICABLE_CATEGORY_ID = null, $vIEW_SAME_LEVEL_DATA = null, $hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS = null, $aVAILABLE_CREDIT = null, \ArrayType\ArrayOfSimpleCustomers $cUSTOMERS = null, \StructType\TRADE_DISCOUNTS $tRADE_DISCOUNTS = null)
    {
        $this
            ->setCUSTOMER_GROUP_ID($cUSTOMER_GROUP_ID)
            ->setNAME($nAME)
            ->setPARENT_CUSTOMER_GROUP_ID($pARENT_CUSTOMER_GROUP_ID)
            ->setCURRENT_BALANCE($cURRENT_BALANCE)
            ->setCREDIT_LIMIT($cREDIT_LIMIT)
            ->setPO_NUMBER_OPTIONAL($pO_NUMBER_OPTIONAL)
            ->setREFERENCE($rEFERENCE)
            ->setSHOW_EX_VAT_PRICES($sHOW_EX_VAT_PRICES)
            ->setGROUP_SHARE_ORDERS($gROUP_SHARE_ORDERS)
            ->setMINIMUM_ORDER_VALUE($mINIMUM_ORDER_VALUE)
            ->setIS_VATABLE($iS_VATABLE)
            ->setALLOW_DISCOUNTS($aLLOW_DISCOUNTS)
            ->setAPPLICABLE_CATEGORY_ID($aPPLICABLE_CATEGORY_ID)
            ->setVIEW_SAME_LEVEL_DATA($vIEW_SAME_LEVEL_DATA)
            ->setHIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS($hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS)
            ->setAVAILABLE_CREDIT($aVAILABLE_CREDIT)
            ->setCUSTOMERS($cUSTOMERS)
            ->setTRADE_DISCOUNTS($tRADE_DISCOUNTS);
    }
    /**
     * Get CUSTOMER_GROUP_ID value
     * @return int|null
     */
    public function getCUSTOMER_GROUP_ID()
    {
        return $this->CUSTOMER_GROUP_ID;
    }
    /**
     * Set CUSTOMER_GROUP_ID value
     * @param int $cUSTOMER_GROUP_ID
     * @return \StructType\CustomerGroupType
     */
    public function setCUSTOMER_GROUP_ID($cUSTOMER_GROUP_ID = null)
    {
        // validation for constraint: int
        if (!is_null($cUSTOMER_GROUP_ID) && !(is_int($cUSTOMER_GROUP_ID) || ctype_digit($cUSTOMER_GROUP_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cUSTOMER_GROUP_ID, true), gettype($cUSTOMER_GROUP_ID)), __LINE__);
        }
        $this->CUSTOMER_GROUP_ID = $cUSTOMER_GROUP_ID;
        return $this;
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \StructType\CustomerGroupType
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nAME, true), gettype($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get PARENT_CUSTOMER_GROUP_ID value
     * @return int|null
     */
    public function getPARENT_CUSTOMER_GROUP_ID()
    {
        return $this->PARENT_CUSTOMER_GROUP_ID;
    }
    /**
     * Set PARENT_CUSTOMER_GROUP_ID value
     * @param int $pARENT_CUSTOMER_GROUP_ID
     * @return \StructType\CustomerGroupType
     */
    public function setPARENT_CUSTOMER_GROUP_ID($pARENT_CUSTOMER_GROUP_ID = null)
    {
        // validation for constraint: int
        if (!is_null($pARENT_CUSTOMER_GROUP_ID) && !(is_int($pARENT_CUSTOMER_GROUP_ID) || ctype_digit($pARENT_CUSTOMER_GROUP_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pARENT_CUSTOMER_GROUP_ID, true), gettype($pARENT_CUSTOMER_GROUP_ID)), __LINE__);
        }
        $this->PARENT_CUSTOMER_GROUP_ID = $pARENT_CUSTOMER_GROUP_ID;
        return $this;
    }
    /**
     * Get CURRENT_BALANCE value
     * @return float|null
     */
    public function getCURRENT_BALANCE()
    {
        return $this->CURRENT_BALANCE;
    }
    /**
     * Set CURRENT_BALANCE value
     * @param float $cURRENT_BALANCE
     * @return \StructType\CustomerGroupType
     */
    public function setCURRENT_BALANCE($cURRENT_BALANCE = null)
    {
        // validation for constraint: float
        if (!is_null($cURRENT_BALANCE) && !(is_float($cURRENT_BALANCE) || is_numeric($cURRENT_BALANCE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cURRENT_BALANCE, true), gettype($cURRENT_BALANCE)), __LINE__);
        }
        $this->CURRENT_BALANCE = $cURRENT_BALANCE;
        return $this;
    }
    /**
     * Get CREDIT_LIMIT value
     * @return float|null
     */
    public function getCREDIT_LIMIT()
    {
        return $this->CREDIT_LIMIT;
    }
    /**
     * Set CREDIT_LIMIT value
     * @param float $cREDIT_LIMIT
     * @return \StructType\CustomerGroupType
     */
    public function setCREDIT_LIMIT($cREDIT_LIMIT = null)
    {
        // validation for constraint: float
        if (!is_null($cREDIT_LIMIT) && !(is_float($cREDIT_LIMIT) || is_numeric($cREDIT_LIMIT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cREDIT_LIMIT, true), gettype($cREDIT_LIMIT)), __LINE__);
        }
        $this->CREDIT_LIMIT = $cREDIT_LIMIT;
        return $this;
    }
    /**
     * Get PO_NUMBER_OPTIONAL value
     * @return string|null
     */
    public function getPO_NUMBER_OPTIONAL()
    {
        return $this->PO_NUMBER_OPTIONAL;
    }
    /**
     * Set PO_NUMBER_OPTIONAL value
     * @param string $pO_NUMBER_OPTIONAL
     * @return \StructType\CustomerGroupType
     */
    public function setPO_NUMBER_OPTIONAL($pO_NUMBER_OPTIONAL = null)
    {
        // validation for constraint: string
        if (!is_null($pO_NUMBER_OPTIONAL) && !is_string($pO_NUMBER_OPTIONAL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pO_NUMBER_OPTIONAL, true), gettype($pO_NUMBER_OPTIONAL)), __LINE__);
        }
        $this->PO_NUMBER_OPTIONAL = $pO_NUMBER_OPTIONAL;
        return $this;
    }
    /**
     * Get REFERENCE value
     * @return string|null
     */
    public function getREFERENCE()
    {
        return $this->REFERENCE;
    }
    /**
     * Set REFERENCE value
     * @param string $rEFERENCE
     * @return \StructType\CustomerGroupType
     */
    public function setREFERENCE($rEFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($rEFERENCE) && !is_string($rEFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rEFERENCE, true), gettype($rEFERENCE)), __LINE__);
        }
        $this->REFERENCE = $rEFERENCE;
        return $this;
    }
    /**
     * Get SHOW_EX_VAT_PRICES value
     * @return string|null
     */
    public function getSHOW_EX_VAT_PRICES()
    {
        return $this->SHOW_EX_VAT_PRICES;
    }
    /**
     * Set SHOW_EX_VAT_PRICES value
     * @param string $sHOW_EX_VAT_PRICES
     * @return \StructType\CustomerGroupType
     */
    public function setSHOW_EX_VAT_PRICES($sHOW_EX_VAT_PRICES = null)
    {
        // validation for constraint: string
        if (!is_null($sHOW_EX_VAT_PRICES) && !is_string($sHOW_EX_VAT_PRICES)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sHOW_EX_VAT_PRICES, true), gettype($sHOW_EX_VAT_PRICES)), __LINE__);
        }
        $this->SHOW_EX_VAT_PRICES = $sHOW_EX_VAT_PRICES;
        return $this;
    }
    /**
     * Get GROUP_SHARE_ORDERS value
     * @return string|null
     */
    public function getGROUP_SHARE_ORDERS()
    {
        return $this->GROUP_SHARE_ORDERS;
    }
    /**
     * Set GROUP_SHARE_ORDERS value
     * @param string $gROUP_SHARE_ORDERS
     * @return \StructType\CustomerGroupType
     */
    public function setGROUP_SHARE_ORDERS($gROUP_SHARE_ORDERS = null)
    {
        // validation for constraint: string
        if (!is_null($gROUP_SHARE_ORDERS) && !is_string($gROUP_SHARE_ORDERS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gROUP_SHARE_ORDERS, true), gettype($gROUP_SHARE_ORDERS)), __LINE__);
        }
        $this->GROUP_SHARE_ORDERS = $gROUP_SHARE_ORDERS;
        return $this;
    }
    /**
     * Get MINIMUM_ORDER_VALUE value
     * @return float|null
     */
    public function getMINIMUM_ORDER_VALUE()
    {
        return $this->MINIMUM_ORDER_VALUE;
    }
    /**
     * Set MINIMUM_ORDER_VALUE value
     * @param float $mINIMUM_ORDER_VALUE
     * @return \StructType\CustomerGroupType
     */
    public function setMINIMUM_ORDER_VALUE($mINIMUM_ORDER_VALUE = null)
    {
        // validation for constraint: float
        if (!is_null($mINIMUM_ORDER_VALUE) && !(is_float($mINIMUM_ORDER_VALUE) || is_numeric($mINIMUM_ORDER_VALUE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mINIMUM_ORDER_VALUE, true), gettype($mINIMUM_ORDER_VALUE)), __LINE__);
        }
        $this->MINIMUM_ORDER_VALUE = $mINIMUM_ORDER_VALUE;
        return $this;
    }
    /**
     * Get IS_VATABLE value
     * @return string|null
     */
    public function getIS_VATABLE()
    {
        return $this->IS_VATABLE;
    }
    /**
     * Set IS_VATABLE value
     * @param string $iS_VATABLE
     * @return \StructType\CustomerGroupType
     */
    public function setIS_VATABLE($iS_VATABLE = null)
    {
        // validation for constraint: string
        if (!is_null($iS_VATABLE) && !is_string($iS_VATABLE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iS_VATABLE, true), gettype($iS_VATABLE)), __LINE__);
        }
        $this->IS_VATABLE = $iS_VATABLE;
        return $this;
    }
    /**
     * Get ALLOW_DISCOUNTS value
     * @return string|null
     */
    public function getALLOW_DISCOUNTS()
    {
        return $this->ALLOW_DISCOUNTS;
    }
    /**
     * Set ALLOW_DISCOUNTS value
     * @param string $aLLOW_DISCOUNTS
     * @return \StructType\CustomerGroupType
     */
    public function setALLOW_DISCOUNTS($aLLOW_DISCOUNTS = null)
    {
        // validation for constraint: string
        if (!is_null($aLLOW_DISCOUNTS) && !is_string($aLLOW_DISCOUNTS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aLLOW_DISCOUNTS, true), gettype($aLLOW_DISCOUNTS)), __LINE__);
        }
        $this->ALLOW_DISCOUNTS = $aLLOW_DISCOUNTS;
        return $this;
    }
    /**
     * Get APPLICABLE_CATEGORY_ID value
     * @return int|null
     */
    public function getAPPLICABLE_CATEGORY_ID()
    {
        return $this->APPLICABLE_CATEGORY_ID;
    }
    /**
     * Set APPLICABLE_CATEGORY_ID value
     * @param int $aPPLICABLE_CATEGORY_ID
     * @return \StructType\CustomerGroupType
     */
    public function setAPPLICABLE_CATEGORY_ID($aPPLICABLE_CATEGORY_ID = null)
    {
        // validation for constraint: int
        if (!is_null($aPPLICABLE_CATEGORY_ID) && !(is_int($aPPLICABLE_CATEGORY_ID) || ctype_digit($aPPLICABLE_CATEGORY_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aPPLICABLE_CATEGORY_ID, true), gettype($aPPLICABLE_CATEGORY_ID)), __LINE__);
        }
        $this->APPLICABLE_CATEGORY_ID = $aPPLICABLE_CATEGORY_ID;
        return $this;
    }
    /**
     * Get VIEW_SAME_LEVEL_DATA value
     * @return string|null
     */
    public function getVIEW_SAME_LEVEL_DATA()
    {
        return $this->VIEW_SAME_LEVEL_DATA;
    }
    /**
     * Set VIEW_SAME_LEVEL_DATA value
     * @param string $vIEW_SAME_LEVEL_DATA
     * @return \StructType\CustomerGroupType
     */
    public function setVIEW_SAME_LEVEL_DATA($vIEW_SAME_LEVEL_DATA = null)
    {
        // validation for constraint: string
        if (!is_null($vIEW_SAME_LEVEL_DATA) && !is_string($vIEW_SAME_LEVEL_DATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vIEW_SAME_LEVEL_DATA, true), gettype($vIEW_SAME_LEVEL_DATA)), __LINE__);
        }
        $this->VIEW_SAME_LEVEL_DATA = $vIEW_SAME_LEVEL_DATA;
        return $this;
    }
    /**
     * Get HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS value
     * @return string|null
     */
    public function getHIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS()
    {
        return $this->HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS;
    }
    /**
     * Set HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS value
     * @param string $hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS
     * @return \StructType\CustomerGroupType
     */
    public function setHIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS($hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS = null)
    {
        // validation for constraint: string
        if (!is_null($hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS) && !is_string($hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS, true), gettype($hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS)), __LINE__);
        }
        $this->HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS = $hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS;
        return $this;
    }
    /**
     * Get AVAILABLE_CREDIT value
     * @return float|null
     */
    public function getAVAILABLE_CREDIT()
    {
        return $this->AVAILABLE_CREDIT;
    }
    /**
     * Set AVAILABLE_CREDIT value
     * @param float $aVAILABLE_CREDIT
     * @return \StructType\CustomerGroupType
     */
    public function setAVAILABLE_CREDIT($aVAILABLE_CREDIT = null)
    {
        // validation for constraint: float
        if (!is_null($aVAILABLE_CREDIT) && !(is_float($aVAILABLE_CREDIT) || is_numeric($aVAILABLE_CREDIT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aVAILABLE_CREDIT, true), gettype($aVAILABLE_CREDIT)), __LINE__);
        }
        $this->AVAILABLE_CREDIT = $aVAILABLE_CREDIT;
        return $this;
    }
    /**
     * Get CUSTOMERS value
     * @return \ArrayType\ArrayOfSimpleCustomers|null
     */
    public function getCUSTOMERS()
    {
        return $this->CUSTOMERS;
    }
    /**
     * Set CUSTOMERS value
     * @param \ArrayType\ArrayOfSimpleCustomers $cUSTOMERS
     * @return \StructType\CustomerGroupType
     */
    public function setCUSTOMERS(\ArrayType\ArrayOfSimpleCustomers $cUSTOMERS = null)
    {
        $this->CUSTOMERS = $cUSTOMERS;
        return $this;
    }
    /**
     * Get TRADE_DISCOUNTS value
     * @return \StructType\TRADE_DISCOUNTS|null
     */
    public function getTRADE_DISCOUNTS()
    {
        return $this->TRADE_DISCOUNTS;
    }
    /**
     * Set TRADE_DISCOUNTS value
     * @param \StructType\TRADE_DISCOUNTS $tRADE_DISCOUNTS
     * @return \StructType\CustomerGroupType
     */
    public function setTRADE_DISCOUNTS(\StructType\TRADE_DISCOUNTS $tRADE_DISCOUNTS = null)
    {
        $this->TRADE_DISCOUNTS = $tRADE_DISCOUNTS;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerGroupType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
