<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddCustomerGroupType StructType
 * @subpackage Structs
 */
class AddCustomerGroupType extends AbstractStructBase
{
    /**
     * The NAME
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $NAME;
    /**
     * The CUSTOMER_GROUP_ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CUSTOMER_GROUP_ID;
    /**
     * The CUSTOMER_GROUP_REFERENCE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CUSTOMER_GROUP_REFERENCE;
    /**
     * The PO_NUMBER_OPTIONAL
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PO_NUMBER_OPTIONAL;
    /**
     * The SHOW_EX_VAT_PRICES
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SHOW_EX_VAT_PRICES;
    /**
     * The GROUP_SHARE_ORDERS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GROUP_SHARE_ORDERS;
    /**
     * The IS_VATABLE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IS_VATABLE;
    /**
     * The ALLOW_DISCOUNTS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ALLOW_DISCOUNTS;
    /**
     * The VIEW_SAME_LEVEL_DATA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VIEW_SAME_LEVEL_DATA;
    /**
     * The HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS;
    /**
     * The PARENT_CUSTOMER_GROUP_ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $PARENT_CUSTOMER_GROUP_ID;
    /**
     * The MINIMUM_ORDER_VALUE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MINIMUM_ORDER_VALUE;
    /**
     * The APPLICABLE_CATEGORY_ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $APPLICABLE_CATEGORY_ID;
    /**
     * The CURRENT_BALANCE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $CURRENT_BALANCE;
    /**
     * The CREDIT_LIMIT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $CREDIT_LIMIT;
    /**
     * Constructor method for AddCustomerGroupType
     * @uses AddCustomerGroupType::setNAME()
     * @uses AddCustomerGroupType::setCUSTOMER_GROUP_ID()
     * @uses AddCustomerGroupType::setCUSTOMER_GROUP_REFERENCE()
     * @uses AddCustomerGroupType::setPO_NUMBER_OPTIONAL()
     * @uses AddCustomerGroupType::setSHOW_EX_VAT_PRICES()
     * @uses AddCustomerGroupType::setGROUP_SHARE_ORDERS()
     * @uses AddCustomerGroupType::setIS_VATABLE()
     * @uses AddCustomerGroupType::setALLOW_DISCOUNTS()
     * @uses AddCustomerGroupType::setVIEW_SAME_LEVEL_DATA()
     * @uses AddCustomerGroupType::setHIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS()
     * @uses AddCustomerGroupType::setPARENT_CUSTOMER_GROUP_ID()
     * @uses AddCustomerGroupType::setMINIMUM_ORDER_VALUE()
     * @uses AddCustomerGroupType::setAPPLICABLE_CATEGORY_ID()
     * @uses AddCustomerGroupType::setCURRENT_BALANCE()
     * @uses AddCustomerGroupType::setCREDIT_LIMIT()
     * @param string $nAME
     * @param int $cUSTOMER_GROUP_ID
     * @param string $cUSTOMER_GROUP_REFERENCE
     * @param string $pO_NUMBER_OPTIONAL
     * @param string $sHOW_EX_VAT_PRICES
     * @param string $gROUP_SHARE_ORDERS
     * @param string $iS_VATABLE
     * @param string $aLLOW_DISCOUNTS
     * @param string $vIEW_SAME_LEVEL_DATA
     * @param string $hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS
     * @param int $pARENT_CUSTOMER_GROUP_ID
     * @param float $mINIMUM_ORDER_VALUE
     * @param int $aPPLICABLE_CATEGORY_ID
     * @param float $cURRENT_BALANCE
     * @param float $cREDIT_LIMIT
     */
    public function __construct($nAME = null, $cUSTOMER_GROUP_ID = null, $cUSTOMER_GROUP_REFERENCE = null, $pO_NUMBER_OPTIONAL = null, $sHOW_EX_VAT_PRICES = null, $gROUP_SHARE_ORDERS = null, $iS_VATABLE = null, $aLLOW_DISCOUNTS = null, $vIEW_SAME_LEVEL_DATA = null, $hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS = null, $pARENT_CUSTOMER_GROUP_ID = null, $mINIMUM_ORDER_VALUE = null, $aPPLICABLE_CATEGORY_ID = null, $cURRENT_BALANCE = null, $cREDIT_LIMIT = null)
    {
        $this
            ->setNAME($nAME)
            ->setCUSTOMER_GROUP_ID($cUSTOMER_GROUP_ID)
            ->setCUSTOMER_GROUP_REFERENCE($cUSTOMER_GROUP_REFERENCE)
            ->setPO_NUMBER_OPTIONAL($pO_NUMBER_OPTIONAL)
            ->setSHOW_EX_VAT_PRICES($sHOW_EX_VAT_PRICES)
            ->setGROUP_SHARE_ORDERS($gROUP_SHARE_ORDERS)
            ->setIS_VATABLE($iS_VATABLE)
            ->setALLOW_DISCOUNTS($aLLOW_DISCOUNTS)
            ->setVIEW_SAME_LEVEL_DATA($vIEW_SAME_LEVEL_DATA)
            ->setHIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS($hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS)
            ->setPARENT_CUSTOMER_GROUP_ID($pARENT_CUSTOMER_GROUP_ID)
            ->setMINIMUM_ORDER_VALUE($mINIMUM_ORDER_VALUE)
            ->setAPPLICABLE_CATEGORY_ID($aPPLICABLE_CATEGORY_ID)
            ->setCURRENT_BALANCE($cURRENT_BALANCE)
            ->setCREDIT_LIMIT($cREDIT_LIMIT);
    }
    /**
     * Get NAME value
     * @return string
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \StructType\AddCustomerGroupType
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nAME, true), gettype($nAME)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nAME) && mb_strlen($nAME) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get CUSTOMER_GROUP_ID value
     * @return int|null
     */
    public function getCUSTOMER_GROUP_ID()
    {
        return $this->CUSTOMER_GROUP_ID;
    }
    /**
     * Set CUSTOMER_GROUP_ID value
     * @param int $cUSTOMER_GROUP_ID
     * @return \StructType\AddCustomerGroupType
     */
    public function setCUSTOMER_GROUP_ID($cUSTOMER_GROUP_ID = null)
    {
        // validation for constraint: int
        if (!is_null($cUSTOMER_GROUP_ID) && !(is_int($cUSTOMER_GROUP_ID) || ctype_digit($cUSTOMER_GROUP_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cUSTOMER_GROUP_ID, true), gettype($cUSTOMER_GROUP_ID)), __LINE__);
        }
        $this->CUSTOMER_GROUP_ID = $cUSTOMER_GROUP_ID;
        return $this;
    }
    /**
     * Get CUSTOMER_GROUP_REFERENCE value
     * @return string|null
     */
    public function getCUSTOMER_GROUP_REFERENCE()
    {
        return $this->CUSTOMER_GROUP_REFERENCE;
    }
    /**
     * Set CUSTOMER_GROUP_REFERENCE value
     * @param string $cUSTOMER_GROUP_REFERENCE
     * @return \StructType\AddCustomerGroupType
     */
    public function setCUSTOMER_GROUP_REFERENCE($cUSTOMER_GROUP_REFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($cUSTOMER_GROUP_REFERENCE) && !is_string($cUSTOMER_GROUP_REFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cUSTOMER_GROUP_REFERENCE, true), gettype($cUSTOMER_GROUP_REFERENCE)), __LINE__);
        }
        $this->CUSTOMER_GROUP_REFERENCE = $cUSTOMER_GROUP_REFERENCE;
        return $this;
    }
    /**
     * Get PO_NUMBER_OPTIONAL value
     * @return string|null
     */
    public function getPO_NUMBER_OPTIONAL()
    {
        return $this->PO_NUMBER_OPTIONAL;
    }
    /**
     * Set PO_NUMBER_OPTIONAL value
     * @uses \EnumType\YesNoStringType::valueIsValid()
     * @uses \EnumType\YesNoStringType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pO_NUMBER_OPTIONAL
     * @return \StructType\AddCustomerGroupType
     */
    public function setPO_NUMBER_OPTIONAL($pO_NUMBER_OPTIONAL = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoStringType::valueIsValid($pO_NUMBER_OPTIONAL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\YesNoStringType', is_array($pO_NUMBER_OPTIONAL) ? implode(', ', $pO_NUMBER_OPTIONAL) : var_export($pO_NUMBER_OPTIONAL, true), implode(', ', \EnumType\YesNoStringType::getValidValues())), __LINE__);
        }
        $this->PO_NUMBER_OPTIONAL = $pO_NUMBER_OPTIONAL;
        return $this;
    }
    /**
     * Get SHOW_EX_VAT_PRICES value
     * @return string|null
     */
    public function getSHOW_EX_VAT_PRICES()
    {
        return $this->SHOW_EX_VAT_PRICES;
    }
    /**
     * Set SHOW_EX_VAT_PRICES value
     * @uses \EnumType\YesNoStringType::valueIsValid()
     * @uses \EnumType\YesNoStringType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sHOW_EX_VAT_PRICES
     * @return \StructType\AddCustomerGroupType
     */
    public function setSHOW_EX_VAT_PRICES($sHOW_EX_VAT_PRICES = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoStringType::valueIsValid($sHOW_EX_VAT_PRICES)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\YesNoStringType', is_array($sHOW_EX_VAT_PRICES) ? implode(', ', $sHOW_EX_VAT_PRICES) : var_export($sHOW_EX_VAT_PRICES, true), implode(', ', \EnumType\YesNoStringType::getValidValues())), __LINE__);
        }
        $this->SHOW_EX_VAT_PRICES = $sHOW_EX_VAT_PRICES;
        return $this;
    }
    /**
     * Get GROUP_SHARE_ORDERS value
     * @return string|null
     */
    public function getGROUP_SHARE_ORDERS()
    {
        return $this->GROUP_SHARE_ORDERS;
    }
    /**
     * Set GROUP_SHARE_ORDERS value
     * @uses \EnumType\YesNoStringType::valueIsValid()
     * @uses \EnumType\YesNoStringType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gROUP_SHARE_ORDERS
     * @return \StructType\AddCustomerGroupType
     */
    public function setGROUP_SHARE_ORDERS($gROUP_SHARE_ORDERS = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoStringType::valueIsValid($gROUP_SHARE_ORDERS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\YesNoStringType', is_array($gROUP_SHARE_ORDERS) ? implode(', ', $gROUP_SHARE_ORDERS) : var_export($gROUP_SHARE_ORDERS, true), implode(', ', \EnumType\YesNoStringType::getValidValues())), __LINE__);
        }
        $this->GROUP_SHARE_ORDERS = $gROUP_SHARE_ORDERS;
        return $this;
    }
    /**
     * Get IS_VATABLE value
     * @return string|null
     */
    public function getIS_VATABLE()
    {
        return $this->IS_VATABLE;
    }
    /**
     * Set IS_VATABLE value
     * @uses \EnumType\YesNoStringType::valueIsValid()
     * @uses \EnumType\YesNoStringType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iS_VATABLE
     * @return \StructType\AddCustomerGroupType
     */
    public function setIS_VATABLE($iS_VATABLE = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoStringType::valueIsValid($iS_VATABLE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\YesNoStringType', is_array($iS_VATABLE) ? implode(', ', $iS_VATABLE) : var_export($iS_VATABLE, true), implode(', ', \EnumType\YesNoStringType::getValidValues())), __LINE__);
        }
        $this->IS_VATABLE = $iS_VATABLE;
        return $this;
    }
    /**
     * Get ALLOW_DISCOUNTS value
     * @return string|null
     */
    public function getALLOW_DISCOUNTS()
    {
        return $this->ALLOW_DISCOUNTS;
    }
    /**
     * Set ALLOW_DISCOUNTS value
     * @uses \EnumType\YesNoStringType::valueIsValid()
     * @uses \EnumType\YesNoStringType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $aLLOW_DISCOUNTS
     * @return \StructType\AddCustomerGroupType
     */
    public function setALLOW_DISCOUNTS($aLLOW_DISCOUNTS = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoStringType::valueIsValid($aLLOW_DISCOUNTS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\YesNoStringType', is_array($aLLOW_DISCOUNTS) ? implode(', ', $aLLOW_DISCOUNTS) : var_export($aLLOW_DISCOUNTS, true), implode(', ', \EnumType\YesNoStringType::getValidValues())), __LINE__);
        }
        $this->ALLOW_DISCOUNTS = $aLLOW_DISCOUNTS;
        return $this;
    }
    /**
     * Get VIEW_SAME_LEVEL_DATA value
     * @return string|null
     */
    public function getVIEW_SAME_LEVEL_DATA()
    {
        return $this->VIEW_SAME_LEVEL_DATA;
    }
    /**
     * Set VIEW_SAME_LEVEL_DATA value
     * @uses \EnumType\YesNoStringType::valueIsValid()
     * @uses \EnumType\YesNoStringType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vIEW_SAME_LEVEL_DATA
     * @return \StructType\AddCustomerGroupType
     */
    public function setVIEW_SAME_LEVEL_DATA($vIEW_SAME_LEVEL_DATA = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoStringType::valueIsValid($vIEW_SAME_LEVEL_DATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\YesNoStringType', is_array($vIEW_SAME_LEVEL_DATA) ? implode(', ', $vIEW_SAME_LEVEL_DATA) : var_export($vIEW_SAME_LEVEL_DATA, true), implode(', ', \EnumType\YesNoStringType::getValidValues())), __LINE__);
        }
        $this->VIEW_SAME_LEVEL_DATA = $vIEW_SAME_LEVEL_DATA;
        return $this;
    }
    /**
     * Get HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS value
     * @return string|null
     */
    public function getHIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS()
    {
        return $this->HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS;
    }
    /**
     * Set HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS value
     * @uses \EnumType\YesNoStringType::valueIsValid()
     * @uses \EnumType\YesNoStringType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS
     * @return \StructType\AddCustomerGroupType
     */
    public function setHIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS($hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoStringType::valueIsValid($hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\YesNoStringType', is_array($hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS) ? implode(', ', $hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS) : var_export($hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS, true), implode(', ', \EnumType\YesNoStringType::getValidValues())), __LINE__);
        }
        $this->HIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS = $hIDE_TRADE_ONLY_PRODUCTS_NOT_ON_PRICELISTS;
        return $this;
    }
    /**
     * Get PARENT_CUSTOMER_GROUP_ID value
     * @return int|null
     */
    public function getPARENT_CUSTOMER_GROUP_ID()
    {
        return $this->PARENT_CUSTOMER_GROUP_ID;
    }
    /**
     * Set PARENT_CUSTOMER_GROUP_ID value
     * @param int $pARENT_CUSTOMER_GROUP_ID
     * @return \StructType\AddCustomerGroupType
     */
    public function setPARENT_CUSTOMER_GROUP_ID($pARENT_CUSTOMER_GROUP_ID = null)
    {
        // validation for constraint: int
        if (!is_null($pARENT_CUSTOMER_GROUP_ID) && !(is_int($pARENT_CUSTOMER_GROUP_ID) || ctype_digit($pARENT_CUSTOMER_GROUP_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pARENT_CUSTOMER_GROUP_ID, true), gettype($pARENT_CUSTOMER_GROUP_ID)), __LINE__);
        }
        $this->PARENT_CUSTOMER_GROUP_ID = $pARENT_CUSTOMER_GROUP_ID;
        return $this;
    }
    /**
     * Get MINIMUM_ORDER_VALUE value
     * @return float|null
     */
    public function getMINIMUM_ORDER_VALUE()
    {
        return $this->MINIMUM_ORDER_VALUE;
    }
    /**
     * Set MINIMUM_ORDER_VALUE value
     * @param float $mINIMUM_ORDER_VALUE
     * @return \StructType\AddCustomerGroupType
     */
    public function setMINIMUM_ORDER_VALUE($mINIMUM_ORDER_VALUE = null)
    {
        // validation for constraint: float
        if (!is_null($mINIMUM_ORDER_VALUE) && !(is_float($mINIMUM_ORDER_VALUE) || is_numeric($mINIMUM_ORDER_VALUE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mINIMUM_ORDER_VALUE, true), gettype($mINIMUM_ORDER_VALUE)), __LINE__);
        }
        $this->MINIMUM_ORDER_VALUE = $mINIMUM_ORDER_VALUE;
        return $this;
    }
    /**
     * Get APPLICABLE_CATEGORY_ID value
     * @return int|null
     */
    public function getAPPLICABLE_CATEGORY_ID()
    {
        return $this->APPLICABLE_CATEGORY_ID;
    }
    /**
     * Set APPLICABLE_CATEGORY_ID value
     * @param int $aPPLICABLE_CATEGORY_ID
     * @return \StructType\AddCustomerGroupType
     */
    public function setAPPLICABLE_CATEGORY_ID($aPPLICABLE_CATEGORY_ID = null)
    {
        // validation for constraint: int
        if (!is_null($aPPLICABLE_CATEGORY_ID) && !(is_int($aPPLICABLE_CATEGORY_ID) || ctype_digit($aPPLICABLE_CATEGORY_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aPPLICABLE_CATEGORY_ID, true), gettype($aPPLICABLE_CATEGORY_ID)), __LINE__);
        }
        $this->APPLICABLE_CATEGORY_ID = $aPPLICABLE_CATEGORY_ID;
        return $this;
    }
    /**
     * Get CURRENT_BALANCE value
     * @return float|null
     */
    public function getCURRENT_BALANCE()
    {
        return $this->CURRENT_BALANCE;
    }
    /**
     * Set CURRENT_BALANCE value
     * @param float $cURRENT_BALANCE
     * @return \StructType\AddCustomerGroupType
     */
    public function setCURRENT_BALANCE($cURRENT_BALANCE = null)
    {
        // validation for constraint: float
        if (!is_null($cURRENT_BALANCE) && !(is_float($cURRENT_BALANCE) || is_numeric($cURRENT_BALANCE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cURRENT_BALANCE, true), gettype($cURRENT_BALANCE)), __LINE__);
        }
        $this->CURRENT_BALANCE = $cURRENT_BALANCE;
        return $this;
    }
    /**
     * Get CREDIT_LIMIT value
     * @return float|null
     */
    public function getCREDIT_LIMIT()
    {
        return $this->CREDIT_LIMIT;
    }
    /**
     * Set CREDIT_LIMIT value
     * @param float $cREDIT_LIMIT
     * @return \StructType\AddCustomerGroupType
     */
    public function setCREDIT_LIMIT($cREDIT_LIMIT = null)
    {
        // validation for constraint: float
        if (!is_null($cREDIT_LIMIT) && !(is_float($cREDIT_LIMIT) || is_numeric($cREDIT_LIMIT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cREDIT_LIMIT, true), gettype($cREDIT_LIMIT)), __LINE__);
        }
        $this->CREDIT_LIMIT = $cREDIT_LIMIT;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddCustomerGroupType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
