<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Sets the VSAuthType SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\VSAuthType $vSAuthType
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderVSAuthType(\StructType\VSAuthType $vSAuthType, $nameSpace = 'https://demo.visualsoft.co.uk/api/soap/service/5', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'VSAuthType', $vSAuthType, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SetStock
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://demo.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: \StructType\VSAuthType
     * - SOAPHeaders: required
     * - documentation: Sets the stock level to the given amount for the given product reference.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $product_reference
     * @param string $stock_level
     * @return \StructType\ResultType|bool
     */
    public function SetStock($product_reference, $stock_level)
    {
        try {
            $this->setResult($this->getSoapClient()->SetStock($product_reference, $stock_level));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetProductSortOrders
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://demo.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: \StructType\VSAuthType
     * - SOAPHeaders: required
     * - documentation: Set the sort order of products
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sort_data
     * @return \StructType\ResultType|bool
     */
    public function SetProductSortOrders($sort_data)
    {
        try {
            $this->setResult($this->getSoapClient()->SetProductSortOrders($sort_data));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetStockInLocation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://demo.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: \StructType\VSAuthType
     * - SOAPHeaders: required
     * - documentation: Update the stock for a specific product in a specifc stock location
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $product_reference
     * @param string $stock_level
     * @param string $stock_location
     * @param string $allow_minus_one_change
     * @return \StructType\ResultType|bool
     */
    public function SetStockInLocation($product_reference, $stock_level, $stock_location, $allow_minus_one_change)
    {
        try {
            $this->setResult($this->getSoapClient()->SetStockInLocation($product_reference, $stock_level, $stock_location, $allow_minus_one_change));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetStockMultiple
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://demo.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: \StructType\VSAuthType
     * - SOAPHeaders: required
     * - documentation: Get stock levels of multiple products in a single request
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetStockMultipleType $stock_update_data
     * @return \StructType\ResultType|bool
     */
    public function SetStockMultiple(\StructType\SetStockMultipleType $stock_update_data)
    {
        try {
            $this->setResult($this->getSoapClient()->SetStockMultiple($stock_update_data));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResultType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
