<?php

namespace EnumType;

/**
 * This class stands for ChannelType EnumType
 * @subpackage Enumerations
 */
class ChannelType
{
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'Website'
     * @return string 'Website'
     */
    const VALUE_WEBSITE = 'Website';
    /**
     * Constant for value 'Amazon'
     * @return string 'Amazon'
     */
    const VALUE_AMAZON = 'Amazon';
    /**
     * Constant for value 'eBay'
     * @return string 'eBay'
     */
    const VALUE_E_BAY = 'eBay';
    /**
     * Constant for value 'Play'
     * @return string 'Play'
     */
    const VALUE_PLAY = 'Play';
    /**
     * Constant for value 'Mobile'
     * @return string 'Mobile'
     */
    const VALUE_MOBILE = 'Mobile';
    /**
     * Constant for value 'Amazon Fulfilment'
     * @return string 'Amazon Fulfilment'
     */
    const VALUE_AMAZON_FULFILMENT = 'Amazon Fulfilment';
    /**
     * Constant for value 'Amazon Merchant Fulfilled'
     * @return string 'Amazon Merchant Fulfilled'
     */
    const VALUE_AMAZON_MERCHANT_FULFILLED = 'Amazon Merchant Fulfilled';
    /**
     * Constant for value 'POQ Studio'
     * @return string 'POQ Studio'
     */
    const VALUE_POQ_STUDIO = 'POQ Studio';
    /**
     * Constant for value 'Intu'
     * @return string 'Intu'
     */
    const VALUE_INTU = 'Intu';
    /**
     * Constant for value 'Debenhams'
     * @return string 'Debenhams'
     */
    const VALUE_DEBENHAMS = 'Debenhams';
    /**
     * Constant for value 'Rakuten'
     * @return string 'Rakuten'
     */
    const VALUE_RAKUTEN = 'Rakuten';
    /**
     * Constant for value 'Spartoo'
     * @return string 'Spartoo'
     */
    const VALUE_SPARTOO = 'Spartoo';
    /**
     * Constant for value 'App'
     * @return string 'App'
     */
    const VALUE_APP = 'App';
    /**
     * Constant for value 'Volo - eBay AUS'
     * @return string 'Volo - eBay AUS'
     */
    const VALUE_VOLO_E_BAY_AUS = 'Volo - eBay AUS';
    /**
     * Constant for value 'Volo - eBay USA'
     * @return string 'Volo - eBay USA'
     */
    const VALUE_VOLO_E_BAY_USA = 'Volo - eBay USA';
    /**
     * Constant for value 'Volo - Amazon UK'
     * @return string 'Volo - Amazon UK'
     */
    const VALUE_VOLO_AMAZON_UK = 'Volo - Amazon UK';
    /**
     * Constant for value 'Retail Direct - eBay'
     * @return string 'Retail Direct - eBay'
     */
    const VALUE_RETAIL_DIRECT_E_BAY = 'Retail Direct - eBay';
    /**
     * Constant for value 'Tesco'
     * @return string 'Tesco'
     */
    const VALUE_TESCO = 'Tesco';
    /**
     * Constant for value 'Fruugo'
     * @return string 'Fruugo'
     */
    const VALUE_FRUUGO = 'Fruugo';
    /**
     * Constant for value 'JDWilliams'
     * @return string 'JDWilliams'
     */
    const VALUE_JDWILLIAMS = 'JDWilliams';
    /**
     * Constant for value 'C Discount'
     * @return string 'C Discount'
     */
    const VALUE_C_DISCOUNT = 'C Discount';
    /**
     * Constant for value 'Trade Me'
     * @return string 'Trade Me'
     */
    const VALUE_TRADE_ME = 'Trade Me';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_WEBSITE
     * @uses self::VALUE_AMAZON
     * @uses self::VALUE_E_BAY
     * @uses self::VALUE_PLAY
     * @uses self::VALUE_MOBILE
     * @uses self::VALUE_AMAZON_FULFILMENT
     * @uses self::VALUE_AMAZON_MERCHANT_FULFILLED
     * @uses self::VALUE_POQ_STUDIO
     * @uses self::VALUE_INTU
     * @uses self::VALUE_DEBENHAMS
     * @uses self::VALUE_RAKUTEN
     * @uses self::VALUE_SPARTOO
     * @uses self::VALUE_APP
     * @uses self::VALUE_VOLO_E_BAY_AUS
     * @uses self::VALUE_VOLO_E_BAY_USA
     * @uses self::VALUE_VOLO_AMAZON_UK
     * @uses self::VALUE_RETAIL_DIRECT_E_BAY
     * @uses self::VALUE_TESCO
     * @uses self::VALUE_FRUUGO
     * @uses self::VALUE_JDWILLIAMS
     * @uses self::VALUE_C_DISCOUNT
     * @uses self::VALUE_TRADE_ME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_WEBSITE,
            self::VALUE_AMAZON,
            self::VALUE_E_BAY,
            self::VALUE_PLAY,
            self::VALUE_MOBILE,
            self::VALUE_AMAZON_FULFILMENT,
            self::VALUE_AMAZON_MERCHANT_FULFILLED,
            self::VALUE_POQ_STUDIO,
            self::VALUE_INTU,
            self::VALUE_DEBENHAMS,
            self::VALUE_RAKUTEN,
            self::VALUE_SPARTOO,
            self::VALUE_APP,
            self::VALUE_VOLO_E_BAY_AUS,
            self::VALUE_VOLO_E_BAY_USA,
            self::VALUE_VOLO_AMAZON_UK,
            self::VALUE_RETAIL_DIRECT_E_BAY,
            self::VALUE_TESCO,
            self::VALUE_FRUUGO,
            self::VALUE_JDWILLIAMS,
            self::VALUE_C_DISCOUNT,
            self::VALUE_TRADE_ME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
