<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TradeProduct StructType
 * @subpackage Structs
 */
class TradeProduct extends AbstractStructBase
{
    /**
     * The PRODUCT_REFERENCE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PRODUCT_REFERENCE;
    /**
     * The PRODUCT_PRICE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PRODUCT_PRICE;
    /**
     * Constructor method for TradeProduct
     * @uses TradeProduct::setPRODUCT_REFERENCE()
     * @uses TradeProduct::setPRODUCT_PRICE()
     * @param string $pRODUCT_REFERENCE
     * @param float $pRODUCT_PRICE
     */
    public function __construct($pRODUCT_REFERENCE = null, $pRODUCT_PRICE = null)
    {
        $this
            ->setPRODUCT_REFERENCE($pRODUCT_REFERENCE)
            ->setPRODUCT_PRICE($pRODUCT_PRICE);
    }
    /**
     * Get PRODUCT_REFERENCE value
     * @return string
     */
    public function getPRODUCT_REFERENCE()
    {
        return $this->PRODUCT_REFERENCE;
    }
    /**
     * Set PRODUCT_REFERENCE value
     * @param string $pRODUCT_REFERENCE
     * @return \StructType\TradeProduct
     */
    public function setPRODUCT_REFERENCE($pRODUCT_REFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($pRODUCT_REFERENCE) && !is_string($pRODUCT_REFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pRODUCT_REFERENCE, true), gettype($pRODUCT_REFERENCE)), __LINE__);
        }
        $this->PRODUCT_REFERENCE = $pRODUCT_REFERENCE;
        return $this;
    }
    /**
     * Get PRODUCT_PRICE value
     * @return float
     */
    public function getPRODUCT_PRICE()
    {
        return $this->PRODUCT_PRICE;
    }
    /**
     * Set PRODUCT_PRICE value
     * @param float $pRODUCT_PRICE
     * @return \StructType\TradeProduct
     */
    public function setPRODUCT_PRICE($pRODUCT_PRICE = null)
    {
        // validation for constraint: float
        if (!is_null($pRODUCT_PRICE) && !(is_float($pRODUCT_PRICE) || is_numeric($pRODUCT_PRICE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pRODUCT_PRICE, true), gettype($pRODUCT_PRICE)), __LINE__);
        }
        $this->PRODUCT_PRICE = $pRODUCT_PRICE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TradeProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
