<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TradeDiscountType StructType
 * @subpackage Structs
 */
class TradeDiscountType extends AbstractStructBase
{
    /**
     * The TRADE_DISCOUNT_ID
     * @var int
     */
    public $TRADE_DISCOUNT_ID;
    /**
     * The NAME
     * @var string
     */
    public $NAME;
    /**
     * The TYPE
     * @var string
     */
    public $TYPE;
    /**
     * The VALUE
     * @var float
     */
    public $VALUE;
    /**
     * The TRADE_DISCOUNT_REFERENCE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TRADE_DISCOUNT_REFERENCE;
    /**
     * The DATE_CREATED
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DATE_CREATED;
    /**
     * The CUSTOMER_GROUPS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CUSTOMER_GROUPS
     */
    public $CUSTOMER_GROUPS;
    /**
     * The TRADE_DISCOUNT_PRODUCTS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTradeProducts
     */
    public $TRADE_DISCOUNT_PRODUCTS;
    /**
     * Constructor method for TradeDiscountType
     * @uses TradeDiscountType::setTRADE_DISCOUNT_ID()
     * @uses TradeDiscountType::setNAME()
     * @uses TradeDiscountType::setTYPE()
     * @uses TradeDiscountType::setVALUE()
     * @uses TradeDiscountType::setTRADE_DISCOUNT_REFERENCE()
     * @uses TradeDiscountType::setDATE_CREATED()
     * @uses TradeDiscountType::setCUSTOMER_GROUPS()
     * @uses TradeDiscountType::setTRADE_DISCOUNT_PRODUCTS()
     * @param int $tRADE_DISCOUNT_ID
     * @param string $nAME
     * @param string $tYPE
     * @param float $vALUE
     * @param string $tRADE_DISCOUNT_REFERENCE
     * @param string $dATE_CREATED
     * @param \StructType\CUSTOMER_GROUPS $cUSTOMER_GROUPS
     * @param \ArrayType\ArrayOfTradeProducts $tRADE_DISCOUNT_PRODUCTS
     */
    public function __construct($tRADE_DISCOUNT_ID = null, $nAME = null, $tYPE = null, $vALUE = null, $tRADE_DISCOUNT_REFERENCE = null, $dATE_CREATED = null, \StructType\CUSTOMER_GROUPS $cUSTOMER_GROUPS = null, \ArrayType\ArrayOfTradeProducts $tRADE_DISCOUNT_PRODUCTS = null)
    {
        $this
            ->setTRADE_DISCOUNT_ID($tRADE_DISCOUNT_ID)
            ->setNAME($nAME)
            ->setTYPE($tYPE)
            ->setVALUE($vALUE)
            ->setTRADE_DISCOUNT_REFERENCE($tRADE_DISCOUNT_REFERENCE)
            ->setDATE_CREATED($dATE_CREATED)
            ->setCUSTOMER_GROUPS($cUSTOMER_GROUPS)
            ->setTRADE_DISCOUNT_PRODUCTS($tRADE_DISCOUNT_PRODUCTS);
    }
    /**
     * Get TRADE_DISCOUNT_ID value
     * @return int|null
     */
    public function getTRADE_DISCOUNT_ID()
    {
        return $this->TRADE_DISCOUNT_ID;
    }
    /**
     * Set TRADE_DISCOUNT_ID value
     * @param int $tRADE_DISCOUNT_ID
     * @return \StructType\TradeDiscountType
     */
    public function setTRADE_DISCOUNT_ID($tRADE_DISCOUNT_ID = null)
    {
        // validation for constraint: int
        if (!is_null($tRADE_DISCOUNT_ID) && !(is_int($tRADE_DISCOUNT_ID) || ctype_digit($tRADE_DISCOUNT_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tRADE_DISCOUNT_ID, true), gettype($tRADE_DISCOUNT_ID)), __LINE__);
        }
        $this->TRADE_DISCOUNT_ID = $tRADE_DISCOUNT_ID;
        return $this;
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \StructType\TradeDiscountType
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nAME, true), gettype($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get TYPE value
     * @return string|null
     */
    public function getTYPE()
    {
        return $this->TYPE;
    }
    /**
     * Set TYPE value
     * @param string $tYPE
     * @return \StructType\TradeDiscountType
     */
    public function setTYPE($tYPE = null)
    {
        // validation for constraint: string
        if (!is_null($tYPE) && !is_string($tYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tYPE, true), gettype($tYPE)), __LINE__);
        }
        $this->TYPE = $tYPE;
        return $this;
    }
    /**
     * Get VALUE value
     * @return float|null
     */
    public function getVALUE()
    {
        return $this->VALUE;
    }
    /**
     * Set VALUE value
     * @param float $vALUE
     * @return \StructType\TradeDiscountType
     */
    public function setVALUE($vALUE = null)
    {
        // validation for constraint: float
        if (!is_null($vALUE) && !(is_float($vALUE) || is_numeric($vALUE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vALUE, true), gettype($vALUE)), __LINE__);
        }
        $this->VALUE = $vALUE;
        return $this;
    }
    /**
     * Get TRADE_DISCOUNT_REFERENCE value
     * @return string|null
     */
    public function getTRADE_DISCOUNT_REFERENCE()
    {
        return $this->TRADE_DISCOUNT_REFERENCE;
    }
    /**
     * Set TRADE_DISCOUNT_REFERENCE value
     * @param string $tRADE_DISCOUNT_REFERENCE
     * @return \StructType\TradeDiscountType
     */
    public function setTRADE_DISCOUNT_REFERENCE($tRADE_DISCOUNT_REFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($tRADE_DISCOUNT_REFERENCE) && !is_string($tRADE_DISCOUNT_REFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tRADE_DISCOUNT_REFERENCE, true), gettype($tRADE_DISCOUNT_REFERENCE)), __LINE__);
        }
        $this->TRADE_DISCOUNT_REFERENCE = $tRADE_DISCOUNT_REFERENCE;
        return $this;
    }
    /**
     * Get DATE_CREATED value
     * @return string|null
     */
    public function getDATE_CREATED()
    {
        return $this->DATE_CREATED;
    }
    /**
     * Set DATE_CREATED value
     * @param string $dATE_CREATED
     * @return \StructType\TradeDiscountType
     */
    public function setDATE_CREATED($dATE_CREATED = null)
    {
        // validation for constraint: string
        if (!is_null($dATE_CREATED) && !is_string($dATE_CREATED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dATE_CREATED, true), gettype($dATE_CREATED)), __LINE__);
        }
        $this->DATE_CREATED = $dATE_CREATED;
        return $this;
    }
    /**
     * Get CUSTOMER_GROUPS value
     * @return \StructType\CUSTOMER_GROUPS|null
     */
    public function getCUSTOMER_GROUPS()
    {
        return $this->CUSTOMER_GROUPS;
    }
    /**
     * Set CUSTOMER_GROUPS value
     * @param \StructType\CUSTOMER_GROUPS $cUSTOMER_GROUPS
     * @return \StructType\TradeDiscountType
     */
    public function setCUSTOMER_GROUPS(\StructType\CUSTOMER_GROUPS $cUSTOMER_GROUPS = null)
    {
        $this->CUSTOMER_GROUPS = $cUSTOMER_GROUPS;
        return $this;
    }
    /**
     * Get TRADE_DISCOUNT_PRODUCTS value
     * @return \ArrayType\ArrayOfTradeProducts|null
     */
    public function getTRADE_DISCOUNT_PRODUCTS()
    {
        return $this->TRADE_DISCOUNT_PRODUCTS;
    }
    /**
     * Set TRADE_DISCOUNT_PRODUCTS value
     * @param \ArrayType\ArrayOfTradeProducts $tRADE_DISCOUNT_PRODUCTS
     * @return \StructType\TradeDiscountType
     */
    public function setTRADE_DISCOUNT_PRODUCTS(\ArrayType\ArrayOfTradeProducts $tRADE_DISCOUNT_PRODUCTS = null)
    {
        $this->TRADE_DISCOUNT_PRODUCTS = $tRADE_DISCOUNT_PRODUCTS;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TradeDiscountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
