<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TAGGROUP StructType
 * @subpackage Structs
 */
class TAGGROUP extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The TAG
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: unbounded
     * - minLength: 1
     * @var string[]
     */
    public $TAG;
    /**
     * Constructor method for TAGGROUP
     * @uses TAGGROUP::setName()
     * @uses TAGGROUP::setTAG()
     * @param string $name
     * @param string[] $tAG
     */
    public function __construct($name = null, array $tAG = array())
    {
        $this
            ->setName($name)
            ->setTAG($tAG);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\TAGGROUP
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name) && mb_strlen($name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get TAG value
     * @return string[]|null
     */
    public function getTAG()
    {
        return $this->TAG;
    }
    /**
     * This method is responsible for validating the values passed to the setTAG method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTAG method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTAGForArrayConstraintsFromSetTAG(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tAGGROUPTAGItem) {
            // validation for constraint: itemType
            if (!is_string($tAGGROUPTAGItem)) {
                $invalidValues[] = is_object($tAGGROUPTAGItem) ? get_class($tAGGROUPTAGItem) : sprintf('%s(%s)', gettype($tAGGROUPTAGItem), var_export($tAGGROUPTAGItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TAG property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setTAG method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTAG method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTAGForMinLengthConstraintFromSetTAG($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tAGGROUPTAGItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($tAGGROUPTAGItem) < 1) {
                $invalidValues[] = var_export($tAGGROUPTAGItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TAG value
     * @throws \InvalidArgumentException
     * @param string[] $tAG
     * @return \StructType\TAGGROUP
     */
    public function setTAG(array $tAG = array())
    {
        // validation for constraint: array
        if ('' !== ($tAGArrayErrorMessage = self::validateTAGForArrayConstraintsFromSetTAG($tAG))) {
            throw new \InvalidArgumentException($tAGArrayErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($tAGMinLengthErrorMessage = self::validateTAGForMinLengthConstraintFromSetTAG($tAG))) {
            throw new \InvalidArgumentException($tAGMinLengthErrorMessage, __LINE__);
        }
        $this->TAG = $tAG;
        return $this;
    }
    /**
     * Add item to TAG value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TAGGROUP
     */
    public function addToTAG($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TAG property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->TAG[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TAGGROUP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
