<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockLocationsType StructType
 * @subpackage Structs
 */
class StockLocationsType extends AbstractStructBase
{
    /**
     * The STOCK_LOCATION
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\STOCK_LOCATION[]
     */
    public $STOCK_LOCATION;
    /**
     * Constructor method for StockLocationsType
     * @uses StockLocationsType::setSTOCK_LOCATION()
     * @param \StructType\STOCK_LOCATION[] $sTOCK_LOCATION
     */
    public function __construct(array $sTOCK_LOCATION = array())
    {
        $this
            ->setSTOCK_LOCATION($sTOCK_LOCATION);
    }
    /**
     * Get STOCK_LOCATION value
     * @return \StructType\STOCK_LOCATION[]|null
     */
    public function getSTOCK_LOCATION()
    {
        return $this->STOCK_LOCATION;
    }
    /**
     * This method is responsible for validating the values passed to the setSTOCK_LOCATION method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSTOCK_LOCATION method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSTOCK_LOCATIONForArrayConstraintsFromSetSTOCK_LOCATION(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stockLocationsTypeSTOCK_LOCATIONItem) {
            // validation for constraint: itemType
            if (!$stockLocationsTypeSTOCK_LOCATIONItem instanceof \StructType\STOCK_LOCATION) {
                $invalidValues[] = is_object($stockLocationsTypeSTOCK_LOCATIONItem) ? get_class($stockLocationsTypeSTOCK_LOCATIONItem) : sprintf('%s(%s)', gettype($stockLocationsTypeSTOCK_LOCATIONItem), var_export($stockLocationsTypeSTOCK_LOCATIONItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The STOCK_LOCATION property can only contain items of type \StructType\STOCK_LOCATION, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set STOCK_LOCATION value
     * @throws \InvalidArgumentException
     * @param \StructType\STOCK_LOCATION[] $sTOCK_LOCATION
     * @return \StructType\StockLocationsType
     */
    public function setSTOCK_LOCATION(array $sTOCK_LOCATION = array())
    {
        // validation for constraint: array
        if ('' !== ($sTOCK_LOCATIONArrayErrorMessage = self::validateSTOCK_LOCATIONForArrayConstraintsFromSetSTOCK_LOCATION($sTOCK_LOCATION))) {
            throw new \InvalidArgumentException($sTOCK_LOCATIONArrayErrorMessage, __LINE__);
        }
        $this->STOCK_LOCATION = $sTOCK_LOCATION;
        return $this;
    }
    /**
     * Add item to STOCK_LOCATION value
     * @throws \InvalidArgumentException
     * @param \StructType\STOCK_LOCATION $item
     * @return \StructType\StockLocationsType
     */
    public function addToSTOCK_LOCATION(\StructType\STOCK_LOCATION $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\STOCK_LOCATION) {
            throw new \InvalidArgumentException(sprintf('The STOCK_LOCATION property can only contain items of type \StructType\STOCK_LOCATION, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->STOCK_LOCATION[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockLocationsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
