<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockContainerType StructType
 * @subpackage Structs
 */
class StockContainerType extends AbstractStructBase
{
    /**
     * The STOCK
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\STOCK[]
     */
    public $STOCK;
    /**
     * Constructor method for StockContainerType
     * @uses StockContainerType::setSTOCK()
     * @param \StructType\STOCK[] $sTOCK
     */
    public function __construct(array $sTOCK = array())
    {
        $this
            ->setSTOCK($sTOCK);
    }
    /**
     * Get STOCK value
     * @return \StructType\STOCK[]|null
     */
    public function getSTOCK()
    {
        return $this->STOCK;
    }
    /**
     * This method is responsible for validating the values passed to the setSTOCK method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSTOCK method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSTOCKForArrayConstraintsFromSetSTOCK(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stockContainerTypeSTOCKItem) {
            // validation for constraint: itemType
            if (!$stockContainerTypeSTOCKItem instanceof \StructType\STOCK) {
                $invalidValues[] = is_object($stockContainerTypeSTOCKItem) ? get_class($stockContainerTypeSTOCKItem) : sprintf('%s(%s)', gettype($stockContainerTypeSTOCKItem), var_export($stockContainerTypeSTOCKItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The STOCK property can only contain items of type \StructType\STOCK, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set STOCK value
     * @throws \InvalidArgumentException
     * @param \StructType\STOCK[] $sTOCK
     * @return \StructType\StockContainerType
     */
    public function setSTOCK(array $sTOCK = array())
    {
        // validation for constraint: array
        if ('' !== ($sTOCKArrayErrorMessage = self::validateSTOCKForArrayConstraintsFromSetSTOCK($sTOCK))) {
            throw new \InvalidArgumentException($sTOCKArrayErrorMessage, __LINE__);
        }
        $this->STOCK = $sTOCK;
        return $this;
    }
    /**
     * Add item to STOCK value
     * @throws \InvalidArgumentException
     * @param \StructType\STOCK $item
     * @return \StructType\StockContainerType
     */
    public function addToSTOCK(\StructType\STOCK $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\STOCK) {
            throw new \InvalidArgumentException(sprintf('The STOCK property can only contain items of type \StructType\STOCK, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->STOCK[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockContainerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
