<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SortOrderProductContainerType StructType
 * @subpackage Structs
 */
class SortOrderProductContainerType extends AbstractStructBase
{
    /**
     * The REFERENCE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $REFERENCE;
    /**
     * The SORT_VALUE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SORT_VALUE;
    /**
     * Constructor method for SortOrderProductContainerType
     * @uses SortOrderProductContainerType::setREFERENCE()
     * @uses SortOrderProductContainerType::setSORT_VALUE()
     * @param string $rEFERENCE
     * @param int $sORT_VALUE
     */
    public function __construct($rEFERENCE = null, $sORT_VALUE = null)
    {
        $this
            ->setREFERENCE($rEFERENCE)
            ->setSORT_VALUE($sORT_VALUE);
    }
    /**
     * Get REFERENCE value
     * @return string
     */
    public function getREFERENCE()
    {
        return $this->REFERENCE;
    }
    /**
     * Set REFERENCE value
     * @param string $rEFERENCE
     * @return \StructType\SortOrderProductContainerType
     */
    public function setREFERENCE($rEFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($rEFERENCE) && !is_string($rEFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rEFERENCE, true), gettype($rEFERENCE)), __LINE__);
        }
        $this->REFERENCE = $rEFERENCE;
        return $this;
    }
    /**
     * Get SORT_VALUE value
     * @return int
     */
    public function getSORT_VALUE()
    {
        return $this->SORT_VALUE;
    }
    /**
     * Set SORT_VALUE value
     * @param int $sORT_VALUE
     * @return \StructType\SortOrderProductContainerType
     */
    public function setSORT_VALUE($sORT_VALUE = null)
    {
        // validation for constraint: int
        if (!is_null($sORT_VALUE) && !(is_int($sORT_VALUE) || ctype_digit($sORT_VALUE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sORT_VALUE, true), gettype($sORT_VALUE)), __LINE__);
        }
        $this->SORT_VALUE = $sORT_VALUE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SortOrderProductContainerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
