<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetStockMultipleType StructType
 * @subpackage Structs
 */
class SetStockMultipleType extends AbstractStructBase
{
    /**
     * The stock_level
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Stock_level[]
     */
    public $stock_level;
    /**
     * Constructor method for SetStockMultipleType
     * @uses SetStockMultipleType::setStock_level()
     * @param \StructType\Stock_level[] $stock_level
     */
    public function __construct(array $stock_level = array())
    {
        $this
            ->setStock_level($stock_level);
    }
    /**
     * Get stock_level value
     * @return \StructType\Stock_level[]
     */
    public function getStock_level()
    {
        return $this->stock_level;
    }
    /**
     * This method is responsible for validating the values passed to the setStock_level method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStock_level method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStock_levelForArrayConstraintsFromSetStock_level(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $setStockMultipleTypeStock_levelItem) {
            // validation for constraint: itemType
            if (!$setStockMultipleTypeStock_levelItem instanceof \StructType\Stock_level) {
                $invalidValues[] = is_object($setStockMultipleTypeStock_levelItem) ? get_class($setStockMultipleTypeStock_levelItem) : sprintf('%s(%s)', gettype($setStockMultipleTypeStock_levelItem), var_export($setStockMultipleTypeStock_levelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The stock_level property can only contain items of type \StructType\Stock_level, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set stock_level value
     * @throws \InvalidArgumentException
     * @param \StructType\Stock_level[] $stock_level
     * @return \StructType\SetStockMultipleType
     */
    public function setStock_level(array $stock_level = array())
    {
        // validation for constraint: array
        if ('' !== ($stock_levelArrayErrorMessage = self::validateStock_levelForArrayConstraintsFromSetStock_level($stock_level))) {
            throw new \InvalidArgumentException($stock_levelArrayErrorMessage, __LINE__);
        }
        $this->stock_level = $stock_level;
        return $this;
    }
    /**
     * Add item to stock_level value
     * @throws \InvalidArgumentException
     * @param \StructType\Stock_level $item
     * @return \StructType\SetStockMultipleType
     */
    public function addToStock_level(\StructType\Stock_level $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Stock_level) {
            throw new \InvalidArgumentException(sprintf('The stock_level property can only contain items of type \StructType\Stock_level, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->stock_level[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetStockMultipleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
