<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for STOCK StructType
 * @subpackage Structs
 */
class STOCK extends AbstractStructBase
{
    /**
     * The STOCK_LEVEL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $STOCK_LEVEL;
    /**
     * The OLD_STOCK_LEVEL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OLD_STOCK_LEVEL;
    /**
     * The NEW_STOCK_LEVEL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NEW_STOCK_LEVEL;
    /**
     * The LAST_MODIFIED
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $LAST_MODIFIED;
    /**
     * The REFERENCE
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $REFERENCE;
    /**
     * Constructor method for STOCK
     * @uses STOCK::setSTOCK_LEVEL()
     * @uses STOCK::setOLD_STOCK_LEVEL()
     * @uses STOCK::setNEW_STOCK_LEVEL()
     * @uses STOCK::setLAST_MODIFIED()
     * @uses STOCK::setREFERENCE()
     * @param int $sTOCK_LEVEL
     * @param int $oLD_STOCK_LEVEL
     * @param int $nEW_STOCK_LEVEL
     * @param string $lAST_MODIFIED
     * @param string $rEFERENCE
     */
    public function __construct($sTOCK_LEVEL = null, $oLD_STOCK_LEVEL = null, $nEW_STOCK_LEVEL = null, $lAST_MODIFIED = null, $rEFERENCE = null)
    {
        $this
            ->setSTOCK_LEVEL($sTOCK_LEVEL)
            ->setOLD_STOCK_LEVEL($oLD_STOCK_LEVEL)
            ->setNEW_STOCK_LEVEL($nEW_STOCK_LEVEL)
            ->setLAST_MODIFIED($lAST_MODIFIED)
            ->setREFERENCE($rEFERENCE);
    }
    /**
     * Get STOCK_LEVEL value
     * @return int|null
     */
    public function getSTOCK_LEVEL()
    {
        return $this->STOCK_LEVEL;
    }
    /**
     * Set STOCK_LEVEL value
     * @param int $sTOCK_LEVEL
     * @return \StructType\STOCK
     */
    public function setSTOCK_LEVEL($sTOCK_LEVEL = null)
    {
        // validation for constraint: int
        if (!is_null($sTOCK_LEVEL) && !(is_int($sTOCK_LEVEL) || ctype_digit($sTOCK_LEVEL))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sTOCK_LEVEL, true), gettype($sTOCK_LEVEL)), __LINE__);
        }
        $this->STOCK_LEVEL = $sTOCK_LEVEL;
        return $this;
    }
    /**
     * Get OLD_STOCK_LEVEL value
     * @return int|null
     */
    public function getOLD_STOCK_LEVEL()
    {
        return $this->OLD_STOCK_LEVEL;
    }
    /**
     * Set OLD_STOCK_LEVEL value
     * @param int $oLD_STOCK_LEVEL
     * @return \StructType\STOCK
     */
    public function setOLD_STOCK_LEVEL($oLD_STOCK_LEVEL = null)
    {
        // validation for constraint: int
        if (!is_null($oLD_STOCK_LEVEL) && !(is_int($oLD_STOCK_LEVEL) || ctype_digit($oLD_STOCK_LEVEL))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oLD_STOCK_LEVEL, true), gettype($oLD_STOCK_LEVEL)), __LINE__);
        }
        $this->OLD_STOCK_LEVEL = $oLD_STOCK_LEVEL;
        return $this;
    }
    /**
     * Get NEW_STOCK_LEVEL value
     * @return int|null
     */
    public function getNEW_STOCK_LEVEL()
    {
        return $this->NEW_STOCK_LEVEL;
    }
    /**
     * Set NEW_STOCK_LEVEL value
     * @param int $nEW_STOCK_LEVEL
     * @return \StructType\STOCK
     */
    public function setNEW_STOCK_LEVEL($nEW_STOCK_LEVEL = null)
    {
        // validation for constraint: int
        if (!is_null($nEW_STOCK_LEVEL) && !(is_int($nEW_STOCK_LEVEL) || ctype_digit($nEW_STOCK_LEVEL))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nEW_STOCK_LEVEL, true), gettype($nEW_STOCK_LEVEL)), __LINE__);
        }
        $this->NEW_STOCK_LEVEL = $nEW_STOCK_LEVEL;
        return $this;
    }
    /**
     * Get LAST_MODIFIED value
     * @return string|null
     */
    public function getLAST_MODIFIED()
    {
        return $this->LAST_MODIFIED;
    }
    /**
     * Set LAST_MODIFIED value
     * @param string $lAST_MODIFIED
     * @return \StructType\STOCK
     */
    public function setLAST_MODIFIED($lAST_MODIFIED = null)
    {
        // validation for constraint: string
        if (!is_null($lAST_MODIFIED) && !is_string($lAST_MODIFIED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lAST_MODIFIED, true), gettype($lAST_MODIFIED)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lAST_MODIFIED) && mb_strlen($lAST_MODIFIED) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lAST_MODIFIED)), __LINE__);
        }
        $this->LAST_MODIFIED = $lAST_MODIFIED;
        return $this;
    }
    /**
     * Get REFERENCE value
     * @return string|null
     */
    public function getREFERENCE()
    {
        return $this->REFERENCE;
    }
    /**
     * Set REFERENCE value
     * @param string $rEFERENCE
     * @return \StructType\STOCK
     */
    public function setREFERENCE($rEFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($rEFERENCE) && !is_string($rEFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rEFERENCE, true), gettype($rEFERENCE)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($rEFERENCE) && mb_strlen($rEFERENCE) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($rEFERENCE)), __LINE__);
        }
        $this->REFERENCE = $rEFERENCE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\STOCK
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
