<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Result StructType
 * @subpackage Structs
 */
class Result extends AbstractStructBase
{
    /**
     * The WEB_ORDERS
     * Meta information extracted from the WSDL
     * - choice: WEB_ORDERS | PRODUCTS | STOCK | CUSTOMERS | SORT_ORDERS | Success
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var \StructType\WebOrdersContainerType
     */
    public $WEB_ORDERS;
    /**
     * The PRODUCTS
     * Meta information extracted from the WSDL
     * - choice: WEB_ORDERS | PRODUCTS | STOCK | CUSTOMERS | SORT_ORDERS | Success
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var \StructType\ProductContainerType
     */
    public $PRODUCTS;
    /**
     * The STOCK
     * Meta information extracted from the WSDL
     * - choice: WEB_ORDERS | PRODUCTS | STOCK | CUSTOMERS | SORT_ORDERS | Success
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var \StructType\StockContainerType
     */
    public $STOCK;
    /**
     * The CUSTOMERS
     * Meta information extracted from the WSDL
     * - choice: WEB_ORDERS | PRODUCTS | STOCK | CUSTOMERS | SORT_ORDERS | Success
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var \StructType\CustomersContainerType
     */
    public $CUSTOMERS;
    /**
     * The SORT_ORDERS
     * Meta information extracted from the WSDL
     * - choice: WEB_ORDERS | PRODUCTS | STOCK | CUSTOMERS | SORT_ORDERS | Success
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var \StructType\SortOrdersContainerType
     */
    public $SORT_ORDERS;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - choice: WEB_ORDERS | PRODUCTS | STOCK | CUSTOMERS | SORT_ORDERS | Success
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var bool
     */
    public $Success;
    /**
     * Constructor method for Result
     * @uses Result::setWEB_ORDERS()
     * @uses Result::setPRODUCTS()
     * @uses Result::setSTOCK()
     * @uses Result::setCUSTOMERS()
     * @uses Result::setSORT_ORDERS()
     * @uses Result::setSuccess()
     * @param \StructType\WebOrdersContainerType $wEB_ORDERS
     * @param \StructType\ProductContainerType $pRODUCTS
     * @param \StructType\StockContainerType $sTOCK
     * @param \StructType\CustomersContainerType $cUSTOMERS
     * @param \StructType\SortOrdersContainerType $sORT_ORDERS
     * @param bool $success
     */
    public function __construct(\StructType\WebOrdersContainerType $wEB_ORDERS = null, \StructType\ProductContainerType $pRODUCTS = null, \StructType\StockContainerType $sTOCK = null, \StructType\CustomersContainerType $cUSTOMERS = null, \StructType\SortOrdersContainerType $sORT_ORDERS = null, $success = null)
    {
        $this
            ->setWEB_ORDERS($wEB_ORDERS)
            ->setPRODUCTS($pRODUCTS)
            ->setSTOCK($sTOCK)
            ->setCUSTOMERS($cUSTOMERS)
            ->setSORT_ORDERS($sORT_ORDERS)
            ->setSuccess($success);
    }
    /**
     * Get WEB_ORDERS value
     * @return \StructType\WebOrdersContainerType|null
     */
    public function getWEB_ORDERS()
    {
        return isset($this->WEB_ORDERS) ? $this->WEB_ORDERS : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWEB_ORDERS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWEB_ORDERS method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWEB_ORDERSForChoiceConstraintsFromSetWEB_ORDERS($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PRODUCTS',
            'STOCK',
            'CUSTOMERS',
            'SORT_ORDERS',
            'Success',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property WEB_ORDERS can\'t be set as the property %s is already set. Only one property must be set among these properties: WEB_ORDERS, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set WEB_ORDERS value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WebOrdersContainerType $wEB_ORDERS
     * @return \StructType\Result
     */
    public function setWEB_ORDERS(\StructType\WebOrdersContainerType $wEB_ORDERS = null)
    {
        // validation for constraint: choice(WEB_ORDERS, PRODUCTS, STOCK, CUSTOMERS, SORT_ORDERS, Success)
        if ('' !== ($wEB_ORDERSChoiceErrorMessage = self::validateWEB_ORDERSForChoiceConstraintsFromSetWEB_ORDERS($wEB_ORDERS))) {
            throw new \InvalidArgumentException($wEB_ORDERSChoiceErrorMessage, __LINE__);
        }
        if (is_null($wEB_ORDERS) || (is_array($wEB_ORDERS) && empty($wEB_ORDERS))) {
            unset($this->WEB_ORDERS);
        } else {
            $this->WEB_ORDERS = $wEB_ORDERS;
        }
        return $this;
    }
    /**
     * Get PRODUCTS value
     * @return \StructType\ProductContainerType|null
     */
    public function getPRODUCTS()
    {
        return isset($this->PRODUCTS) ? $this->PRODUCTS : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPRODUCTS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPRODUCTS method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePRODUCTSForChoiceConstraintsFromSetPRODUCTS($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'WEB_ORDERS',
            'STOCK',
            'CUSTOMERS',
            'SORT_ORDERS',
            'Success',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PRODUCTS can\'t be set as the property %s is already set. Only one property must be set among these properties: PRODUCTS, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PRODUCTS value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductContainerType $pRODUCTS
     * @return \StructType\Result
     */
    public function setPRODUCTS(\StructType\ProductContainerType $pRODUCTS = null)
    {
        // validation for constraint: choice(WEB_ORDERS, PRODUCTS, STOCK, CUSTOMERS, SORT_ORDERS, Success)
        if ('' !== ($pRODUCTSChoiceErrorMessage = self::validatePRODUCTSForChoiceConstraintsFromSetPRODUCTS($pRODUCTS))) {
            throw new \InvalidArgumentException($pRODUCTSChoiceErrorMessage, __LINE__);
        }
        if (is_null($pRODUCTS) || (is_array($pRODUCTS) && empty($pRODUCTS))) {
            unset($this->PRODUCTS);
        } else {
            $this->PRODUCTS = $pRODUCTS;
        }
        return $this;
    }
    /**
     * Get STOCK value
     * @return \StructType\StockContainerType|null
     */
    public function getSTOCK()
    {
        return isset($this->STOCK) ? $this->STOCK : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSTOCK method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSTOCK method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSTOCKForChoiceConstraintsFromSetSTOCK($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'WEB_ORDERS',
            'PRODUCTS',
            'CUSTOMERS',
            'SORT_ORDERS',
            'Success',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property STOCK can\'t be set as the property %s is already set. Only one property must be set among these properties: STOCK, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set STOCK value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StockContainerType $sTOCK
     * @return \StructType\Result
     */
    public function setSTOCK(\StructType\StockContainerType $sTOCK = null)
    {
        // validation for constraint: choice(WEB_ORDERS, PRODUCTS, STOCK, CUSTOMERS, SORT_ORDERS, Success)
        if ('' !== ($sTOCKChoiceErrorMessage = self::validateSTOCKForChoiceConstraintsFromSetSTOCK($sTOCK))) {
            throw new \InvalidArgumentException($sTOCKChoiceErrorMessage, __LINE__);
        }
        if (is_null($sTOCK) || (is_array($sTOCK) && empty($sTOCK))) {
            unset($this->STOCK);
        } else {
            $this->STOCK = $sTOCK;
        }
        return $this;
    }
    /**
     * Get CUSTOMERS value
     * @return \StructType\CustomersContainerType|null
     */
    public function getCUSTOMERS()
    {
        return isset($this->CUSTOMERS) ? $this->CUSTOMERS : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCUSTOMERS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCUSTOMERS method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCUSTOMERSForChoiceConstraintsFromSetCUSTOMERS($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'WEB_ORDERS',
            'PRODUCTS',
            'STOCK',
            'SORT_ORDERS',
            'Success',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CUSTOMERS can\'t be set as the property %s is already set. Only one property must be set among these properties: CUSTOMERS, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CUSTOMERS value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomersContainerType $cUSTOMERS
     * @return \StructType\Result
     */
    public function setCUSTOMERS(\StructType\CustomersContainerType $cUSTOMERS = null)
    {
        // validation for constraint: choice(WEB_ORDERS, PRODUCTS, STOCK, CUSTOMERS, SORT_ORDERS, Success)
        if ('' !== ($cUSTOMERSChoiceErrorMessage = self::validateCUSTOMERSForChoiceConstraintsFromSetCUSTOMERS($cUSTOMERS))) {
            throw new \InvalidArgumentException($cUSTOMERSChoiceErrorMessage, __LINE__);
        }
        if (is_null($cUSTOMERS) || (is_array($cUSTOMERS) && empty($cUSTOMERS))) {
            unset($this->CUSTOMERS);
        } else {
            $this->CUSTOMERS = $cUSTOMERS;
        }
        return $this;
    }
    /**
     * Get SORT_ORDERS value
     * @return \StructType\SortOrdersContainerType|null
     */
    public function getSORT_ORDERS()
    {
        return isset($this->SORT_ORDERS) ? $this->SORT_ORDERS : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSORT_ORDERS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSORT_ORDERS method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSORT_ORDERSForChoiceConstraintsFromSetSORT_ORDERS($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'WEB_ORDERS',
            'PRODUCTS',
            'STOCK',
            'CUSTOMERS',
            'Success',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SORT_ORDERS can\'t be set as the property %s is already set. Only one property must be set among these properties: SORT_ORDERS, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SORT_ORDERS value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SortOrdersContainerType $sORT_ORDERS
     * @return \StructType\Result
     */
    public function setSORT_ORDERS(\StructType\SortOrdersContainerType $sORT_ORDERS = null)
    {
        // validation for constraint: choice(WEB_ORDERS, PRODUCTS, STOCK, CUSTOMERS, SORT_ORDERS, Success)
        if ('' !== ($sORT_ORDERSChoiceErrorMessage = self::validateSORT_ORDERSForChoiceConstraintsFromSetSORT_ORDERS($sORT_ORDERS))) {
            throw new \InvalidArgumentException($sORT_ORDERSChoiceErrorMessage, __LINE__);
        }
        if (is_null($sORT_ORDERS) || (is_array($sORT_ORDERS) && empty($sORT_ORDERS))) {
            unset($this->SORT_ORDERS);
        } else {
            $this->SORT_ORDERS = $sORT_ORDERS;
        }
        return $this;
    }
    /**
     * Get Success value
     * @return bool|null
     */
    public function getSuccess()
    {
        return isset($this->Success) ? $this->Success : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSuccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSuccess method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSuccessForChoiceConstraintsFromSetSuccess($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'WEB_ORDERS',
            'PRODUCTS',
            'STOCK',
            'CUSTOMERS',
            'SORT_ORDERS',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Success can\'t be set as the property %s is already set. Only one property must be set among these properties: Success, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Success value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $success
     * @return \StructType\Result
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        // validation for constraint: choice(WEB_ORDERS, PRODUCTS, STOCK, CUSTOMERS, SORT_ORDERS, Success)
        if ('' !== ($successChoiceErrorMessage = self::validateSuccessForChoiceConstraintsFromSetSuccess($success))) {
            throw new \InvalidArgumentException($successChoiceErrorMessage, __LINE__);
        }
        if (is_null($success) || (is_array($success) && empty($success))) {
            unset($this->Success);
        } else {
            $this->Success = $success;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Result
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
