<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentType StructType
 * @subpackage Structs
 */
class PaymentType extends AbstractStructBase
{
    /**
     * The PAYMENT_AMOUNT
     * @var float
     */
    public $PAYMENT_AMOUNT;
    /**
     * The PAYMENT_DATE
     * @var string
     */
    public $PAYMENT_DATE;
    /**
     * The PAYMENT_TYPE
     * @var string
     */
    public $PAYMENT_TYPE;
    /**
     * The CARD_HOLDER
     * @var string
     */
    public $CARD_HOLDER;
    /**
     * The VENDOR_TX_CODE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VENDOR_TX_CODE;
    /**
     * The AUTH_CODE
     * @var string
     */
    public $AUTH_CODE;
    /**
     * The SECURITY_REFERENCE
     * @var string
     */
    public $SECURITY_REFERENCE;
    /**
     * The TRANSACTION_REFERENCE
     * @var string
     */
    public $TRANSACTION_REFERENCE;
    /**
     * The CV2_AVS
     * @var string
     */
    public $CV2_AVS;
    /**
     * The NOTES
     * @var string
     */
    public $NOTES;
    /**
     * Constructor method for PaymentType
     * @uses PaymentType::setPAYMENT_AMOUNT()
     * @uses PaymentType::setPAYMENT_DATE()
     * @uses PaymentType::setPAYMENT_TYPE()
     * @uses PaymentType::setCARD_HOLDER()
     * @uses PaymentType::setVENDOR_TX_CODE()
     * @uses PaymentType::setAUTH_CODE()
     * @uses PaymentType::setSECURITY_REFERENCE()
     * @uses PaymentType::setTRANSACTION_REFERENCE()
     * @uses PaymentType::setCV2_AVS()
     * @uses PaymentType::setNOTES()
     * @param float $pAYMENT_AMOUNT
     * @param string $pAYMENT_DATE
     * @param string $pAYMENT_TYPE
     * @param string $cARD_HOLDER
     * @param string $vENDOR_TX_CODE
     * @param string $aUTH_CODE
     * @param string $sECURITY_REFERENCE
     * @param string $tRANSACTION_REFERENCE
     * @param string $cV2_AVS
     * @param string $nOTES
     */
    public function __construct($pAYMENT_AMOUNT = null, $pAYMENT_DATE = null, $pAYMENT_TYPE = null, $cARD_HOLDER = null, $vENDOR_TX_CODE = null, $aUTH_CODE = null, $sECURITY_REFERENCE = null, $tRANSACTION_REFERENCE = null, $cV2_AVS = null, $nOTES = null)
    {
        $this
            ->setPAYMENT_AMOUNT($pAYMENT_AMOUNT)
            ->setPAYMENT_DATE($pAYMENT_DATE)
            ->setPAYMENT_TYPE($pAYMENT_TYPE)
            ->setCARD_HOLDER($cARD_HOLDER)
            ->setVENDOR_TX_CODE($vENDOR_TX_CODE)
            ->setAUTH_CODE($aUTH_CODE)
            ->setSECURITY_REFERENCE($sECURITY_REFERENCE)
            ->setTRANSACTION_REFERENCE($tRANSACTION_REFERENCE)
            ->setCV2_AVS($cV2_AVS)
            ->setNOTES($nOTES);
    }
    /**
     * Get PAYMENT_AMOUNT value
     * @return float|null
     */
    public function getPAYMENT_AMOUNT()
    {
        return $this->PAYMENT_AMOUNT;
    }
    /**
     * Set PAYMENT_AMOUNT value
     * @param float $pAYMENT_AMOUNT
     * @return \StructType\PaymentType
     */
    public function setPAYMENT_AMOUNT($pAYMENT_AMOUNT = null)
    {
        // validation for constraint: float
        if (!is_null($pAYMENT_AMOUNT) && !(is_float($pAYMENT_AMOUNT) || is_numeric($pAYMENT_AMOUNT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pAYMENT_AMOUNT, true), gettype($pAYMENT_AMOUNT)), __LINE__);
        }
        $this->PAYMENT_AMOUNT = $pAYMENT_AMOUNT;
        return $this;
    }
    /**
     * Get PAYMENT_DATE value
     * @return string|null
     */
    public function getPAYMENT_DATE()
    {
        return $this->PAYMENT_DATE;
    }
    /**
     * Set PAYMENT_DATE value
     * @param string $pAYMENT_DATE
     * @return \StructType\PaymentType
     */
    public function setPAYMENT_DATE($pAYMENT_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($pAYMENT_DATE) && !is_string($pAYMENT_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pAYMENT_DATE, true), gettype($pAYMENT_DATE)), __LINE__);
        }
        $this->PAYMENT_DATE = $pAYMENT_DATE;
        return $this;
    }
    /**
     * Get PAYMENT_TYPE value
     * @return string|null
     */
    public function getPAYMENT_TYPE()
    {
        return $this->PAYMENT_TYPE;
    }
    /**
     * Set PAYMENT_TYPE value
     * @param string $pAYMENT_TYPE
     * @return \StructType\PaymentType
     */
    public function setPAYMENT_TYPE($pAYMENT_TYPE = null)
    {
        // validation for constraint: string
        if (!is_null($pAYMENT_TYPE) && !is_string($pAYMENT_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pAYMENT_TYPE, true), gettype($pAYMENT_TYPE)), __LINE__);
        }
        $this->PAYMENT_TYPE = $pAYMENT_TYPE;
        return $this;
    }
    /**
     * Get CARD_HOLDER value
     * @return string|null
     */
    public function getCARD_HOLDER()
    {
        return $this->CARD_HOLDER;
    }
    /**
     * Set CARD_HOLDER value
     * @param string $cARD_HOLDER
     * @return \StructType\PaymentType
     */
    public function setCARD_HOLDER($cARD_HOLDER = null)
    {
        // validation for constraint: string
        if (!is_null($cARD_HOLDER) && !is_string($cARD_HOLDER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cARD_HOLDER, true), gettype($cARD_HOLDER)), __LINE__);
        }
        $this->CARD_HOLDER = $cARD_HOLDER;
        return $this;
    }
    /**
     * Get VENDOR_TX_CODE value
     * @return string|null
     */
    public function getVENDOR_TX_CODE()
    {
        return $this->VENDOR_TX_CODE;
    }
    /**
     * Set VENDOR_TX_CODE value
     * @param string $vENDOR_TX_CODE
     * @return \StructType\PaymentType
     */
    public function setVENDOR_TX_CODE($vENDOR_TX_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($vENDOR_TX_CODE) && !is_string($vENDOR_TX_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vENDOR_TX_CODE, true), gettype($vENDOR_TX_CODE)), __LINE__);
        }
        $this->VENDOR_TX_CODE = $vENDOR_TX_CODE;
        return $this;
    }
    /**
     * Get AUTH_CODE value
     * @return string|null
     */
    public function getAUTH_CODE()
    {
        return $this->AUTH_CODE;
    }
    /**
     * Set AUTH_CODE value
     * @param string $aUTH_CODE
     * @return \StructType\PaymentType
     */
    public function setAUTH_CODE($aUTH_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($aUTH_CODE) && !is_string($aUTH_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aUTH_CODE, true), gettype($aUTH_CODE)), __LINE__);
        }
        $this->AUTH_CODE = $aUTH_CODE;
        return $this;
    }
    /**
     * Get SECURITY_REFERENCE value
     * @return string|null
     */
    public function getSECURITY_REFERENCE()
    {
        return $this->SECURITY_REFERENCE;
    }
    /**
     * Set SECURITY_REFERENCE value
     * @param string $sECURITY_REFERENCE
     * @return \StructType\PaymentType
     */
    public function setSECURITY_REFERENCE($sECURITY_REFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($sECURITY_REFERENCE) && !is_string($sECURITY_REFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sECURITY_REFERENCE, true), gettype($sECURITY_REFERENCE)), __LINE__);
        }
        $this->SECURITY_REFERENCE = $sECURITY_REFERENCE;
        return $this;
    }
    /**
     * Get TRANSACTION_REFERENCE value
     * @return string|null
     */
    public function getTRANSACTION_REFERENCE()
    {
        return $this->TRANSACTION_REFERENCE;
    }
    /**
     * Set TRANSACTION_REFERENCE value
     * @param string $tRANSACTION_REFERENCE
     * @return \StructType\PaymentType
     */
    public function setTRANSACTION_REFERENCE($tRANSACTION_REFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($tRANSACTION_REFERENCE) && !is_string($tRANSACTION_REFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tRANSACTION_REFERENCE, true), gettype($tRANSACTION_REFERENCE)), __LINE__);
        }
        $this->TRANSACTION_REFERENCE = $tRANSACTION_REFERENCE;
        return $this;
    }
    /**
     * Get CV2_AVS value
     * @return string|null
     */
    public function getCV2_AVS()
    {
        return $this->CV2_AVS;
    }
    /**
     * Set CV2_AVS value
     * @param string $cV2_AVS
     * @return \StructType\PaymentType
     */
    public function setCV2_AVS($cV2_AVS = null)
    {
        // validation for constraint: string
        if (!is_null($cV2_AVS) && !is_string($cV2_AVS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cV2_AVS, true), gettype($cV2_AVS)), __LINE__);
        }
        $this->CV2_AVS = $cV2_AVS;
        return $this;
    }
    /**
     * Get NOTES value
     * @return string|null
     */
    public function getNOTES()
    {
        return $this->NOTES;
    }
    /**
     * Set NOTES value
     * @param string $nOTES
     * @return \StructType\PaymentType
     */
    public function setNOTES($nOTES = null)
    {
        // validation for constraint: string
        if (!is_null($nOTES) && !is_string($nOTES)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nOTES, true), gettype($nOTES)), __LINE__);
        }
        $this->NOTES = $nOTES;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
