<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderIds StructType
 * @subpackage Structs
 */
class OrderIds extends AbstractStructBase
{
    /**
     * The order_id
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var int[]
     */
    public $order_id;
    /**
     * Constructor method for OrderIds
     * @uses OrderIds::setOrder_id()
     * @param int[] $order_id
     */
    public function __construct(array $order_id = array())
    {
        $this
            ->setOrder_id($order_id);
    }
    /**
     * Get order_id value
     * @return int[]|null
     */
    public function getOrder_id()
    {
        return $this->order_id;
    }
    /**
     * This method is responsible for validating the values passed to the setOrder_id method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder_id method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrder_idForArrayConstraintsFromSetOrder_id(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderIdsOrder_idItem) {
            // validation for constraint: itemType
            if (!(is_int($orderIdsOrder_idItem) || ctype_digit($orderIdsOrder_idItem))) {
                $invalidValues[] = is_object($orderIdsOrder_idItem) ? get_class($orderIdsOrder_idItem) : sprintf('%s(%s)', gettype($orderIdsOrder_idItem), var_export($orderIdsOrder_idItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The order_id property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set order_id value
     * @throws \InvalidArgumentException
     * @param int[] $order_id
     * @return \StructType\OrderIds
     */
    public function setOrder_id(array $order_id = array())
    {
        // validation for constraint: array
        if ('' !== ($order_idArrayErrorMessage = self::validateOrder_idForArrayConstraintsFromSetOrder_id($order_id))) {
            throw new \InvalidArgumentException($order_idArrayErrorMessage, __LINE__);
        }
        $this->order_id = $order_id;
        return $this;
    }
    /**
     * Add item to order_id value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\OrderIds
     */
    public function addToOrder_id($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The order_id property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->order_id[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderIds
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
