<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderFraudUpdateType StructType
 * @subpackage Structs
 */
class OrderFraudUpdateType extends AbstractStructBase
{
    /**
     * The ORDER_ID
     * Meta information extracted from the WSDL
     * - choice: ORDER_ID | ORDER_REF
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $ORDER_ID;
    /**
     * The ORDER_REF
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: ORDER_ID | ORDER_REF
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minLength: 1
     * @var string
     */
    public $ORDER_REF;
    /**
     * The FRAUD_STATUS
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: FRAUD_STATUS | FRAUD_STATE_ID
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minLength: 1
     * @var string
     */
    public $FRAUD_STATUS;
    /**
     * The FRAUD_STATE_ID
     * Meta information extracted from the WSDL
     * - choice: FRAUD_STATUS | FRAUD_STATE_ID
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $FRAUD_STATE_ID;
    /**
     * The FRAUD_NOTES
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $FRAUD_NOTES;
    /**
     * Constructor method for OrderFraudUpdateType
     * @uses OrderFraudUpdateType::setORDER_ID()
     * @uses OrderFraudUpdateType::setORDER_REF()
     * @uses OrderFraudUpdateType::setFRAUD_STATUS()
     * @uses OrderFraudUpdateType::setFRAUD_STATE_ID()
     * @uses OrderFraudUpdateType::setFRAUD_NOTES()
     * @param int $oRDER_ID
     * @param string $oRDER_REF
     * @param string $fRAUD_STATUS
     * @param int $fRAUD_STATE_ID
     * @param mixed $fRAUD_NOTES
     */
    public function __construct($oRDER_ID = null, $oRDER_REF = null, $fRAUD_STATUS = null, $fRAUD_STATE_ID = null, $fRAUD_NOTES = null)
    {
        $this
            ->setORDER_ID($oRDER_ID)
            ->setORDER_REF($oRDER_REF)
            ->setFRAUD_STATUS($fRAUD_STATUS)
            ->setFRAUD_STATE_ID($fRAUD_STATE_ID)
            ->setFRAUD_NOTES($fRAUD_NOTES);
    }
    /**
     * Get ORDER_ID value
     * @return int|null
     */
    public function getORDER_ID()
    {
        return isset($this->ORDER_ID) ? $this->ORDER_ID : null;
    }
    /**
     * This method is responsible for validating the value passed to the setORDER_ID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setORDER_ID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateORDER_IDForChoiceConstraintsFromSetORDER_ID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ORDER_REF',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ORDER_ID can\'t be set as the property %s is already set. Only one property must be set among these properties: ORDER_ID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ORDER_ID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $oRDER_ID
     * @return \StructType\OrderFraudUpdateType
     */
    public function setORDER_ID($oRDER_ID = null)
    {
        // validation for constraint: int
        if (!is_null($oRDER_ID) && !(is_int($oRDER_ID) || ctype_digit($oRDER_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oRDER_ID, true), gettype($oRDER_ID)), __LINE__);
        }
        // validation for constraint: choice(ORDER_ID, ORDER_REF)
        if ('' !== ($oRDER_IDChoiceErrorMessage = self::validateORDER_IDForChoiceConstraintsFromSetORDER_ID($oRDER_ID))) {
            throw new \InvalidArgumentException($oRDER_IDChoiceErrorMessage, __LINE__);
        }
        if (is_null($oRDER_ID) || (is_array($oRDER_ID) && empty($oRDER_ID))) {
            unset($this->ORDER_ID);
        } else {
            $this->ORDER_ID = $oRDER_ID;
        }
        return $this;
    }
    /**
     * Get ORDER_REF value
     * @return string|null
     */
    public function getORDER_REF()
    {
        return isset($this->ORDER_REF) ? $this->ORDER_REF : null;
    }
    /**
     * This method is responsible for validating the value passed to the setORDER_REF method
     * This method is willingly generated in order to preserve the one-line inline validation within the setORDER_REF method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateORDER_REFForChoiceConstraintsFromSetORDER_REF($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ORDER_ID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ORDER_REF can\'t be set as the property %s is already set. Only one property must be set among these properties: ORDER_REF, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ORDER_REF value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $oRDER_REF
     * @return \StructType\OrderFraudUpdateType
     */
    public function setORDER_REF($oRDER_REF = null)
    {
        // validation for constraint: string
        if (!is_null($oRDER_REF) && !is_string($oRDER_REF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oRDER_REF, true), gettype($oRDER_REF)), __LINE__);
        }
        // validation for constraint: choice(ORDER_ID, ORDER_REF)
        if ('' !== ($oRDER_REFChoiceErrorMessage = self::validateORDER_REFForChoiceConstraintsFromSetORDER_REF($oRDER_REF))) {
            throw new \InvalidArgumentException($oRDER_REFChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($oRDER_REF) && mb_strlen($oRDER_REF) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($oRDER_REF)), __LINE__);
        }
        if (is_null($oRDER_REF) || (is_array($oRDER_REF) && empty($oRDER_REF))) {
            unset($this->ORDER_REF);
        } else {
            $this->ORDER_REF = $oRDER_REF;
        }
        return $this;
    }
    /**
     * Get FRAUD_STATUS value
     * @return string|null
     */
    public function getFRAUD_STATUS()
    {
        return isset($this->FRAUD_STATUS) ? $this->FRAUD_STATUS : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFRAUD_STATUS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFRAUD_STATUS method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFRAUD_STATUSForChoiceConstraintsFromSetFRAUD_STATUS($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'FRAUD_STATE_ID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property FRAUD_STATUS can\'t be set as the property %s is already set. Only one property must be set among these properties: FRAUD_STATUS, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set FRAUD_STATUS value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $fRAUD_STATUS
     * @return \StructType\OrderFraudUpdateType
     */
    public function setFRAUD_STATUS($fRAUD_STATUS = null)
    {
        // validation for constraint: string
        if (!is_null($fRAUD_STATUS) && !is_string($fRAUD_STATUS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fRAUD_STATUS, true), gettype($fRAUD_STATUS)), __LINE__);
        }
        // validation for constraint: choice(FRAUD_STATUS, FRAUD_STATE_ID)
        if ('' !== ($fRAUD_STATUSChoiceErrorMessage = self::validateFRAUD_STATUSForChoiceConstraintsFromSetFRAUD_STATUS($fRAUD_STATUS))) {
            throw new \InvalidArgumentException($fRAUD_STATUSChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($fRAUD_STATUS) && mb_strlen($fRAUD_STATUS) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($fRAUD_STATUS)), __LINE__);
        }
        if (is_null($fRAUD_STATUS) || (is_array($fRAUD_STATUS) && empty($fRAUD_STATUS))) {
            unset($this->FRAUD_STATUS);
        } else {
            $this->FRAUD_STATUS = $fRAUD_STATUS;
        }
        return $this;
    }
    /**
     * Get FRAUD_STATE_ID value
     * @return int|null
     */
    public function getFRAUD_STATE_ID()
    {
        return isset($this->FRAUD_STATE_ID) ? $this->FRAUD_STATE_ID : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFRAUD_STATE_ID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFRAUD_STATE_ID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFRAUD_STATE_IDForChoiceConstraintsFromSetFRAUD_STATE_ID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'FRAUD_STATUS',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property FRAUD_STATE_ID can\'t be set as the property %s is already set. Only one property must be set among these properties: FRAUD_STATE_ID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set FRAUD_STATE_ID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $fRAUD_STATE_ID
     * @return \StructType\OrderFraudUpdateType
     */
    public function setFRAUD_STATE_ID($fRAUD_STATE_ID = null)
    {
        // validation for constraint: int
        if (!is_null($fRAUD_STATE_ID) && !(is_int($fRAUD_STATE_ID) || ctype_digit($fRAUD_STATE_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fRAUD_STATE_ID, true), gettype($fRAUD_STATE_ID)), __LINE__);
        }
        // validation for constraint: choice(FRAUD_STATUS, FRAUD_STATE_ID)
        if ('' !== ($fRAUD_STATE_IDChoiceErrorMessage = self::validateFRAUD_STATE_IDForChoiceConstraintsFromSetFRAUD_STATE_ID($fRAUD_STATE_ID))) {
            throw new \InvalidArgumentException($fRAUD_STATE_IDChoiceErrorMessage, __LINE__);
        }
        if (is_null($fRAUD_STATE_ID) || (is_array($fRAUD_STATE_ID) && empty($fRAUD_STATE_ID))) {
            unset($this->FRAUD_STATE_ID);
        } else {
            $this->FRAUD_STATE_ID = $fRAUD_STATE_ID;
        }
        return $this;
    }
    /**
     * Get FRAUD_NOTES value
     * @return mixed|null
     */
    public function getFRAUD_NOTES()
    {
        return $this->FRAUD_NOTES;
    }
    /**
     * Set FRAUD_NOTES value
     * @param mixed $fRAUD_NOTES
     * @return \StructType\OrderFraudUpdateType
     */
    public function setFRAUD_NOTES($fRAUD_NOTES = null)
    {
        $this->FRAUD_NOTES = $fRAUD_NOTES;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderFraudUpdateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
