<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDetailsType StructType
 * @subpackage Structs
 */
class OrderDetailsType extends AbstractStructBase
{
    /**
     * The ORDER_ID
     * @var int
     */
    public $ORDER_ID;
    /**
     * The WEBSITE_ID
     * @var int
     */
    public $WEBSITE_ID;
    /**
     * The ORDER_REFERENCE
     * @var string
     */
    public $ORDER_REFERENCE;
    /**
     * The ORDER_STATUS_ID
     * @var int
     */
    public $ORDER_STATUS_ID;
    /**
     * The ORDER_STATUS
     * @var string
     */
    public $ORDER_STATUS;
    /**
     * The AMAZON_PRIME
     * @var string
     */
    public $AMAZON_PRIME;
    /**
     * The IS_SPLIT_PARENT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IS_SPLIT_PARENT;
    /**
     * The PARENT_ORDER_ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PARENT_ORDER_ID;
    /**
     * The ORDER_FRAUD_STATE_ID
     * @var int
     */
    public $ORDER_FRAUD_STATE_ID;
    /**
     * The ORDER_DATE
     * @var string
     */
    public $ORDER_DATE;
    /**
     * The UPDATED_DATE
     * @var string
     */
    public $UPDATED_DATE;
    /**
     * The DISPATCH_DATE
     * @var string
     */
    public $DISPATCH_DATE;
    /**
     * The DELIVERY_DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DELIVERY_DATE;
    /**
     * The ESTIMATED_DELIVERY_DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ESTIMATED_DELIVERY_DATE;
    /**
     * The DOWNLOADED
     * @var string
     */
    public $DOWNLOADED;
    /**
     * The DOWNLOADED_DATE
     * @var string
     */
    public $DOWNLOADED_DATE;
    /**
     * The PRODUCT_TOTAL_INC
     * @var float
     */
    public $PRODUCT_TOTAL_INC;
    /**
     * The PRODUCT_TOTAL_EX
     * @var float
     */
    public $PRODUCT_TOTAL_EX;
    /**
     * The PRODUCT_TOTAL_VAT
     * @var float
     */
    public $PRODUCT_TOTAL_VAT;
    /**
     * The SHIPPING_TOTAL_INC
     * @var float
     */
    public $SHIPPING_TOTAL_INC;
    /**
     * The SHIPPING_TOTAL_EX
     * @var float
     */
    public $SHIPPING_TOTAL_EX;
    /**
     * The SHIPPING_TOTAL_VAT
     * @var float
     */
    public $SHIPPING_TOTAL_VAT;
    /**
     * The DISCOUNT_TOTAL_INC
     * @var float
     */
    public $DISCOUNT_TOTAL_INC;
    /**
     * The DISCOUNT_TOTAL_EX
     * @var float
     */
    public $DISCOUNT_TOTAL_EX;
    /**
     * The DISCOUNT_TOTAL_VAT
     * @var float
     */
    public $DISCOUNT_TOTAL_VAT;
    /**
     * The GRAND_TOTAL_INC
     * @var float
     */
    public $GRAND_TOTAL_INC;
    /**
     * The GRAND_TOTAL_EX
     * @var float
     */
    public $GRAND_TOTAL_EX;
    /**
     * The GRAND_TOTAL_VAT
     * @var float
     */
    public $GRAND_TOTAL_VAT;
    /**
     * The ORDER_CURRENCY
     * @var string
     */
    public $ORDER_CURRENCY;
    /**
     * The ORDER_CUSTOMER_COMMENTS
     * @var string
     */
    public $ORDER_CUSTOMER_COMMENTS;
    /**
     * The ORDER_NOTES
     * @var string
     */
    public $ORDER_NOTES;
    /**
     * The ORDER_TYPE
     * @var string
     */
    public $ORDER_TYPE;
    /**
     * The DELIVERY_METHOD
     * @var string
     */
    public $DELIVERY_METHOD;
    /**
     * The GIFTWRAP_TOTAL_INC
     * @var float
     */
    public $GIFTWRAP_TOTAL_INC;
    /**
     * The GIFTWRAP_TOTAL_NET
     * @var float
     */
    public $GIFTWRAP_TOTAL_NET;
    /**
     * The GIFTWRAP_TOTAL_VAT
     * @var float
     */
    public $GIFTWRAP_TOTAL_VAT;
    /**
     * The NUMBER_PRODUCTS
     * @var int
     */
    public $NUMBER_PRODUCTS;
    /**
     * The MULTICHANNEL_SOURCE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MULTICHANNEL_SOURCE
     */
    public $MULTICHANNEL_SOURCE;
    /**
     * The COURIER_STOCK_SYSTEM_REFERENCE_CODE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $COURIER_STOCK_SYSTEM_REFERENCE_CODE;
    /**
     * The PO_NUMBER
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PO_NUMBER;
    /**
     * The CUSTOMER_DELIVERY_NOTES
     * @var string
     */
    public $CUSTOMER_DELIVERY_NOTES;
    /**
     * The BRANCH_INTERNAL_REFERENCE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BRANCH_INTERNAL_REFERENCE;
    /**
     * The TRACKING_INFO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TRACKING_INFO
     */
    public $TRACKING_INFO;
    /**
     * Constructor method for OrderDetailsType
     * @uses OrderDetailsType::setORDER_ID()
     * @uses OrderDetailsType::setWEBSITE_ID()
     * @uses OrderDetailsType::setORDER_REFERENCE()
     * @uses OrderDetailsType::setORDER_STATUS_ID()
     * @uses OrderDetailsType::setORDER_STATUS()
     * @uses OrderDetailsType::setAMAZON_PRIME()
     * @uses OrderDetailsType::setIS_SPLIT_PARENT()
     * @uses OrderDetailsType::setPARENT_ORDER_ID()
     * @uses OrderDetailsType::setORDER_FRAUD_STATE_ID()
     * @uses OrderDetailsType::setORDER_DATE()
     * @uses OrderDetailsType::setUPDATED_DATE()
     * @uses OrderDetailsType::setDISPATCH_DATE()
     * @uses OrderDetailsType::setDELIVERY_DATE()
     * @uses OrderDetailsType::setESTIMATED_DELIVERY_DATE()
     * @uses OrderDetailsType::setDOWNLOADED()
     * @uses OrderDetailsType::setDOWNLOADED_DATE()
     * @uses OrderDetailsType::setPRODUCT_TOTAL_INC()
     * @uses OrderDetailsType::setPRODUCT_TOTAL_EX()
     * @uses OrderDetailsType::setPRODUCT_TOTAL_VAT()
     * @uses OrderDetailsType::setSHIPPING_TOTAL_INC()
     * @uses OrderDetailsType::setSHIPPING_TOTAL_EX()
     * @uses OrderDetailsType::setSHIPPING_TOTAL_VAT()
     * @uses OrderDetailsType::setDISCOUNT_TOTAL_INC()
     * @uses OrderDetailsType::setDISCOUNT_TOTAL_EX()
     * @uses OrderDetailsType::setDISCOUNT_TOTAL_VAT()
     * @uses OrderDetailsType::setGRAND_TOTAL_INC()
     * @uses OrderDetailsType::setGRAND_TOTAL_EX()
     * @uses OrderDetailsType::setGRAND_TOTAL_VAT()
     * @uses OrderDetailsType::setORDER_CURRENCY()
     * @uses OrderDetailsType::setORDER_CUSTOMER_COMMENTS()
     * @uses OrderDetailsType::setORDER_NOTES()
     * @uses OrderDetailsType::setORDER_TYPE()
     * @uses OrderDetailsType::setDELIVERY_METHOD()
     * @uses OrderDetailsType::setGIFTWRAP_TOTAL_INC()
     * @uses OrderDetailsType::setGIFTWRAP_TOTAL_NET()
     * @uses OrderDetailsType::setGIFTWRAP_TOTAL_VAT()
     * @uses OrderDetailsType::setNUMBER_PRODUCTS()
     * @uses OrderDetailsType::setMULTICHANNEL_SOURCE()
     * @uses OrderDetailsType::setCOURIER_STOCK_SYSTEM_REFERENCE_CODE()
     * @uses OrderDetailsType::setPO_NUMBER()
     * @uses OrderDetailsType::setCUSTOMER_DELIVERY_NOTES()
     * @uses OrderDetailsType::setBRANCH_INTERNAL_REFERENCE()
     * @uses OrderDetailsType::setTRACKING_INFO()
     * @param int $oRDER_ID
     * @param int $wEBSITE_ID
     * @param string $oRDER_REFERENCE
     * @param int $oRDER_STATUS_ID
     * @param string $oRDER_STATUS
     * @param string $aMAZON_PRIME
     * @param string $iS_SPLIT_PARENT
     * @param int $pARENT_ORDER_ID
     * @param int $oRDER_FRAUD_STATE_ID
     * @param string $oRDER_DATE
     * @param string $uPDATED_DATE
     * @param string $dISPATCH_DATE
     * @param string $dELIVERY_DATE
     * @param string $eSTIMATED_DELIVERY_DATE
     * @param string $dOWNLOADED
     * @param string $dOWNLOADED_DATE
     * @param float $pRODUCT_TOTAL_INC
     * @param float $pRODUCT_TOTAL_EX
     * @param float $pRODUCT_TOTAL_VAT
     * @param float $sHIPPING_TOTAL_INC
     * @param float $sHIPPING_TOTAL_EX
     * @param float $sHIPPING_TOTAL_VAT
     * @param float $dISCOUNT_TOTAL_INC
     * @param float $dISCOUNT_TOTAL_EX
     * @param float $dISCOUNT_TOTAL_VAT
     * @param float $gRAND_TOTAL_INC
     * @param float $gRAND_TOTAL_EX
     * @param float $gRAND_TOTAL_VAT
     * @param string $oRDER_CURRENCY
     * @param string $oRDER_CUSTOMER_COMMENTS
     * @param string $oRDER_NOTES
     * @param string $oRDER_TYPE
     * @param string $dELIVERY_METHOD
     * @param float $gIFTWRAP_TOTAL_INC
     * @param float $gIFTWRAP_TOTAL_NET
     * @param float $gIFTWRAP_TOTAL_VAT
     * @param int $nUMBER_PRODUCTS
     * @param \StructType\MULTICHANNEL_SOURCE $mULTICHANNEL_SOURCE
     * @param string $cOURIER_STOCK_SYSTEM_REFERENCE_CODE
     * @param string $pO_NUMBER
     * @param string $cUSTOMER_DELIVERY_NOTES
     * @param string $bRANCH_INTERNAL_REFERENCE
     * @param \StructType\TRACKING_INFO $tRACKING_INFO
     */
    public function __construct($oRDER_ID = null, $wEBSITE_ID = null, $oRDER_REFERENCE = null, $oRDER_STATUS_ID = null, $oRDER_STATUS = null, $aMAZON_PRIME = null, $iS_SPLIT_PARENT = null, $pARENT_ORDER_ID = null, $oRDER_FRAUD_STATE_ID = null, $oRDER_DATE = null, $uPDATED_DATE = null, $dISPATCH_DATE = null, $dELIVERY_DATE = null, $eSTIMATED_DELIVERY_DATE = null, $dOWNLOADED = null, $dOWNLOADED_DATE = null, $pRODUCT_TOTAL_INC = null, $pRODUCT_TOTAL_EX = null, $pRODUCT_TOTAL_VAT = null, $sHIPPING_TOTAL_INC = null, $sHIPPING_TOTAL_EX = null, $sHIPPING_TOTAL_VAT = null, $dISCOUNT_TOTAL_INC = null, $dISCOUNT_TOTAL_EX = null, $dISCOUNT_TOTAL_VAT = null, $gRAND_TOTAL_INC = null, $gRAND_TOTAL_EX = null, $gRAND_TOTAL_VAT = null, $oRDER_CURRENCY = null, $oRDER_CUSTOMER_COMMENTS = null, $oRDER_NOTES = null, $oRDER_TYPE = null, $dELIVERY_METHOD = null, $gIFTWRAP_TOTAL_INC = null, $gIFTWRAP_TOTAL_NET = null, $gIFTWRAP_TOTAL_VAT = null, $nUMBER_PRODUCTS = null, \StructType\MULTICHANNEL_SOURCE $mULTICHANNEL_SOURCE = null, $cOURIER_STOCK_SYSTEM_REFERENCE_CODE = null, $pO_NUMBER = null, $cUSTOMER_DELIVERY_NOTES = null, $bRANCH_INTERNAL_REFERENCE = null, \StructType\TRACKING_INFO $tRACKING_INFO = null)
    {
        $this
            ->setORDER_ID($oRDER_ID)
            ->setWEBSITE_ID($wEBSITE_ID)
            ->setORDER_REFERENCE($oRDER_REFERENCE)
            ->setORDER_STATUS_ID($oRDER_STATUS_ID)
            ->setORDER_STATUS($oRDER_STATUS)
            ->setAMAZON_PRIME($aMAZON_PRIME)
            ->setIS_SPLIT_PARENT($iS_SPLIT_PARENT)
            ->setPARENT_ORDER_ID($pARENT_ORDER_ID)
            ->setORDER_FRAUD_STATE_ID($oRDER_FRAUD_STATE_ID)
            ->setORDER_DATE($oRDER_DATE)
            ->setUPDATED_DATE($uPDATED_DATE)
            ->setDISPATCH_DATE($dISPATCH_DATE)
            ->setDELIVERY_DATE($dELIVERY_DATE)
            ->setESTIMATED_DELIVERY_DATE($eSTIMATED_DELIVERY_DATE)
            ->setDOWNLOADED($dOWNLOADED)
            ->setDOWNLOADED_DATE($dOWNLOADED_DATE)
            ->setPRODUCT_TOTAL_INC($pRODUCT_TOTAL_INC)
            ->setPRODUCT_TOTAL_EX($pRODUCT_TOTAL_EX)
            ->setPRODUCT_TOTAL_VAT($pRODUCT_TOTAL_VAT)
            ->setSHIPPING_TOTAL_INC($sHIPPING_TOTAL_INC)
            ->setSHIPPING_TOTAL_EX($sHIPPING_TOTAL_EX)
            ->setSHIPPING_TOTAL_VAT($sHIPPING_TOTAL_VAT)
            ->setDISCOUNT_TOTAL_INC($dISCOUNT_TOTAL_INC)
            ->setDISCOUNT_TOTAL_EX($dISCOUNT_TOTAL_EX)
            ->setDISCOUNT_TOTAL_VAT($dISCOUNT_TOTAL_VAT)
            ->setGRAND_TOTAL_INC($gRAND_TOTAL_INC)
            ->setGRAND_TOTAL_EX($gRAND_TOTAL_EX)
            ->setGRAND_TOTAL_VAT($gRAND_TOTAL_VAT)
            ->setORDER_CURRENCY($oRDER_CURRENCY)
            ->setORDER_CUSTOMER_COMMENTS($oRDER_CUSTOMER_COMMENTS)
            ->setORDER_NOTES($oRDER_NOTES)
            ->setORDER_TYPE($oRDER_TYPE)
            ->setDELIVERY_METHOD($dELIVERY_METHOD)
            ->setGIFTWRAP_TOTAL_INC($gIFTWRAP_TOTAL_INC)
            ->setGIFTWRAP_TOTAL_NET($gIFTWRAP_TOTAL_NET)
            ->setGIFTWRAP_TOTAL_VAT($gIFTWRAP_TOTAL_VAT)
            ->setNUMBER_PRODUCTS($nUMBER_PRODUCTS)
            ->setMULTICHANNEL_SOURCE($mULTICHANNEL_SOURCE)
            ->setCOURIER_STOCK_SYSTEM_REFERENCE_CODE($cOURIER_STOCK_SYSTEM_REFERENCE_CODE)
            ->setPO_NUMBER($pO_NUMBER)
            ->setCUSTOMER_DELIVERY_NOTES($cUSTOMER_DELIVERY_NOTES)
            ->setBRANCH_INTERNAL_REFERENCE($bRANCH_INTERNAL_REFERENCE)
            ->setTRACKING_INFO($tRACKING_INFO);
    }
    /**
     * Get ORDER_ID value
     * @return int|null
     */
    public function getORDER_ID()
    {
        return $this->ORDER_ID;
    }
    /**
     * Set ORDER_ID value
     * @param int $oRDER_ID
     * @return \StructType\OrderDetailsType
     */
    public function setORDER_ID($oRDER_ID = null)
    {
        // validation for constraint: int
        if (!is_null($oRDER_ID) && !(is_int($oRDER_ID) || ctype_digit($oRDER_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oRDER_ID, true), gettype($oRDER_ID)), __LINE__);
        }
        $this->ORDER_ID = $oRDER_ID;
        return $this;
    }
    /**
     * Get WEBSITE_ID value
     * @return int|null
     */
    public function getWEBSITE_ID()
    {
        return $this->WEBSITE_ID;
    }
    /**
     * Set WEBSITE_ID value
     * @param int $wEBSITE_ID
     * @return \StructType\OrderDetailsType
     */
    public function setWEBSITE_ID($wEBSITE_ID = null)
    {
        // validation for constraint: int
        if (!is_null($wEBSITE_ID) && !(is_int($wEBSITE_ID) || ctype_digit($wEBSITE_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wEBSITE_ID, true), gettype($wEBSITE_ID)), __LINE__);
        }
        $this->WEBSITE_ID = $wEBSITE_ID;
        return $this;
    }
    /**
     * Get ORDER_REFERENCE value
     * @return string|null
     */
    public function getORDER_REFERENCE()
    {
        return $this->ORDER_REFERENCE;
    }
    /**
     * Set ORDER_REFERENCE value
     * @param string $oRDER_REFERENCE
     * @return \StructType\OrderDetailsType
     */
    public function setORDER_REFERENCE($oRDER_REFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($oRDER_REFERENCE) && !is_string($oRDER_REFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oRDER_REFERENCE, true), gettype($oRDER_REFERENCE)), __LINE__);
        }
        $this->ORDER_REFERENCE = $oRDER_REFERENCE;
        return $this;
    }
    /**
     * Get ORDER_STATUS_ID value
     * @return int|null
     */
    public function getORDER_STATUS_ID()
    {
        return $this->ORDER_STATUS_ID;
    }
    /**
     * Set ORDER_STATUS_ID value
     * @param int $oRDER_STATUS_ID
     * @return \StructType\OrderDetailsType
     */
    public function setORDER_STATUS_ID($oRDER_STATUS_ID = null)
    {
        // validation for constraint: int
        if (!is_null($oRDER_STATUS_ID) && !(is_int($oRDER_STATUS_ID) || ctype_digit($oRDER_STATUS_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oRDER_STATUS_ID, true), gettype($oRDER_STATUS_ID)), __LINE__);
        }
        $this->ORDER_STATUS_ID = $oRDER_STATUS_ID;
        return $this;
    }
    /**
     * Get ORDER_STATUS value
     * @return string|null
     */
    public function getORDER_STATUS()
    {
        return $this->ORDER_STATUS;
    }
    /**
     * Set ORDER_STATUS value
     * @param string $oRDER_STATUS
     * @return \StructType\OrderDetailsType
     */
    public function setORDER_STATUS($oRDER_STATUS = null)
    {
        // validation for constraint: string
        if (!is_null($oRDER_STATUS) && !is_string($oRDER_STATUS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oRDER_STATUS, true), gettype($oRDER_STATUS)), __LINE__);
        }
        $this->ORDER_STATUS = $oRDER_STATUS;
        return $this;
    }
    /**
     * Get AMAZON_PRIME value
     * @return string|null
     */
    public function getAMAZON_PRIME()
    {
        return $this->AMAZON_PRIME;
    }
    /**
     * Set AMAZON_PRIME value
     * @param string $aMAZON_PRIME
     * @return \StructType\OrderDetailsType
     */
    public function setAMAZON_PRIME($aMAZON_PRIME = null)
    {
        // validation for constraint: string
        if (!is_null($aMAZON_PRIME) && !is_string($aMAZON_PRIME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aMAZON_PRIME, true), gettype($aMAZON_PRIME)), __LINE__);
        }
        $this->AMAZON_PRIME = $aMAZON_PRIME;
        return $this;
    }
    /**
     * Get IS_SPLIT_PARENT value
     * @return string|null
     */
    public function getIS_SPLIT_PARENT()
    {
        return $this->IS_SPLIT_PARENT;
    }
    /**
     * Set IS_SPLIT_PARENT value
     * @param string $iS_SPLIT_PARENT
     * @return \StructType\OrderDetailsType
     */
    public function setIS_SPLIT_PARENT($iS_SPLIT_PARENT = null)
    {
        // validation for constraint: string
        if (!is_null($iS_SPLIT_PARENT) && !is_string($iS_SPLIT_PARENT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iS_SPLIT_PARENT, true), gettype($iS_SPLIT_PARENT)), __LINE__);
        }
        $this->IS_SPLIT_PARENT = $iS_SPLIT_PARENT;
        return $this;
    }
    /**
     * Get PARENT_ORDER_ID value
     * @return int|null
     */
    public function getPARENT_ORDER_ID()
    {
        return $this->PARENT_ORDER_ID;
    }
    /**
     * Set PARENT_ORDER_ID value
     * @param int $pARENT_ORDER_ID
     * @return \StructType\OrderDetailsType
     */
    public function setPARENT_ORDER_ID($pARENT_ORDER_ID = null)
    {
        // validation for constraint: int
        if (!is_null($pARENT_ORDER_ID) && !(is_int($pARENT_ORDER_ID) || ctype_digit($pARENT_ORDER_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pARENT_ORDER_ID, true), gettype($pARENT_ORDER_ID)), __LINE__);
        }
        $this->PARENT_ORDER_ID = $pARENT_ORDER_ID;
        return $this;
    }
    /**
     * Get ORDER_FRAUD_STATE_ID value
     * @return int|null
     */
    public function getORDER_FRAUD_STATE_ID()
    {
        return $this->ORDER_FRAUD_STATE_ID;
    }
    /**
     * Set ORDER_FRAUD_STATE_ID value
     * @param int $oRDER_FRAUD_STATE_ID
     * @return \StructType\OrderDetailsType
     */
    public function setORDER_FRAUD_STATE_ID($oRDER_FRAUD_STATE_ID = null)
    {
        // validation for constraint: int
        if (!is_null($oRDER_FRAUD_STATE_ID) && !(is_int($oRDER_FRAUD_STATE_ID) || ctype_digit($oRDER_FRAUD_STATE_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oRDER_FRAUD_STATE_ID, true), gettype($oRDER_FRAUD_STATE_ID)), __LINE__);
        }
        $this->ORDER_FRAUD_STATE_ID = $oRDER_FRAUD_STATE_ID;
        return $this;
    }
    /**
     * Get ORDER_DATE value
     * @return string|null
     */
    public function getORDER_DATE()
    {
        return $this->ORDER_DATE;
    }
    /**
     * Set ORDER_DATE value
     * @param string $oRDER_DATE
     * @return \StructType\OrderDetailsType
     */
    public function setORDER_DATE($oRDER_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($oRDER_DATE) && !is_string($oRDER_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oRDER_DATE, true), gettype($oRDER_DATE)), __LINE__);
        }
        $this->ORDER_DATE = $oRDER_DATE;
        return $this;
    }
    /**
     * Get UPDATED_DATE value
     * @return string|null
     */
    public function getUPDATED_DATE()
    {
        return $this->UPDATED_DATE;
    }
    /**
     * Set UPDATED_DATE value
     * @param string $uPDATED_DATE
     * @return \StructType\OrderDetailsType
     */
    public function setUPDATED_DATE($uPDATED_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($uPDATED_DATE) && !is_string($uPDATED_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uPDATED_DATE, true), gettype($uPDATED_DATE)), __LINE__);
        }
        $this->UPDATED_DATE = $uPDATED_DATE;
        return $this;
    }
    /**
     * Get DISPATCH_DATE value
     * @return string|null
     */
    public function getDISPATCH_DATE()
    {
        return $this->DISPATCH_DATE;
    }
    /**
     * Set DISPATCH_DATE value
     * @param string $dISPATCH_DATE
     * @return \StructType\OrderDetailsType
     */
    public function setDISPATCH_DATE($dISPATCH_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($dISPATCH_DATE) && !is_string($dISPATCH_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dISPATCH_DATE, true), gettype($dISPATCH_DATE)), __LINE__);
        }
        $this->DISPATCH_DATE = $dISPATCH_DATE;
        return $this;
    }
    /**
     * Get DELIVERY_DATE value
     * @return string|null
     */
    public function getDELIVERY_DATE()
    {
        return $this->DELIVERY_DATE;
    }
    /**
     * Set DELIVERY_DATE value
     * @param string $dELIVERY_DATE
     * @return \StructType\OrderDetailsType
     */
    public function setDELIVERY_DATE($dELIVERY_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($dELIVERY_DATE) && !is_string($dELIVERY_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dELIVERY_DATE, true), gettype($dELIVERY_DATE)), __LINE__);
        }
        $this->DELIVERY_DATE = $dELIVERY_DATE;
        return $this;
    }
    /**
     * Get ESTIMATED_DELIVERY_DATE value
     * @return string|null
     */
    public function getESTIMATED_DELIVERY_DATE()
    {
        return $this->ESTIMATED_DELIVERY_DATE;
    }
    /**
     * Set ESTIMATED_DELIVERY_DATE value
     * @param string $eSTIMATED_DELIVERY_DATE
     * @return \StructType\OrderDetailsType
     */
    public function setESTIMATED_DELIVERY_DATE($eSTIMATED_DELIVERY_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($eSTIMATED_DELIVERY_DATE) && !is_string($eSTIMATED_DELIVERY_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eSTIMATED_DELIVERY_DATE, true), gettype($eSTIMATED_DELIVERY_DATE)), __LINE__);
        }
        $this->ESTIMATED_DELIVERY_DATE = $eSTIMATED_DELIVERY_DATE;
        return $this;
    }
    /**
     * Get DOWNLOADED value
     * @return string|null
     */
    public function getDOWNLOADED()
    {
        return $this->DOWNLOADED;
    }
    /**
     * Set DOWNLOADED value
     * @param string $dOWNLOADED
     * @return \StructType\OrderDetailsType
     */
    public function setDOWNLOADED($dOWNLOADED = null)
    {
        // validation for constraint: string
        if (!is_null($dOWNLOADED) && !is_string($dOWNLOADED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dOWNLOADED, true), gettype($dOWNLOADED)), __LINE__);
        }
        $this->DOWNLOADED = $dOWNLOADED;
        return $this;
    }
    /**
     * Get DOWNLOADED_DATE value
     * @return string|null
     */
    public function getDOWNLOADED_DATE()
    {
        return $this->DOWNLOADED_DATE;
    }
    /**
     * Set DOWNLOADED_DATE value
     * @param string $dOWNLOADED_DATE
     * @return \StructType\OrderDetailsType
     */
    public function setDOWNLOADED_DATE($dOWNLOADED_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($dOWNLOADED_DATE) && !is_string($dOWNLOADED_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dOWNLOADED_DATE, true), gettype($dOWNLOADED_DATE)), __LINE__);
        }
        $this->DOWNLOADED_DATE = $dOWNLOADED_DATE;
        return $this;
    }
    /**
     * Get PRODUCT_TOTAL_INC value
     * @return float|null
     */
    public function getPRODUCT_TOTAL_INC()
    {
        return $this->PRODUCT_TOTAL_INC;
    }
    /**
     * Set PRODUCT_TOTAL_INC value
     * @param float $pRODUCT_TOTAL_INC
     * @return \StructType\OrderDetailsType
     */
    public function setPRODUCT_TOTAL_INC($pRODUCT_TOTAL_INC = null)
    {
        // validation for constraint: float
        if (!is_null($pRODUCT_TOTAL_INC) && !(is_float($pRODUCT_TOTAL_INC) || is_numeric($pRODUCT_TOTAL_INC))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pRODUCT_TOTAL_INC, true), gettype($pRODUCT_TOTAL_INC)), __LINE__);
        }
        $this->PRODUCT_TOTAL_INC = $pRODUCT_TOTAL_INC;
        return $this;
    }
    /**
     * Get PRODUCT_TOTAL_EX value
     * @return float|null
     */
    public function getPRODUCT_TOTAL_EX()
    {
        return $this->PRODUCT_TOTAL_EX;
    }
    /**
     * Set PRODUCT_TOTAL_EX value
     * @param float $pRODUCT_TOTAL_EX
     * @return \StructType\OrderDetailsType
     */
    public function setPRODUCT_TOTAL_EX($pRODUCT_TOTAL_EX = null)
    {
        // validation for constraint: float
        if (!is_null($pRODUCT_TOTAL_EX) && !(is_float($pRODUCT_TOTAL_EX) || is_numeric($pRODUCT_TOTAL_EX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pRODUCT_TOTAL_EX, true), gettype($pRODUCT_TOTAL_EX)), __LINE__);
        }
        $this->PRODUCT_TOTAL_EX = $pRODUCT_TOTAL_EX;
        return $this;
    }
    /**
     * Get PRODUCT_TOTAL_VAT value
     * @return float|null
     */
    public function getPRODUCT_TOTAL_VAT()
    {
        return $this->PRODUCT_TOTAL_VAT;
    }
    /**
     * Set PRODUCT_TOTAL_VAT value
     * @param float $pRODUCT_TOTAL_VAT
     * @return \StructType\OrderDetailsType
     */
    public function setPRODUCT_TOTAL_VAT($pRODUCT_TOTAL_VAT = null)
    {
        // validation for constraint: float
        if (!is_null($pRODUCT_TOTAL_VAT) && !(is_float($pRODUCT_TOTAL_VAT) || is_numeric($pRODUCT_TOTAL_VAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pRODUCT_TOTAL_VAT, true), gettype($pRODUCT_TOTAL_VAT)), __LINE__);
        }
        $this->PRODUCT_TOTAL_VAT = $pRODUCT_TOTAL_VAT;
        return $this;
    }
    /**
     * Get SHIPPING_TOTAL_INC value
     * @return float|null
     */
    public function getSHIPPING_TOTAL_INC()
    {
        return $this->SHIPPING_TOTAL_INC;
    }
    /**
     * Set SHIPPING_TOTAL_INC value
     * @param float $sHIPPING_TOTAL_INC
     * @return \StructType\OrderDetailsType
     */
    public function setSHIPPING_TOTAL_INC($sHIPPING_TOTAL_INC = null)
    {
        // validation for constraint: float
        if (!is_null($sHIPPING_TOTAL_INC) && !(is_float($sHIPPING_TOTAL_INC) || is_numeric($sHIPPING_TOTAL_INC))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sHIPPING_TOTAL_INC, true), gettype($sHIPPING_TOTAL_INC)), __LINE__);
        }
        $this->SHIPPING_TOTAL_INC = $sHIPPING_TOTAL_INC;
        return $this;
    }
    /**
     * Get SHIPPING_TOTAL_EX value
     * @return float|null
     */
    public function getSHIPPING_TOTAL_EX()
    {
        return $this->SHIPPING_TOTAL_EX;
    }
    /**
     * Set SHIPPING_TOTAL_EX value
     * @param float $sHIPPING_TOTAL_EX
     * @return \StructType\OrderDetailsType
     */
    public function setSHIPPING_TOTAL_EX($sHIPPING_TOTAL_EX = null)
    {
        // validation for constraint: float
        if (!is_null($sHIPPING_TOTAL_EX) && !(is_float($sHIPPING_TOTAL_EX) || is_numeric($sHIPPING_TOTAL_EX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sHIPPING_TOTAL_EX, true), gettype($sHIPPING_TOTAL_EX)), __LINE__);
        }
        $this->SHIPPING_TOTAL_EX = $sHIPPING_TOTAL_EX;
        return $this;
    }
    /**
     * Get SHIPPING_TOTAL_VAT value
     * @return float|null
     */
    public function getSHIPPING_TOTAL_VAT()
    {
        return $this->SHIPPING_TOTAL_VAT;
    }
    /**
     * Set SHIPPING_TOTAL_VAT value
     * @param float $sHIPPING_TOTAL_VAT
     * @return \StructType\OrderDetailsType
     */
    public function setSHIPPING_TOTAL_VAT($sHIPPING_TOTAL_VAT = null)
    {
        // validation for constraint: float
        if (!is_null($sHIPPING_TOTAL_VAT) && !(is_float($sHIPPING_TOTAL_VAT) || is_numeric($sHIPPING_TOTAL_VAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sHIPPING_TOTAL_VAT, true), gettype($sHIPPING_TOTAL_VAT)), __LINE__);
        }
        $this->SHIPPING_TOTAL_VAT = $sHIPPING_TOTAL_VAT;
        return $this;
    }
    /**
     * Get DISCOUNT_TOTAL_INC value
     * @return float|null
     */
    public function getDISCOUNT_TOTAL_INC()
    {
        return $this->DISCOUNT_TOTAL_INC;
    }
    /**
     * Set DISCOUNT_TOTAL_INC value
     * @param float $dISCOUNT_TOTAL_INC
     * @return \StructType\OrderDetailsType
     */
    public function setDISCOUNT_TOTAL_INC($dISCOUNT_TOTAL_INC = null)
    {
        // validation for constraint: float
        if (!is_null($dISCOUNT_TOTAL_INC) && !(is_float($dISCOUNT_TOTAL_INC) || is_numeric($dISCOUNT_TOTAL_INC))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dISCOUNT_TOTAL_INC, true), gettype($dISCOUNT_TOTAL_INC)), __LINE__);
        }
        $this->DISCOUNT_TOTAL_INC = $dISCOUNT_TOTAL_INC;
        return $this;
    }
    /**
     * Get DISCOUNT_TOTAL_EX value
     * @return float|null
     */
    public function getDISCOUNT_TOTAL_EX()
    {
        return $this->DISCOUNT_TOTAL_EX;
    }
    /**
     * Set DISCOUNT_TOTAL_EX value
     * @param float $dISCOUNT_TOTAL_EX
     * @return \StructType\OrderDetailsType
     */
    public function setDISCOUNT_TOTAL_EX($dISCOUNT_TOTAL_EX = null)
    {
        // validation for constraint: float
        if (!is_null($dISCOUNT_TOTAL_EX) && !(is_float($dISCOUNT_TOTAL_EX) || is_numeric($dISCOUNT_TOTAL_EX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dISCOUNT_TOTAL_EX, true), gettype($dISCOUNT_TOTAL_EX)), __LINE__);
        }
        $this->DISCOUNT_TOTAL_EX = $dISCOUNT_TOTAL_EX;
        return $this;
    }
    /**
     * Get DISCOUNT_TOTAL_VAT value
     * @return float|null
     */
    public function getDISCOUNT_TOTAL_VAT()
    {
        return $this->DISCOUNT_TOTAL_VAT;
    }
    /**
     * Set DISCOUNT_TOTAL_VAT value
     * @param float $dISCOUNT_TOTAL_VAT
     * @return \StructType\OrderDetailsType
     */
    public function setDISCOUNT_TOTAL_VAT($dISCOUNT_TOTAL_VAT = null)
    {
        // validation for constraint: float
        if (!is_null($dISCOUNT_TOTAL_VAT) && !(is_float($dISCOUNT_TOTAL_VAT) || is_numeric($dISCOUNT_TOTAL_VAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dISCOUNT_TOTAL_VAT, true), gettype($dISCOUNT_TOTAL_VAT)), __LINE__);
        }
        $this->DISCOUNT_TOTAL_VAT = $dISCOUNT_TOTAL_VAT;
        return $this;
    }
    /**
     * Get GRAND_TOTAL_INC value
     * @return float|null
     */
    public function getGRAND_TOTAL_INC()
    {
        return $this->GRAND_TOTAL_INC;
    }
    /**
     * Set GRAND_TOTAL_INC value
     * @param float $gRAND_TOTAL_INC
     * @return \StructType\OrderDetailsType
     */
    public function setGRAND_TOTAL_INC($gRAND_TOTAL_INC = null)
    {
        // validation for constraint: float
        if (!is_null($gRAND_TOTAL_INC) && !(is_float($gRAND_TOTAL_INC) || is_numeric($gRAND_TOTAL_INC))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gRAND_TOTAL_INC, true), gettype($gRAND_TOTAL_INC)), __LINE__);
        }
        $this->GRAND_TOTAL_INC = $gRAND_TOTAL_INC;
        return $this;
    }
    /**
     * Get GRAND_TOTAL_EX value
     * @return float|null
     */
    public function getGRAND_TOTAL_EX()
    {
        return $this->GRAND_TOTAL_EX;
    }
    /**
     * Set GRAND_TOTAL_EX value
     * @param float $gRAND_TOTAL_EX
     * @return \StructType\OrderDetailsType
     */
    public function setGRAND_TOTAL_EX($gRAND_TOTAL_EX = null)
    {
        // validation for constraint: float
        if (!is_null($gRAND_TOTAL_EX) && !(is_float($gRAND_TOTAL_EX) || is_numeric($gRAND_TOTAL_EX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gRAND_TOTAL_EX, true), gettype($gRAND_TOTAL_EX)), __LINE__);
        }
        $this->GRAND_TOTAL_EX = $gRAND_TOTAL_EX;
        return $this;
    }
    /**
     * Get GRAND_TOTAL_VAT value
     * @return float|null
     */
    public function getGRAND_TOTAL_VAT()
    {
        return $this->GRAND_TOTAL_VAT;
    }
    /**
     * Set GRAND_TOTAL_VAT value
     * @param float $gRAND_TOTAL_VAT
     * @return \StructType\OrderDetailsType
     */
    public function setGRAND_TOTAL_VAT($gRAND_TOTAL_VAT = null)
    {
        // validation for constraint: float
        if (!is_null($gRAND_TOTAL_VAT) && !(is_float($gRAND_TOTAL_VAT) || is_numeric($gRAND_TOTAL_VAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gRAND_TOTAL_VAT, true), gettype($gRAND_TOTAL_VAT)), __LINE__);
        }
        $this->GRAND_TOTAL_VAT = $gRAND_TOTAL_VAT;
        return $this;
    }
    /**
     * Get ORDER_CURRENCY value
     * @return string|null
     */
    public function getORDER_CURRENCY()
    {
        return $this->ORDER_CURRENCY;
    }
    /**
     * Set ORDER_CURRENCY value
     * @param string $oRDER_CURRENCY
     * @return \StructType\OrderDetailsType
     */
    public function setORDER_CURRENCY($oRDER_CURRENCY = null)
    {
        // validation for constraint: string
        if (!is_null($oRDER_CURRENCY) && !is_string($oRDER_CURRENCY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oRDER_CURRENCY, true), gettype($oRDER_CURRENCY)), __LINE__);
        }
        $this->ORDER_CURRENCY = $oRDER_CURRENCY;
        return $this;
    }
    /**
     * Get ORDER_CUSTOMER_COMMENTS value
     * @return string|null
     */
    public function getORDER_CUSTOMER_COMMENTS()
    {
        return $this->ORDER_CUSTOMER_COMMENTS;
    }
    /**
     * Set ORDER_CUSTOMER_COMMENTS value
     * @param string $oRDER_CUSTOMER_COMMENTS
     * @return \StructType\OrderDetailsType
     */
    public function setORDER_CUSTOMER_COMMENTS($oRDER_CUSTOMER_COMMENTS = null)
    {
        // validation for constraint: string
        if (!is_null($oRDER_CUSTOMER_COMMENTS) && !is_string($oRDER_CUSTOMER_COMMENTS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oRDER_CUSTOMER_COMMENTS, true), gettype($oRDER_CUSTOMER_COMMENTS)), __LINE__);
        }
        $this->ORDER_CUSTOMER_COMMENTS = $oRDER_CUSTOMER_COMMENTS;
        return $this;
    }
    /**
     * Get ORDER_NOTES value
     * @return string|null
     */
    public function getORDER_NOTES()
    {
        return $this->ORDER_NOTES;
    }
    /**
     * Set ORDER_NOTES value
     * @param string $oRDER_NOTES
     * @return \StructType\OrderDetailsType
     */
    public function setORDER_NOTES($oRDER_NOTES = null)
    {
        // validation for constraint: string
        if (!is_null($oRDER_NOTES) && !is_string($oRDER_NOTES)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oRDER_NOTES, true), gettype($oRDER_NOTES)), __LINE__);
        }
        $this->ORDER_NOTES = $oRDER_NOTES;
        return $this;
    }
    /**
     * Get ORDER_TYPE value
     * @return string|null
     */
    public function getORDER_TYPE()
    {
        return $this->ORDER_TYPE;
    }
    /**
     * Set ORDER_TYPE value
     * @param string $oRDER_TYPE
     * @return \StructType\OrderDetailsType
     */
    public function setORDER_TYPE($oRDER_TYPE = null)
    {
        // validation for constraint: string
        if (!is_null($oRDER_TYPE) && !is_string($oRDER_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oRDER_TYPE, true), gettype($oRDER_TYPE)), __LINE__);
        }
        $this->ORDER_TYPE = $oRDER_TYPE;
        return $this;
    }
    /**
     * Get DELIVERY_METHOD value
     * @return string|null
     */
    public function getDELIVERY_METHOD()
    {
        return $this->DELIVERY_METHOD;
    }
    /**
     * Set DELIVERY_METHOD value
     * @param string $dELIVERY_METHOD
     * @return \StructType\OrderDetailsType
     */
    public function setDELIVERY_METHOD($dELIVERY_METHOD = null)
    {
        // validation for constraint: string
        if (!is_null($dELIVERY_METHOD) && !is_string($dELIVERY_METHOD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dELIVERY_METHOD, true), gettype($dELIVERY_METHOD)), __LINE__);
        }
        $this->DELIVERY_METHOD = $dELIVERY_METHOD;
        return $this;
    }
    /**
     * Get GIFTWRAP_TOTAL_INC value
     * @return float|null
     */
    public function getGIFTWRAP_TOTAL_INC()
    {
        return $this->GIFTWRAP_TOTAL_INC;
    }
    /**
     * Set GIFTWRAP_TOTAL_INC value
     * @param float $gIFTWRAP_TOTAL_INC
     * @return \StructType\OrderDetailsType
     */
    public function setGIFTWRAP_TOTAL_INC($gIFTWRAP_TOTAL_INC = null)
    {
        // validation for constraint: float
        if (!is_null($gIFTWRAP_TOTAL_INC) && !(is_float($gIFTWRAP_TOTAL_INC) || is_numeric($gIFTWRAP_TOTAL_INC))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gIFTWRAP_TOTAL_INC, true), gettype($gIFTWRAP_TOTAL_INC)), __LINE__);
        }
        $this->GIFTWRAP_TOTAL_INC = $gIFTWRAP_TOTAL_INC;
        return $this;
    }
    /**
     * Get GIFTWRAP_TOTAL_NET value
     * @return float|null
     */
    public function getGIFTWRAP_TOTAL_NET()
    {
        return $this->GIFTWRAP_TOTAL_NET;
    }
    /**
     * Set GIFTWRAP_TOTAL_NET value
     * @param float $gIFTWRAP_TOTAL_NET
     * @return \StructType\OrderDetailsType
     */
    public function setGIFTWRAP_TOTAL_NET($gIFTWRAP_TOTAL_NET = null)
    {
        // validation for constraint: float
        if (!is_null($gIFTWRAP_TOTAL_NET) && !(is_float($gIFTWRAP_TOTAL_NET) || is_numeric($gIFTWRAP_TOTAL_NET))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gIFTWRAP_TOTAL_NET, true), gettype($gIFTWRAP_TOTAL_NET)), __LINE__);
        }
        $this->GIFTWRAP_TOTAL_NET = $gIFTWRAP_TOTAL_NET;
        return $this;
    }
    /**
     * Get GIFTWRAP_TOTAL_VAT value
     * @return float|null
     */
    public function getGIFTWRAP_TOTAL_VAT()
    {
        return $this->GIFTWRAP_TOTAL_VAT;
    }
    /**
     * Set GIFTWRAP_TOTAL_VAT value
     * @param float $gIFTWRAP_TOTAL_VAT
     * @return \StructType\OrderDetailsType
     */
    public function setGIFTWRAP_TOTAL_VAT($gIFTWRAP_TOTAL_VAT = null)
    {
        // validation for constraint: float
        if (!is_null($gIFTWRAP_TOTAL_VAT) && !(is_float($gIFTWRAP_TOTAL_VAT) || is_numeric($gIFTWRAP_TOTAL_VAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gIFTWRAP_TOTAL_VAT, true), gettype($gIFTWRAP_TOTAL_VAT)), __LINE__);
        }
        $this->GIFTWRAP_TOTAL_VAT = $gIFTWRAP_TOTAL_VAT;
        return $this;
    }
    /**
     * Get NUMBER_PRODUCTS value
     * @return int|null
     */
    public function getNUMBER_PRODUCTS()
    {
        return $this->NUMBER_PRODUCTS;
    }
    /**
     * Set NUMBER_PRODUCTS value
     * @param int $nUMBER_PRODUCTS
     * @return \StructType\OrderDetailsType
     */
    public function setNUMBER_PRODUCTS($nUMBER_PRODUCTS = null)
    {
        // validation for constraint: int
        if (!is_null($nUMBER_PRODUCTS) && !(is_int($nUMBER_PRODUCTS) || ctype_digit($nUMBER_PRODUCTS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nUMBER_PRODUCTS, true), gettype($nUMBER_PRODUCTS)), __LINE__);
        }
        $this->NUMBER_PRODUCTS = $nUMBER_PRODUCTS;
        return $this;
    }
    /**
     * Get MULTICHANNEL_SOURCE value
     * @return \StructType\MULTICHANNEL_SOURCE|null
     */
    public function getMULTICHANNEL_SOURCE()
    {
        return $this->MULTICHANNEL_SOURCE;
    }
    /**
     * Set MULTICHANNEL_SOURCE value
     * @param \StructType\MULTICHANNEL_SOURCE $mULTICHANNEL_SOURCE
     * @return \StructType\OrderDetailsType
     */
    public function setMULTICHANNEL_SOURCE(\StructType\MULTICHANNEL_SOURCE $mULTICHANNEL_SOURCE = null)
    {
        $this->MULTICHANNEL_SOURCE = $mULTICHANNEL_SOURCE;
        return $this;
    }
    /**
     * Get COURIER_STOCK_SYSTEM_REFERENCE_CODE value
     * @return string|null
     */
    public function getCOURIER_STOCK_SYSTEM_REFERENCE_CODE()
    {
        return $this->COURIER_STOCK_SYSTEM_REFERENCE_CODE;
    }
    /**
     * Set COURIER_STOCK_SYSTEM_REFERENCE_CODE value
     * @param string $cOURIER_STOCK_SYSTEM_REFERENCE_CODE
     * @return \StructType\OrderDetailsType
     */
    public function setCOURIER_STOCK_SYSTEM_REFERENCE_CODE($cOURIER_STOCK_SYSTEM_REFERENCE_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($cOURIER_STOCK_SYSTEM_REFERENCE_CODE) && !is_string($cOURIER_STOCK_SYSTEM_REFERENCE_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cOURIER_STOCK_SYSTEM_REFERENCE_CODE, true), gettype($cOURIER_STOCK_SYSTEM_REFERENCE_CODE)), __LINE__);
        }
        $this->COURIER_STOCK_SYSTEM_REFERENCE_CODE = $cOURIER_STOCK_SYSTEM_REFERENCE_CODE;
        return $this;
    }
    /**
     * Get PO_NUMBER value
     * @return string|null
     */
    public function getPO_NUMBER()
    {
        return $this->PO_NUMBER;
    }
    /**
     * Set PO_NUMBER value
     * @param string $pO_NUMBER
     * @return \StructType\OrderDetailsType
     */
    public function setPO_NUMBER($pO_NUMBER = null)
    {
        // validation for constraint: string
        if (!is_null($pO_NUMBER) && !is_string($pO_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pO_NUMBER, true), gettype($pO_NUMBER)), __LINE__);
        }
        $this->PO_NUMBER = $pO_NUMBER;
        return $this;
    }
    /**
     * Get CUSTOMER_DELIVERY_NOTES value
     * @return string|null
     */
    public function getCUSTOMER_DELIVERY_NOTES()
    {
        return $this->CUSTOMER_DELIVERY_NOTES;
    }
    /**
     * Set CUSTOMER_DELIVERY_NOTES value
     * @param string $cUSTOMER_DELIVERY_NOTES
     * @return \StructType\OrderDetailsType
     */
    public function setCUSTOMER_DELIVERY_NOTES($cUSTOMER_DELIVERY_NOTES = null)
    {
        // validation for constraint: string
        if (!is_null($cUSTOMER_DELIVERY_NOTES) && !is_string($cUSTOMER_DELIVERY_NOTES)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cUSTOMER_DELIVERY_NOTES, true), gettype($cUSTOMER_DELIVERY_NOTES)), __LINE__);
        }
        $this->CUSTOMER_DELIVERY_NOTES = $cUSTOMER_DELIVERY_NOTES;
        return $this;
    }
    /**
     * Get BRANCH_INTERNAL_REFERENCE value
     * @return string|null
     */
    public function getBRANCH_INTERNAL_REFERENCE()
    {
        return $this->BRANCH_INTERNAL_REFERENCE;
    }
    /**
     * Set BRANCH_INTERNAL_REFERENCE value
     * @param string $bRANCH_INTERNAL_REFERENCE
     * @return \StructType\OrderDetailsType
     */
    public function setBRANCH_INTERNAL_REFERENCE($bRANCH_INTERNAL_REFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($bRANCH_INTERNAL_REFERENCE) && !is_string($bRANCH_INTERNAL_REFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bRANCH_INTERNAL_REFERENCE, true), gettype($bRANCH_INTERNAL_REFERENCE)), __LINE__);
        }
        $this->BRANCH_INTERNAL_REFERENCE = $bRANCH_INTERNAL_REFERENCE;
        return $this;
    }
    /**
     * Get TRACKING_INFO value
     * @return \StructType\TRACKING_INFO|null
     */
    public function getTRACKING_INFO()
    {
        return $this->TRACKING_INFO;
    }
    /**
     * Set TRACKING_INFO value
     * @param \StructType\TRACKING_INFO $tRACKING_INFO
     * @return \StructType\OrderDetailsType
     */
    public function setTRACKING_INFO(\StructType\TRACKING_INFO $tRACKING_INFO = null)
    {
        $this->TRACKING_INFO = $tRACKING_INFO;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
