<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OptInsType StructType
 * @subpackage Structs
 */
class OptInsType extends AbstractStructBase
{
    /**
     * The EMAIL
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EMAIL;
    /**
     * The POST
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $POST;
    /**
     * The SMS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SMS;
    /**
     * The LOYALTY
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LOYALTY;
    /**
     * Constructor method for OptInsType
     * @uses OptInsType::setEMAIL()
     * @uses OptInsType::setPOST()
     * @uses OptInsType::setSMS()
     * @uses OptInsType::setLOYALTY()
     * @param string $eMAIL
     * @param string $pOST
     * @param string $sMS
     * @param string $lOYALTY
     */
    public function __construct($eMAIL = null, $pOST = null, $sMS = null, $lOYALTY = null)
    {
        $this
            ->setEMAIL($eMAIL)
            ->setPOST($pOST)
            ->setSMS($sMS)
            ->setLOYALTY($lOYALTY);
    }
    /**
     * Get EMAIL value
     * @return string|null
     */
    public function getEMAIL()
    {
        return $this->EMAIL;
    }
    /**
     * Set EMAIL value
     * @param string $eMAIL
     * @return \StructType\OptInsType
     */
    public function setEMAIL($eMAIL = null)
    {
        // validation for constraint: string
        if (!is_null($eMAIL) && !is_string($eMAIL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMAIL, true), gettype($eMAIL)), __LINE__);
        }
        $this->EMAIL = $eMAIL;
        return $this;
    }
    /**
     * Get POST value
     * @return string|null
     */
    public function getPOST()
    {
        return $this->POST;
    }
    /**
     * Set POST value
     * @param string $pOST
     * @return \StructType\OptInsType
     */
    public function setPOST($pOST = null)
    {
        // validation for constraint: string
        if (!is_null($pOST) && !is_string($pOST)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOST, true), gettype($pOST)), __LINE__);
        }
        $this->POST = $pOST;
        return $this;
    }
    /**
     * Get SMS value
     * @return string|null
     */
    public function getSMS()
    {
        return $this->SMS;
    }
    /**
     * Set SMS value
     * @param string $sMS
     * @return \StructType\OptInsType
     */
    public function setSMS($sMS = null)
    {
        // validation for constraint: string
        if (!is_null($sMS) && !is_string($sMS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sMS, true), gettype($sMS)), __LINE__);
        }
        $this->SMS = $sMS;
        return $this;
    }
    /**
     * Get LOYALTY value
     * @return string|null
     */
    public function getLOYALTY()
    {
        return $this->LOYALTY;
    }
    /**
     * Set LOYALTY value
     * @param string $lOYALTY
     * @return \StructType\OptInsType
     */
    public function setLOYALTY($lOYALTY = null)
    {
        // validation for constraint: string
        if (!is_null($lOYALTY) && !is_string($lOYALTY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lOYALTY, true), gettype($lOYALTY)), __LINE__);
        }
        $this->LOYALTY = $lOYALTY;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OptInsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
