<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetData StructType
 * @subpackage Structs
 */
class GetData extends AbstractStructBase
{
    /**
     * The data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $data;
    /**
     * Constructor method for GetData
     * @uses GetData::setData()
     * @param string[] $data
     */
    public function __construct(array $data = array())
    {
        $this
            ->setData($data);
    }
    /**
     * Get data value
     * @return string[]|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * This method is responsible for validating the values passed to the setData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDataForArrayConstraintsFromSetData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getDataDataItem) {
            // validation for constraint: itemType
            if (!is_string($getDataDataItem)) {
                $invalidValues[] = is_object($getDataDataItem) ? get_class($getDataDataItem) : sprintf('%s(%s)', gettype($getDataDataItem), var_export($getDataDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The data property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set data value
     * @throws \InvalidArgumentException
     * @param string[] $data
     * @return \StructType\GetData
     */
    public function setData(array $data = array())
    {
        // validation for constraint: array
        if ('' !== ($dataArrayErrorMessage = self::validateDataForArrayConstraintsFromSetData($data))) {
            throw new \InvalidArgumentException($dataArrayErrorMessage, __LINE__);
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Add item to data value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetData
     */
    public function addToData($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The data property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->data[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
