<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrayOfOrders StructType
 * @subpackage Structs
 */
class ArrayOfOrders extends AbstractStructBase
{
    /**
     * The order_id
     * Meta information extracted from the WSDL
     * - choice: order_id | order_ref
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var \ArrayType\ArrayOfOrdersIDs
     */
    public $order_id;
    /**
     * The order_ref
     * Meta information extracted from the WSDL
     * - choice: order_id | order_ref
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var \ArrayType\ArrayOfOrdersRefs
     */
    public $order_ref;
    /**
     * Constructor method for ArrayOfOrders
     * @uses ArrayOfOrders::setOrder_id()
     * @uses ArrayOfOrders::setOrder_ref()
     * @param \ArrayType\ArrayOfOrdersIDs $order_id
     * @param \ArrayType\ArrayOfOrdersRefs $order_ref
     */
    public function __construct(\ArrayType\ArrayOfOrdersIDs $order_id = null, \ArrayType\ArrayOfOrdersRefs $order_ref = null)
    {
        $this
            ->setOrder_id($order_id)
            ->setOrder_ref($order_ref);
    }
    /**
     * Get order_id value
     * @return \ArrayType\ArrayOfOrdersIDs|null
     */
    public function getOrder_id()
    {
        return isset($this->order_id) ? $this->order_id : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOrder_id method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder_id method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOrder_idForChoiceConstraintsFromSetOrder_id($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'order_ref',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property order_id can\'t be set as the property %s is already set. Only one property must be set among these properties: order_id, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set order_id value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \ArrayType\ArrayOfOrdersIDs $order_id
     * @return \StructType\ArrayOfOrders
     */
    public function setOrder_id(\ArrayType\ArrayOfOrdersIDs $order_id = null)
    {
        // validation for constraint: choice(order_id, order_ref)
        if ('' !== ($order_idChoiceErrorMessage = self::validateOrder_idForChoiceConstraintsFromSetOrder_id($order_id))) {
            throw new \InvalidArgumentException($order_idChoiceErrorMessage, __LINE__);
        }
        if (is_null($order_id) || (is_array($order_id) && empty($order_id))) {
            unset($this->order_id);
        } else {
            $this->order_id = $order_id;
        }
        return $this;
    }
    /**
     * Get order_ref value
     * @return \ArrayType\ArrayOfOrdersRefs|null
     */
    public function getOrder_ref()
    {
        return isset($this->order_ref) ? $this->order_ref : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOrder_ref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder_ref method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOrder_refForChoiceConstraintsFromSetOrder_ref($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'order_id',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property order_ref can\'t be set as the property %s is already set. Only one property must be set among these properties: order_ref, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set order_ref value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \ArrayType\ArrayOfOrdersRefs $order_ref
     * @return \StructType\ArrayOfOrders
     */
    public function setOrder_ref(\ArrayType\ArrayOfOrdersRefs $order_ref = null)
    {
        // validation for constraint: choice(order_id, order_ref)
        if ('' !== ($order_refChoiceErrorMessage = self::validateOrder_refForChoiceConstraintsFromSetOrder_ref($order_ref))) {
            throw new \InvalidArgumentException($order_refChoiceErrorMessage, __LINE__);
        }
        if (is_null($order_ref) || (is_array($order_ref) && empty($order_ref))) {
            unset($this->order_ref);
        } else {
            $this->order_ref = $order_ref;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArrayOfOrders
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
