<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddTradeDiscountType StructType
 * @subpackage Structs
 */
class AddTradeDiscountType extends AbstractStructBase
{
    /**
     * The VALUE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VALUE;
    /**
     * The TRADE_DISCOUNT_ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TRADE_DISCOUNT_ID;
    /**
     * The NAME
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NAME;
    /**
     * The TYPE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TYPE;
    /**
     * The ACTIVE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ACTIVE;
    /**
     * The DELETED
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DELETED;
    /**
     * The REFERENCE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $REFERENCE;
    /**
     * The PRODUCTS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var \StructType\PRODUCTS
     */
    public $PRODUCTS;
    /**
     * The CUSTOMER_GROUPS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var \StructType\CUSTOMER_GROUPS
     */
    public $CUSTOMER_GROUPS;
    /**
     * Constructor method for AddTradeDiscountType
     * @uses AddTradeDiscountType::setVALUE()
     * @uses AddTradeDiscountType::setTRADE_DISCOUNT_ID()
     * @uses AddTradeDiscountType::setNAME()
     * @uses AddTradeDiscountType::setTYPE()
     * @uses AddTradeDiscountType::setACTIVE()
     * @uses AddTradeDiscountType::setDELETED()
     * @uses AddTradeDiscountType::setREFERENCE()
     * @uses AddTradeDiscountType::setPRODUCTS()
     * @uses AddTradeDiscountType::setCUSTOMER_GROUPS()
     * @param float $vALUE
     * @param int $tRADE_DISCOUNT_ID
     * @param string $nAME
     * @param string $tYPE
     * @param string $aCTIVE
     * @param string $dELETED
     * @param string $rEFERENCE
     * @param \StructType\PRODUCTS $pRODUCTS
     * @param \StructType\CUSTOMER_GROUPS $cUSTOMER_GROUPS
     */
    public function __construct($vALUE = null, $tRADE_DISCOUNT_ID = null, $nAME = null, $tYPE = null, $aCTIVE = null, $dELETED = null, $rEFERENCE = null, \StructType\PRODUCTS $pRODUCTS = null, \StructType\CUSTOMER_GROUPS $cUSTOMER_GROUPS = null)
    {
        $this
            ->setVALUE($vALUE)
            ->setTRADE_DISCOUNT_ID($tRADE_DISCOUNT_ID)
            ->setNAME($nAME)
            ->setTYPE($tYPE)
            ->setACTIVE($aCTIVE)
            ->setDELETED($dELETED)
            ->setREFERENCE($rEFERENCE)
            ->setPRODUCTS($pRODUCTS)
            ->setCUSTOMER_GROUPS($cUSTOMER_GROUPS);
    }
    /**
     * Get VALUE value
     * @return float
     */
    public function getVALUE()
    {
        return $this->VALUE;
    }
    /**
     * Set VALUE value
     * @param float $vALUE
     * @return \StructType\AddTradeDiscountType
     */
    public function setVALUE($vALUE = null)
    {
        // validation for constraint: float
        if (!is_null($vALUE) && !(is_float($vALUE) || is_numeric($vALUE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vALUE, true), gettype($vALUE)), __LINE__);
        }
        $this->VALUE = $vALUE;
        return $this;
    }
    /**
     * Get TRADE_DISCOUNT_ID value
     * @return int|null
     */
    public function getTRADE_DISCOUNT_ID()
    {
        return $this->TRADE_DISCOUNT_ID;
    }
    /**
     * Set TRADE_DISCOUNT_ID value
     * @param int $tRADE_DISCOUNT_ID
     * @return \StructType\AddTradeDiscountType
     */
    public function setTRADE_DISCOUNT_ID($tRADE_DISCOUNT_ID = null)
    {
        // validation for constraint: int
        if (!is_null($tRADE_DISCOUNT_ID) && !(is_int($tRADE_DISCOUNT_ID) || ctype_digit($tRADE_DISCOUNT_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tRADE_DISCOUNT_ID, true), gettype($tRADE_DISCOUNT_ID)), __LINE__);
        }
        $this->TRADE_DISCOUNT_ID = $tRADE_DISCOUNT_ID;
        return $this;
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \StructType\AddTradeDiscountType
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nAME, true), gettype($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get TYPE value
     * @return string|null
     */
    public function getTYPE()
    {
        return $this->TYPE;
    }
    /**
     * Set TYPE value
     * @uses \EnumType\TradeDiscountTypeType::valueIsValid()
     * @uses \EnumType\TradeDiscountTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tYPE
     * @return \StructType\AddTradeDiscountType
     */
    public function setTYPE($tYPE = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TradeDiscountTypeType::valueIsValid($tYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TradeDiscountTypeType', is_array($tYPE) ? implode(', ', $tYPE) : var_export($tYPE, true), implode(', ', \EnumType\TradeDiscountTypeType::getValidValues())), __LINE__);
        }
        $this->TYPE = $tYPE;
        return $this;
    }
    /**
     * Get ACTIVE value
     * @return string|null
     */
    public function getACTIVE()
    {
        return $this->ACTIVE;
    }
    /**
     * Set ACTIVE value
     * @uses \EnumType\YesNoStringType::valueIsValid()
     * @uses \EnumType\YesNoStringType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $aCTIVE
     * @return \StructType\AddTradeDiscountType
     */
    public function setACTIVE($aCTIVE = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoStringType::valueIsValid($aCTIVE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\YesNoStringType', is_array($aCTIVE) ? implode(', ', $aCTIVE) : var_export($aCTIVE, true), implode(', ', \EnumType\YesNoStringType::getValidValues())), __LINE__);
        }
        $this->ACTIVE = $aCTIVE;
        return $this;
    }
    /**
     * Get DELETED value
     * @return string|null
     */
    public function getDELETED()
    {
        return $this->DELETED;
    }
    /**
     * Set DELETED value
     * @uses \EnumType\YesNoStringType::valueIsValid()
     * @uses \EnumType\YesNoStringType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dELETED
     * @return \StructType\AddTradeDiscountType
     */
    public function setDELETED($dELETED = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoStringType::valueIsValid($dELETED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\YesNoStringType', is_array($dELETED) ? implode(', ', $dELETED) : var_export($dELETED, true), implode(', ', \EnumType\YesNoStringType::getValidValues())), __LINE__);
        }
        $this->DELETED = $dELETED;
        return $this;
    }
    /**
     * Get REFERENCE value
     * @return string|null
     */
    public function getREFERENCE()
    {
        return $this->REFERENCE;
    }
    /**
     * Set REFERENCE value
     * @param string $rEFERENCE
     * @return \StructType\AddTradeDiscountType
     */
    public function setREFERENCE($rEFERENCE = null)
    {
        // validation for constraint: string
        if (!is_null($rEFERENCE) && !is_string($rEFERENCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rEFERENCE, true), gettype($rEFERENCE)), __LINE__);
        }
        $this->REFERENCE = $rEFERENCE;
        return $this;
    }
    /**
     * Get PRODUCTS value
     * @return \StructType\PRODUCTS|null
     */
    public function getPRODUCTS()
    {
        return $this->PRODUCTS;
    }
    /**
     * Set PRODUCTS value
     * @param \StructType\PRODUCTS $pRODUCTS
     * @return \StructType\AddTradeDiscountType
     */
    public function setPRODUCTS(\StructType\PRODUCTS $pRODUCTS = null)
    {
        $this->PRODUCTS = $pRODUCTS;
        return $this;
    }
    /**
     * Get CUSTOMER_GROUPS value
     * @return \StructType\CUSTOMER_GROUPS|null
     */
    public function getCUSTOMER_GROUPS()
    {
        return $this->CUSTOMER_GROUPS;
    }
    /**
     * Set CUSTOMER_GROUPS value
     * @param \StructType\CUSTOMER_GROUPS $cUSTOMER_GROUPS
     * @return \StructType\AddTradeDiscountType
     */
    public function setCUSTOMER_GROUPS(\StructType\CUSTOMER_GROUPS $cUSTOMER_GROUPS = null)
    {
        $this->CUSTOMER_GROUPS = $cUSTOMER_GROUPS;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddTradeDiscountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
