<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Modify ServiceType
 * @subpackage Services
 */
class Modify extends AbstractSoapClientBase
{
    /**
     * Sets the VSAuthType SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\VSAuthType $vSAuthType
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderVSAuthType(\StructType\VSAuthType $vSAuthType, $nameSpace = 'https://demo.visualsoft.co.uk/api/soap/service/5', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'VSAuthType', $vSAuthType, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ModifyCustomerGroup
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://demo.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: \StructType\VSAuthType
     * - SOAPHeaders: required
     * - documentation: Modify an existing Customer Group
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCustomerGroupType $customer_group
     * @return \StructType\ResultType|bool
     */
    public function ModifyCustomerGroup(\StructType\AddCustomerGroupType $customer_group)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifyCustomerGroup($customer_group));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifyTradeDiscount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://demo.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: \StructType\VSAuthType
     * - SOAPHeaders: required
     * - documentation: Update an existing Trade Discounts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTradeDiscountType $trade_discount
     * @return \StructType\ResultType|bool
     */
    public function ModifyTradeDiscount(\StructType\AddTradeDiscountType $trade_discount)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifyTradeDiscount($trade_discount));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifyNewsletterSubscriber
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://demo.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: \StructType\VSAuthType
     * - SOAPHeaders: required
     * - documentation: Modify an existing Newsletter subscriber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyNewsletterSubscriberType $subscriber_data
     * @return \StructType\ResultType|bool
     */
    public function ModifyNewsletterSubscriber(\StructType\ModifyNewsletterSubscriberType $subscriber_data)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifyNewsletterSubscriber($subscriber_data));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResultType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
