<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import ServiceType
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Sets the VSAuthType SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\VSAuthType $vSAuthType
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderVSAuthType(\StructType\VSAuthType $vSAuthType, $nameSpace = 'https://demo.visualsoft.co.uk/api/soap/service/5', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'VSAuthType', $vSAuthType, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ImportOrders
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://demo.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: \StructType\VSAuthType
     * - SOAPHeaders: required
     * - documentation: Import an order.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $order_data
     * @return \StructType\ResultType|bool
     */
    public function ImportOrders($order_data)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportOrders($order_data));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://demo.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: \StructType\VSAuthType
     * - SOAPHeaders: required
     * - documentation: Import a customer array
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportCustomerType $importcustomer
     * @return \StructType\ResultType|bool
     */
    public function ImportCustomer(\StructType\ImportCustomerType $importcustomer)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportCustomer($importcustomer));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResultType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
