<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Sets the VSAuthType SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\VSAuthType $vSAuthType
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderVSAuthType(\StructType\VSAuthType $vSAuthType, $nameSpace = 'https://demo.visualsoft.co.uk/api/soap/service/5', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'VSAuthType', $vSAuthType, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AddStock
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://demo.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: \StructType\VSAuthType
     * - SOAPHeaders: required
     * - documentation: Increase the stock level, by the given amount, for the given product reference.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $product_reference
     * @param string $stock_to_add
     * @return \StructType\ResultType|bool
     */
    public function AddStock($product_reference, $stock_to_add)
    {
        try {
            $this->setResult($this->getSoapClient()->AddStock($product_reference, $stock_to_add));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddCustomerGroup
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://demo.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: \StructType\VSAuthType
     * - SOAPHeaders: required
     * - documentation: Add a Customer Group
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCustomerGroupType $customer_group
     * @return \StructType\ResultType|bool
     */
    public function AddCustomerGroup(\StructType\AddCustomerGroupType $customer_group)
    {
        try {
            $this->setResult($this->getSoapClient()->AddCustomerGroup($customer_group));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddTradeDiscount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://demo.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: \StructType\VSAuthType
     * - SOAPHeaders: required
     * - documentation: Add a new Trade Discounts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTradeDiscountType $trade_discount
     * @return \StructType\ResultType|bool
     */
    public function AddTradeDiscount(\StructType\AddTradeDiscountType $trade_discount)
    {
        try {
            $this->setResult($this->getSoapClient()->AddTradeDiscount($trade_discount));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddNewsletterSubscriber
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: VSAuthType
     * - SOAPHeaderNamespaces: https://demo.visualsoft.co.uk/api/soap/service/5
     * - SOAPHeaderTypes: \StructType\VSAuthType
     * - SOAPHeaders: required
     * - documentation: Add a Newsletter subscriber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewsletterSubscriberType $subscriber_data
     * @return \StructType\ResultType|bool
     */
    public function AddNewsletterSubscriber(\StructType\NewsletterSubscriberType $subscriber_data)
    {
        try {
            $this->setResult($this->getSoapClient()->AddNewsletterSubscriber($subscriber_data));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResultType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
