<?php

namespace EnumType;

/**
 * This class stands for TradeDiscountTypeType EnumType
 * @subpackage Enumerations
 */
class TradeDiscountTypeType
{
    /**
     * Constant for value 'percent'
     * @return string 'percent'
     */
    const VALUE_PERCENT = 'percent';
    /**
     * Constant for value 'percent_full_price'
     * @return string 'percent_full_price'
     */
    const VALUE_PERCENT_FULL_PRICE = 'percent_full_price';
    /**
     * Constant for value 'fixed'
     * @return string 'fixed'
     */
    const VALUE_FIXED = 'fixed';
    /**
     * Constant for value 'fixed_price'
     * @return string 'fixed_price'
     */
    const VALUE_FIXED_PRICE = 'fixed_price';
    /**
     * Constant for value 'cheapest_price'
     * @return string 'cheapest_price'
     */
    const VALUE_CHEAPEST_PRICE = 'cheapest_price';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PERCENT
     * @uses self::VALUE_PERCENT_FULL_PRICE
     * @uses self::VALUE_FIXED
     * @uses self::VALUE_FIXED_PRICE
     * @uses self::VALUE_CHEAPEST_PRICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PERCENT,
            self::VALUE_PERCENT_FULL_PRICE,
            self::VALUE_FIXED,
            self::VALUE_FIXED_PRICE,
            self::VALUE_CHEAPEST_PRICE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
