<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for authentication StructType
 * @subpackage Structs
 */
class Authentication extends AbstractStructBase
{
    /**
     * The dialog
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Dialog
     */
    public $dialog;
    /**
     * The method
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $method;
    /**
     * The artifact
     * @var bool
     */
    public $artifact;
    /**
     * Constructor method for authentication
     * @uses Authentication::setDialog()
     * @uses Authentication::setMethod()
     * @uses Authentication::setArtifact()
     * @param \StructType\Dialog $dialog
     * @param string[] $method
     * @param bool $artifact
     */
    public function __construct(\StructType\Dialog $dialog = null, array $method = array(), $artifact = null)
    {
        $this
            ->setDialog($dialog)
            ->setMethod($method)
            ->setArtifact($artifact);
    }
    /**
     * Get dialog value
     * @return \StructType\Dialog|null
     */
    public function getDialog()
    {
        return $this->dialog;
    }
    /**
     * Set dialog value
     * @param \StructType\Dialog $dialog
     * @return \StructType\Authentication
     */
    public function setDialog(\StructType\Dialog $dialog = null)
    {
        $this->dialog = $dialog;
        return $this;
    }
    /**
     * Get method value
     * @return string[]|null
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * This method is responsible for validating the values passed to the setMethod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMethod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMethodForArrayConstraintsFromSetMethod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $authenticationMethodItem) {
            // validation for constraint: itemType
            if (!is_string($authenticationMethodItem)) {
                $invalidValues[] = is_object($authenticationMethodItem) ? get_class($authenticationMethodItem) : sprintf('%s(%s)', gettype($authenticationMethodItem), var_export($authenticationMethodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The method property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set method value
     * @throws \InvalidArgumentException
     * @param string[] $method
     * @return \StructType\Authentication
     */
    public function setMethod(array $method = array())
    {
        // validation for constraint: array
        if ('' !== ($methodArrayErrorMessage = self::validateMethodForArrayConstraintsFromSetMethod($method))) {
            throw new \InvalidArgumentException($methodArrayErrorMessage, __LINE__);
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Add item to method value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Authentication
     */
    public function addToMethod($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The method property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->method[] = $item;
        return $this;
    }
    /**
     * Get artifact value
     * @return bool|null
     */
    public function getArtifact()
    {
        return $this->artifact;
    }
    /**
     * Set artifact value
     * @param bool $artifact
     * @return \StructType\Authentication
     */
    public function setArtifact($artifact = null)
    {
        // validation for constraint: boolean
        if (!is_null($artifact) && !is_bool($artifact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($artifact, true), gettype($artifact)), __LINE__);
        }
        $this->artifact = $artifact;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Authentication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
