<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for form StructType
 * @subpackage Structs
 */
class Form extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The input_param
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Form_param[]
     */
    public $input_param;
    /**
     * Constructor method for form
     * @uses Form::setId()
     * @uses Form::setInput_param()
     * @param string $id
     * @param \StructType\Form_param[] $input_param
     */
    public function __construct($id = null, array $input_param = array())
    {
        $this
            ->setId($id)
            ->setInput_param($input_param);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Form
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get input_param value
     * @return \StructType\Form_param[]|null
     */
    public function getInput_param()
    {
        return $this->{'input-param'};
    }
    /**
     * This method is responsible for validating the values passed to the setInput_param method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInput_param method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInput_paramForArrayConstraintsFromSetInput_param(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $formInput_paramItem) {
            // validation for constraint: itemType
            if (!$formInput_paramItem instanceof \StructType\Form_param) {
                $invalidValues[] = is_object($formInput_paramItem) ? get_class($formInput_paramItem) : sprintf('%s(%s)', gettype($formInput_paramItem), var_export($formInput_paramItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The input_param property can only contain items of type \StructType\Form_param, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set input_param value
     * @throws \InvalidArgumentException
     * @param \StructType\Form_param[] $input_param
     * @return \StructType\Form
     */
    public function setInput_param(array $input_param = array())
    {
        // validation for constraint: array
        if ('' !== ($input_paramArrayErrorMessage = self::validateInput_paramForArrayConstraintsFromSetInput_param($input_param))) {
            throw new \InvalidArgumentException($input_paramArrayErrorMessage, __LINE__);
        }
        $this->input_param = $this->{'input-param'} = $input_param;
        return $this;
    }
    /**
     * Add item to input_param value
     * @throws \InvalidArgumentException
     * @param \StructType\Form_param $item
     * @return \StructType\Form
     */
    public function addToInput_param(\StructType\Form_param $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Form_param) {
            throw new \InvalidArgumentException(sprintf('The input_param property can only contain items of type \StructType\Form_param, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->input_param[] = $this->{'input-param'}[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Form
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
