<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packaging-task StructType
 * @subpackage Structs
 */
class Packaging_task extends AbstractStructBase
{
    /**
     * The packaging_task_id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $packaging_task_id;
    /**
     * The method
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $method;
    /**
     * The packaging_notification
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Notification[]
     */
    public $packaging_notification;
    /**
     * The packaging_task_document
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Packaging_task_document[]
     */
    public $packaging_task_document;
    /**
     * The packaging_task_lookup_document
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Packaging_task_lookup_document[]
     */
    public $packaging_task_lookup_document;
    /**
     * The send_to_archive
     * @var bool
     */
    public $send_to_archive;
    /**
     * Constructor method for packaging-task
     * @uses Packaging_task::setPackaging_task_id()
     * @uses Packaging_task::setMethod()
     * @uses Packaging_task::setPackaging_notification()
     * @uses Packaging_task::setPackaging_task_document()
     * @uses Packaging_task::setPackaging_task_lookup_document()
     * @uses Packaging_task::setSend_to_archive()
     * @param string $packaging_task_id
     * @param string $method
     * @param \StructType\Notification[] $packaging_notification
     * @param \StructType\Packaging_task_document[] $packaging_task_document
     * @param \StructType\Packaging_task_lookup_document[] $packaging_task_lookup_document
     * @param bool $send_to_archive
     */
    public function __construct($packaging_task_id = null, $method = null, array $packaging_notification = array(), array $packaging_task_document = array(), array $packaging_task_lookup_document = array(), $send_to_archive = null)
    {
        $this
            ->setPackaging_task_id($packaging_task_id)
            ->setMethod($method)
            ->setPackaging_notification($packaging_notification)
            ->setPackaging_task_document($packaging_task_document)
            ->setPackaging_task_lookup_document($packaging_task_lookup_document)
            ->setSend_to_archive($send_to_archive);
    }
    /**
     * Get packaging_task_id value
     * @return string
     */
    public function getPackaging_task_id()
    {
        return $this->{'packaging-task-id'};
    }
    /**
     * Set packaging_task_id value
     * @param string $packaging_task_id
     * @return \StructType\Packaging_task
     */
    public function setPackaging_task_id($packaging_task_id = null)
    {
        // validation for constraint: string
        if (!is_null($packaging_task_id) && !is_string($packaging_task_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packaging_task_id, true), gettype($packaging_task_id)), __LINE__);
        }
        $this->packaging_task_id = $this->{'packaging-task-id'} = $packaging_task_id;
        return $this;
    }
    /**
     * Get method value
     * @return string
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @param string $method
     * @return \StructType\Packaging_task
     */
    public function setMethod($method = null)
    {
        // validation for constraint: string
        if (!is_null($method) && !is_string($method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($method, true), gettype($method)), __LINE__);
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Get packaging_notification value
     * @return \StructType\Notification[]|null
     */
    public function getPackaging_notification()
    {
        return $this->{'packaging-notification'};
    }
    /**
     * This method is responsible for validating the values passed to the setPackaging_notification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackaging_notification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackaging_notificationForArrayConstraintsFromSetPackaging_notification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packaging_taskPackaging_notificationItem) {
            // validation for constraint: itemType
            if (!$packaging_taskPackaging_notificationItem instanceof \StructType\Notification) {
                $invalidValues[] = is_object($packaging_taskPackaging_notificationItem) ? get_class($packaging_taskPackaging_notificationItem) : sprintf('%s(%s)', gettype($packaging_taskPackaging_notificationItem), var_export($packaging_taskPackaging_notificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The packaging_notification property can only contain items of type \StructType\Notification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set packaging_notification value
     * @throws \InvalidArgumentException
     * @param \StructType\Notification[] $packaging_notification
     * @return \StructType\Packaging_task
     */
    public function setPackaging_notification(array $packaging_notification = array())
    {
        // validation for constraint: array
        if ('' !== ($packaging_notificationArrayErrorMessage = self::validatePackaging_notificationForArrayConstraintsFromSetPackaging_notification($packaging_notification))) {
            throw new \InvalidArgumentException($packaging_notificationArrayErrorMessage, __LINE__);
        }
        $this->packaging_notification = $this->{'packaging-notification'} = $packaging_notification;
        return $this;
    }
    /**
     * Add item to packaging_notification value
     * @throws \InvalidArgumentException
     * @param \StructType\Notification $item
     * @return \StructType\Packaging_task
     */
    public function addToPackaging_notification(\StructType\Notification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Notification) {
            throw new \InvalidArgumentException(sprintf('The packaging_notification property can only contain items of type \StructType\Notification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->packaging_notification[] = $this->{'packaging-notification'}[] = $item;
        return $this;
    }
    /**
     * Get packaging_task_document value
     * @return \StructType\Packaging_task_document[]|null
     */
    public function getPackaging_task_document()
    {
        return $this->{'packaging-task-document'};
    }
    /**
     * This method is responsible for validating the values passed to the setPackaging_task_document method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackaging_task_document method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackaging_task_documentForArrayConstraintsFromSetPackaging_task_document(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packaging_taskPackaging_task_documentItem) {
            // validation for constraint: itemType
            if (!$packaging_taskPackaging_task_documentItem instanceof \StructType\Packaging_task_document) {
                $invalidValues[] = is_object($packaging_taskPackaging_task_documentItem) ? get_class($packaging_taskPackaging_task_documentItem) : sprintf('%s(%s)', gettype($packaging_taskPackaging_task_documentItem), var_export($packaging_taskPackaging_task_documentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The packaging_task_document property can only contain items of type \StructType\Packaging_task_document, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set packaging_task_document value
     * @throws \InvalidArgumentException
     * @param \StructType\Packaging_task_document[] $packaging_task_document
     * @return \StructType\Packaging_task
     */
    public function setPackaging_task_document(array $packaging_task_document = array())
    {
        // validation for constraint: array
        if ('' !== ($packaging_task_documentArrayErrorMessage = self::validatePackaging_task_documentForArrayConstraintsFromSetPackaging_task_document($packaging_task_document))) {
            throw new \InvalidArgumentException($packaging_task_documentArrayErrorMessage, __LINE__);
        }
        $this->packaging_task_document = $this->{'packaging-task-document'} = $packaging_task_document;
        return $this;
    }
    /**
     * Add item to packaging_task_document value
     * @throws \InvalidArgumentException
     * @param \StructType\Packaging_task_document $item
     * @return \StructType\Packaging_task
     */
    public function addToPackaging_task_document(\StructType\Packaging_task_document $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Packaging_task_document) {
            throw new \InvalidArgumentException(sprintf('The packaging_task_document property can only contain items of type \StructType\Packaging_task_document, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->packaging_task_document[] = $this->{'packaging-task-document'}[] = $item;
        return $this;
    }
    /**
     * Get packaging_task_lookup_document value
     * @return \StructType\Packaging_task_lookup_document[]|null
     */
    public function getPackaging_task_lookup_document()
    {
        return $this->{'packaging-task-lookup-document'};
    }
    /**
     * This method is responsible for validating the values passed to the setPackaging_task_lookup_document method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackaging_task_lookup_document method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackaging_task_lookup_documentForArrayConstraintsFromSetPackaging_task_lookup_document(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packaging_taskPackaging_task_lookup_documentItem) {
            // validation for constraint: itemType
            if (!$packaging_taskPackaging_task_lookup_documentItem instanceof \StructType\Packaging_task_lookup_document) {
                $invalidValues[] = is_object($packaging_taskPackaging_task_lookup_documentItem) ? get_class($packaging_taskPackaging_task_lookup_documentItem) : sprintf('%s(%s)', gettype($packaging_taskPackaging_task_lookup_documentItem), var_export($packaging_taskPackaging_task_lookup_documentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The packaging_task_lookup_document property can only contain items of type \StructType\Packaging_task_lookup_document, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set packaging_task_lookup_document value
     * @throws \InvalidArgumentException
     * @param \StructType\Packaging_task_lookup_document[] $packaging_task_lookup_document
     * @return \StructType\Packaging_task
     */
    public function setPackaging_task_lookup_document(array $packaging_task_lookup_document = array())
    {
        // validation for constraint: array
        if ('' !== ($packaging_task_lookup_documentArrayErrorMessage = self::validatePackaging_task_lookup_documentForArrayConstraintsFromSetPackaging_task_lookup_document($packaging_task_lookup_document))) {
            throw new \InvalidArgumentException($packaging_task_lookup_documentArrayErrorMessage, __LINE__);
        }
        $this->packaging_task_lookup_document = $this->{'packaging-task-lookup-document'} = $packaging_task_lookup_document;
        return $this;
    }
    /**
     * Add item to packaging_task_lookup_document value
     * @throws \InvalidArgumentException
     * @param \StructType\Packaging_task_lookup_document $item
     * @return \StructType\Packaging_task
     */
    public function addToPackaging_task_lookup_document(\StructType\Packaging_task_lookup_document $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Packaging_task_lookup_document) {
            throw new \InvalidArgumentException(sprintf('The packaging_task_lookup_document property can only contain items of type \StructType\Packaging_task_lookup_document, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->packaging_task_lookup_document[] = $this->{'packaging-task-lookup-document'}[] = $item;
        return $this;
    }
    /**
     * Get send_to_archive value
     * @return bool|null
     */
    public function getSend_to_archive()
    {
        return $this->{'send-to-archive'};
    }
    /**
     * Set send_to_archive value
     * @param bool $send_to_archive
     * @return \StructType\Packaging_task
     */
    public function setSend_to_archive($send_to_archive = null)
    {
        // validation for constraint: boolean
        if (!is_null($send_to_archive) && !is_bool($send_to_archive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($send_to_archive, true), gettype($send_to_archive)), __LINE__);
        }
        $this->send_to_archive = $this->{'send-to-archive'} = $send_to_archive;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Packaging_task
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
