<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for lookup-task StructType
 * @subpackage Structs
 */
class Lookup_task extends AbstractStructBase
{
    /**
     * The lookup_task_id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $lookup_task_id;
    /**
     * The method
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $method;
    /**
     * The search_attribute
     * @var string
     */
    public $search_attribute;
    /**
     * Constructor method for lookup-task
     * @uses Lookup_task::setLookup_task_id()
     * @uses Lookup_task::setMethod()
     * @uses Lookup_task::setSearch_attribute()
     * @param string $lookup_task_id
     * @param string $method
     * @param string $search_attribute
     */
    public function __construct($lookup_task_id = null, $method = null, $search_attribute = null)
    {
        $this
            ->setLookup_task_id($lookup_task_id)
            ->setMethod($method)
            ->setSearch_attribute($search_attribute);
    }
    /**
     * Get lookup_task_id value
     * @return string
     */
    public function getLookup_task_id()
    {
        return $this->{'lookup-task-id'};
    }
    /**
     * Set lookup_task_id value
     * @param string $lookup_task_id
     * @return \StructType\Lookup_task
     */
    public function setLookup_task_id($lookup_task_id = null)
    {
        // validation for constraint: string
        if (!is_null($lookup_task_id) && !is_string($lookup_task_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lookup_task_id, true), gettype($lookup_task_id)), __LINE__);
        }
        $this->lookup_task_id = $this->{'lookup-task-id'} = $lookup_task_id;
        return $this;
    }
    /**
     * Get method value
     * @return string
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @param string $method
     * @return \StructType\Lookup_task
     */
    public function setMethod($method = null)
    {
        // validation for constraint: string
        if (!is_null($method) && !is_string($method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($method, true), gettype($method)), __LINE__);
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Get search_attribute value
     * @return string|null
     */
    public function getSearch_attribute()
    {
        return $this->{'search-attribute'};
    }
    /**
     * Set search_attribute value
     * @param string $search_attribute
     * @return \StructType\Lookup_task
     */
    public function setSearch_attribute($search_attribute = null)
    {
        // validation for constraint: string
        if (!is_null($search_attribute) && !is_string($search_attribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($search_attribute, true), gettype($search_attribute)), __LINE__);
        }
        $this->search_attribute = $this->{'search-attribute'} = $search_attribute;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Lookup_task
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
