<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClickTransaction StructType
 * @subpackage Structs
 */
class ClickTransaction extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The campaign
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var \StructType\Campaign
     */
    public $campaign;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $reference;
    /**
     * The transactionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $transactionType;
    /**
     * The transactionStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $transactionStatus;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The commission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var float
     */
    public $commission;
    /**
     * The registrationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $registrationDate;
    /**
     * The refererURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $refererURL;
    /**
     * The paidOut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var bool
     */
    public $paidOut;
    /**
     * Constructor method for ClickTransaction
     * @uses ClickTransaction::setID()
     * @uses ClickTransaction::setCampaign()
     * @uses ClickTransaction::setReference()
     * @uses ClickTransaction::setTransactionType()
     * @uses ClickTransaction::setTransactionStatus()
     * @uses ClickTransaction::setCurrency()
     * @uses ClickTransaction::setCommission()
     * @uses ClickTransaction::setRegistrationDate()
     * @uses ClickTransaction::setRefererURL()
     * @uses ClickTransaction::setPaidOut()
     * @param int $iD
     * @param \StructType\Campaign $campaign
     * @param string $reference
     * @param string $transactionType
     * @param string $transactionStatus
     * @param string $currency
     * @param float $commission
     * @param string $registrationDate
     * @param string $refererURL
     * @param bool $paidOut
     */
    public function __construct($iD = null, \StructType\Campaign $campaign = null, $reference = null, $transactionType = null, $transactionStatus = null, $currency = null, $commission = null, $registrationDate = null, $refererURL = null, $paidOut = null)
    {
        $this
            ->setID($iD)
            ->setCampaign($campaign)
            ->setReference($reference)
            ->setTransactionType($transactionType)
            ->setTransactionStatus($transactionStatus)
            ->setCurrency($currency)
            ->setCommission($commission)
            ->setRegistrationDate($registrationDate)
            ->setRefererURL($refererURL)
            ->setPaidOut($paidOut);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\ClickTransaction
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get campaign value
     * @return \StructType\Campaign|null
     */
    public function getCampaign()
    {
        return $this->campaign;
    }
    /**
     * Set campaign value
     * @param \StructType\Campaign $campaign
     * @return \StructType\ClickTransaction
     */
    public function setCampaign(\StructType\Campaign $campaign = null)
    {
        $this->campaign = $campaign;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\ClickTransaction
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get transactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->transactionType;
    }
    /**
     * Set transactionType value
     * @uses \EnumType\TransactionType::valueIsValid()
     * @uses \EnumType\TransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionType
     * @return \StructType\ClickTransaction
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionType::valueIsValid($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionType, implode(', ', \EnumType\TransactionType::getValidValues())), __LINE__);
        }
        $this->transactionType = $transactionType;
        return $this;
    }
    /**
     * Get transactionStatus value
     * @return string|null
     */
    public function getTransactionStatus()
    {
        return $this->transactionStatus;
    }
    /**
     * Set transactionStatus value
     * @uses \EnumType\TransactionStatus::valueIsValid()
     * @uses \EnumType\TransactionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatus
     * @return \StructType\ClickTransaction
     */
    public function setTransactionStatus($transactionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionStatus::valueIsValid($transactionStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionStatus, implode(', ', \EnumType\TransactionStatus::getValidValues())), __LINE__);
        }
        $this->transactionStatus = $transactionStatus;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\ClickTransaction
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get commission value
     * @return float|null
     */
    public function getCommission()
    {
        return $this->commission;
    }
    /**
     * Set commission value
     * @param float $commission
     * @return \StructType\ClickTransaction
     */
    public function setCommission($commission = null)
    {
        $this->commission = $commission;
        return $this;
    }
    /**
     * Get registrationDate value
     * @return string|null
     */
    public function getRegistrationDate()
    {
        return $this->registrationDate;
    }
    /**
     * Set registrationDate value
     * @param string $registrationDate
     * @return \StructType\ClickTransaction
     */
    public function setRegistrationDate($registrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDate) && !is_string($registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationDate)), __LINE__);
        }
        $this->registrationDate = $registrationDate;
        return $this;
    }
    /**
     * Get refererURL value
     * @return string|null
     */
    public function getRefererURL()
    {
        return $this->refererURL;
    }
    /**
     * Set refererURL value
     * @param string $refererURL
     * @return \StructType\ClickTransaction
     */
    public function setRefererURL($refererURL = null)
    {
        // validation for constraint: string
        if (!is_null($refererURL) && !is_string($refererURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refererURL)), __LINE__);
        }
        $this->refererURL = $refererURL;
        return $this;
    }
    /**
     * Get paidOut value
     * @return bool|null
     */
    public function getPaidOut()
    {
        return $this->paidOut;
    }
    /**
     * Set paidOut value
     * @param bool $paidOut
     * @return \StructType\ClickTransaction
     */
    public function setPaidOut($paidOut = null)
    {
        $this->paidOut = $paidOut;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClickTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
